/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.comb.FscNotificationAutoSignCombService;
import com.tydic.pfscext.api.comb.bo.FscNotificationAutoSignCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscNotificationAutoSignCombRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.service.busi.BusiInvoiceAutoSignService;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignReqBO;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignRspBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.comb.FscNotificationAutoSignCombService"})
public class FscNotificationAutoSignCombServiceImpl
implements FscNotificationAutoSignCombService {
    private static final Logger log = LoggerFactory.getLogger(FscNotificationAutoSignCombServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BusiInvoiceAutoSignService busiInvoiceAutoSignService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Value(value="${AUTO_SIGN_DAYS:7}")
    private Integer autoSignDay;
    @Value(value="${AUTO_SIGN_LIMIT_NUM:10}")
    private Long limitNum;
    @Value(value="${SIGN_FAIL_MAX_COUNT:3}")
    private Long signFailMaxCount;

    @PostMapping(value={"dealNotificationAutoSign"})
    public FscNotificationAutoSignCombRspBO dealNotificationAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBO) {
        FscNotificationAutoSignCombRspBO rspBO = new FscNotificationAutoSignCombRspBO();
        List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.qryNotificationAutoSign(this.autoSignDay, this.limitNum, this.signFailMaxCount);
        if (!CollectionUtils.isEmpty(billNotificationInfos)) {
            for (BillNotificationInfo billNotificationInfo : billNotificationInfos) {
                try {
                    BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBO = new BusiInvoiceAutoSignReqBO();
                    busiInvoiceAutoSignReqBO.setNotificationNo(billNotificationInfo.getNotificationNo());
                    BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBO = this.busiInvoiceAutoSignService.dealNotifitionSign(busiInvoiceAutoSignReqBO);
                    log.error("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u8fd4\u56de\u5bf9\u8c61:" + JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBO)));
                }
                catch (Exception e) {
                    log.error("\u64ae\u5408\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5f02\u5e38");
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210");
        return rspBO;
    }

    @PostMapping(value={"dealApplyAutoSign"})
    public FscNotificationAutoSignCombRspBO dealApplyAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBO) {
        FscNotificationAutoSignCombRspBO rspBO = new FscNotificationAutoSignCombRspBO();
        List<BillApplyInfoVO> billApplyInfos = this.billApplyInfoMapper.qryApplyAutoSign(this.autoSignDay, this.limitNum, this.signFailMaxCount);
        if (!CollectionUtils.isEmpty(billApplyInfos)) {
            for (BillApplyInfoVO billApplyInfoVO : billApplyInfos) {
                try {
                    BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBO = new BusiInvoiceAutoSignReqBO();
                    busiInvoiceAutoSignReqBO.setApplyNo(billApplyInfoVO.getApplyNo());
                    BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBO = this.busiInvoiceAutoSignService.dealApplySign(busiInvoiceAutoSignReqBO);
                    log.error("\u7edf\u7b7e\u81ea\u52a8\u7b7e\u6536\u8fd4\u56de\u5bf9\u8c61:" + JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBO)));
                }
                catch (Exception e) {
                    log.error("\u7edf\u7b7e\u4e0b\u6e38\u81ea\u52a8\u7b7e\u6536\u5f02\u5e38");
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5b8c\u6210");
        return rspBO;
    }

    @PostMapping(value={"dealApplyActAutoSign"})
    public FscNotificationAutoSignCombRspBO dealApplyActAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBO) {
        FscNotificationAutoSignCombRspBO rspBO = new FscNotificationAutoSignCombRspBO();
        List<BillApplyInfoVO> billApplyInfos = this.billApplyInfoMapper.qryApplyActAutoSign(this.autoSignDay, this.limitNum, this.signFailMaxCount);
        if (!CollectionUtils.isEmpty(billApplyInfos)) {
            for (BillApplyInfoVO billApplyInfoVO : billApplyInfos) {
                try {
                    BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBO = new BusiInvoiceAutoSignReqBO();
                    busiInvoiceAutoSignReqBO.setApplyNo(billApplyInfoVO.getApplyNo());
                    BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBO = this.busiInvoiceAutoSignService.dealApplySign(busiInvoiceAutoSignReqBO);
                    log.error("\u5458\u5de5\u798f\u5229\u81ea\u52a8\u7b7e\u6536\u8fd4\u56de\u5bf9\u8c61:" + JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBO)));
                }
                catch (Exception e) {
                    log.error("\u5458\u5de5\u798f\u5229\u81ea\u52a8\u7b7e\u6536\u5f02\u5e38");
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5b8c\u6210");
        return rspBO;
    }
}

