/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.busi.QueryPayPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoRspBO;
import com.tydic.pfscext.api.deal.BatchExceptionBillService;
import com.tydic.pfscext.api.deal.bo.ExportExceptionBillReqBO;
import com.tydic.pfscext.api.deal.bo.ExportExceptionBillRspBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BatchExceptionBillService"})
public class BatchExceptionBillServiceImpl
implements BatchExceptionBillService {
    private static final Logger log = LoggerFactory.getLogger(BatchExceptionBillServiceImpl.class);
    @Autowired
    private QueryPayPurchaseOrderInfoService queryPayPurchaseOrderInfoService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    private final String HEAD_STR = "\u6ce8\u610f\u4e8b\u9879\uff1a\u8ba2\u5355\u53f7\u548c\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7\u4e8c\u9009\u4e00\u586b\u5199\uff0c\u4e24\u9879\u90fd\u586b\u5199\u65f6\u53ea\u53d6\u8ba2\u5355\u53f7\uff0c\u5bfc\u5165\u540e\u5c06\u89c6\u4e3a\u8ba2\u5355\u5f00\u7968\u5b8c\u6210";

    @PostMapping(value={"exportExceptionBill"})
    public ExportExceptionBillRspBO exportExceptionBill(@RequestBody ExportExceptionBillReqBO reqBO) {
        String s = JSON.toJSONString((Object)reqBO);
        QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO = (QueryPayPurchaseOrderInfoReqBO)JSONObject.parseObject((String)s, QueryPayPurchaseOrderInfoReqBO.class);
        queryPayPurchaseOrderInfoReqBO.setPageNo(Integer.valueOf(-1));
        queryPayPurchaseOrderInfoReqBO.setPageSize(Integer.valueOf(-1));
        QueryPayPurchaseOrderInfoRspBO purchaseOrderInfoRspBO = this.queryPayPurchaseOrderInfoService.queryListPage(queryPayPurchaseOrderInfoReqBO);
        List rows = purchaseOrderInfoRspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            throw new PfscExtBusinessException("18000", "\u53ef\u5bfc\u51fa\u8ba2\u5355\u4e3a\u7a7a");
        }
        ExportExceptionBillRspBO rspBO = new ExportExceptionBillRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        for (PayPurchaseOrderInfoBO row : rows) {
            LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
            item.put("\u8ba2\u5355\u53f7", row.getPurchaseOrderCode() == null ? "" : row.getPurchaseOrderCode());
            item.put("\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7", row.getExtOrderId() == null ? "" : row.getExtOrderId());
            exportData.add(item);
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFileUrl(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, ExportExceptionBillRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbookWithHead(data, "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setFileName(fileName);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

