/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.deal.DealPurchaseCancelHangService;
import com.tydic.pfscext.api.deal.bo.DealPurchaseCancelHangServiceReqBO;
import com.tydic.pfscext.api.deal.bo.DealPurchaseCancelHangServiceRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.DealPurchaseCancelHangService"})
public class DealPurchaseCancelHangServiceImpl
implements DealPurchaseCancelHangService {
    private static final Logger log = LoggerFactory.getLogger(DealPurchaseCancelHangServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Value(value="${hangDays:14}")
    private Long hangDays;

    @PostMapping(value={"orderHangCancel"})
    public DealPurchaseCancelHangServiceRspBO orderHangCancel(@RequestBody DealPurchaseCancelHangServiceReqBO reqBO) {
        List<SaleOrderInfo> saleOrderInfoList;
        log.info("\u81ea\u52a8\u53d6\u6d88\u6302\u8d77\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb");
        DealPurchaseCancelHangServiceRspBO rspBO = new DealPurchaseCancelHangServiceRspBO();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectHangOrder(this.hangDays);
        if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                try {
                    PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
                    orderInfo.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                    orderInfo.setOrderId(payPurchaseOrderInfo.getOrderId());
                    orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    int count = this.payPurchaseOrderInfoMapper.updateByCancel(orderInfo);
                    if (count > 0) {
                        log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u6210\u529f");
                        continue;
                    }
                    log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355id=" + payPurchaseOrderInfo.getOrderId());
                }
                catch (Exception e) {
                    log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u5f02\u5e38\uff0c\u8ba2\u5355id=" + payPurchaseOrderInfo.getOrderId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(saleOrderInfoList = this.saleOrderInfoMapper.selectHangOrder(this.hangDays))) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                try {
                    SaleOrderInfo orderInfo = new SaleOrderInfo();
                    orderInfo.setInspectionId(saleOrderInfo.getInspectionId());
                    orderInfo.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
                    orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    orderInfo.setHangDate(null);
                    int count = this.saleOrderInfoMapper.updateByPrimaryKeySelective(orderInfo);
                    if (count > 0) {
                        log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u6210\u529f");
                        continue;
                    }
                    log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355id=" + saleOrderInfo.getOrderId());
                }
                catch (Exception e) {
                    log.info("\u53d6\u6d88\u6302\u8d77\u8ba2\u5355\u5f02\u5e38\uff0c\u8ba2\u5355id=" + saleOrderInfo.getOrderId());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u81ea\u52a8\u53d6\u6d88\u6302\u8d77\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
        return rspBO;
    }
}

