/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.pfscext.api.busi.BusiDealOutPushMsgService;
import com.tydic.pfscext.api.busi.bo.BusiDealOutPushMsgReqBO;
import com.tydic.pfscext.api.busi.bo.BusiDealOutPushMsgRspBO;
import com.tydic.pfscext.api.deal.FscDealOutPushMsgService;
import com.tydic.pfscext.api.deal.bo.FscDealOutPushMsgReqBO;
import com.tydic.pfscext.api.deal.bo.FscDealOutPushMsgRspBO;
import com.tydic.pfscext.dao.MsgPoolMapper;
import com.tydic.pfscext.dao.po.MsgPool;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.FscDealOutPushMsgService"})
public class FscDealOutPushMsgServiceImpl
implements FscDealOutPushMsgService {
    private static final Logger log = LoggerFactory.getLogger(FscDealOutPushMsgServiceImpl.class);
    @Autowired
    private MsgPoolMapper msgPoolMapper;
    @Autowired
    private BusiDealOutPushMsgService busiDealOutPushMsgService;

    @PostMapping(value={"dealOutPushMsg"})
    public FscDealOutPushMsgRspBO dealOutPushMsg(@RequestBody FscDealOutPushMsgReqBO reqBO) {
        FscDealOutPushMsgRspBO rspBO = new FscDealOutPushMsgRspBO();
        List<MsgPool> msgPoolPOS = this.qryMsgPoolList(reqBO);
        if (null != msgPoolPOS && !msgPoolPOS.isEmpty()) {
            for (MsgPool msgPoolPO : msgPoolPOS) {
                try {
                    BusiDealOutPushMsgReqBO busiDealOutPushMsgReqBO = new BusiDealOutPushMsgReqBO();
                    busiDealOutPushMsgReqBO.setMsgId(msgPoolPO.getMsgId());
                    busiDealOutPushMsgReqBO.setOrderId(msgPoolPO.getOrderId());
                    busiDealOutPushMsgReqBO.setSupplierId(msgPoolPO.getSupNo());
                    busiDealOutPushMsgReqBO.setStatus(msgPoolPO.getMsgState());
                    busiDealOutPushMsgReqBO.setRemark(msgPoolPO.getReserve1());
                    busiDealOutPushMsgReqBO.setId(msgPoolPO.getId());
                    BusiDealOutPushMsgRspBO busiDealOutPushMsgRspBO = this.busiDealOutPushMsgService.dealOutPushMsg(busiDealOutPushMsgReqBO);
                    log.info("\u6d88\u606fID\u4e3a[" + msgPoolPO.getMsgId() + "]\u7684\u6d88\u606f\u5904\u7406\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)busiDealOutPushMsgRspBO));
                }
                catch (Exception e) {
                    log.error("\u6d88\u606fID\u4e3a[" + msgPoolPO.getMsgId() + "]\u7684\u6d88\u606f\u5904\u7406\u5f02\u5e38");
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d88\u606f\u6c60\u79cd\u4fdd\u5b58\u7684\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private List<MsgPool> qryMsgPoolList(FscDealOutPushMsgReqBO reqBO) {
        Long supNo = reqBO.getGoodsSupplierId();
        ArrayList<Integer> runResultList = new ArrayList<Integer>();
        runResultList.add(PecConstant.OUT_MSG_RUN_RESULT.RUN_FAILURE);
        runResultList.add(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
        Integer failureCount = PecConstant.MAX_FAILURE_COUNT;
        return this.msgPoolMapper.getListByRunResultAndFailureCount(supNo, runResultList, failureCount);
    }
}

