/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.deal.QueryAutoInvoiceConfigService;
import com.tydic.pfscext.api.deal.bo.AutoInvoiceConfigExceptBO;
import com.tydic.pfscext.api.deal.bo.AutoInvoiceConfigInfoExtBO;
import com.tydic.pfscext.api.deal.bo.QueryAutoInvoiceConfigDetailReqBO;
import com.tydic.pfscext.api.deal.bo.QueryAutoInvoiceConfigDetailRspBO;
import com.tydic.pfscext.api.deal.bo.QueryAutoInvoiceConfigReqBO;
import com.tydic.pfscext.api.deal.bo.QueryAutoInvoiceConfigRspBO;
import com.tydic.pfscext.dao.AutoInvoiceConfigMapper;
import com.tydic.pfscext.dao.po.AutoInvoiceConfigExcept;
import com.tydic.pfscext.dao.po.AutoInvoiceConfigInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryAutoInvoiceConfigService"})
public class QueryAutoInvoiceConfigServiceImpl
implements QueryAutoInvoiceConfigService {
    private static final Logger logger = LoggerFactory.getLogger(QueryAutoInvoiceConfigServiceImpl.class);
    @Resource
    private AutoInvoiceConfigMapper autoInvoiceConfigMapper;

    @PostMapping(value={"queryAutoInvoiceConfigInfo"})
    public QueryAutoInvoiceConfigRspBO queryAutoInvoiceConfigInfo(@RequestBody QueryAutoInvoiceConfigReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryAutoInvoiceConfigRspBO rspBO = new QueryAutoInvoiceConfigRspBO();
        if (!"0".equals(reqBO.getIsProfessionalOrgExt())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return rspBO;
        }
        List<AutoInvoiceConfigInfo> list = this.autoInvoiceConfigMapper.queryAutoInvoiceConfigInfo();
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<AutoInvoiceConfigInfoExtBO> purchaseConfigList = new ArrayList<AutoInvoiceConfigInfoExtBO>();
            ArrayList<AutoInvoiceConfigInfoExtBO> operateConfigList = new ArrayList<AutoInvoiceConfigInfoExtBO>();
            for (AutoInvoiceConfigInfo info : list) {
                AutoInvoiceConfigInfoExtBO bo = new AutoInvoiceConfigInfoExtBO();
                BeanUtils.copyProperties((Object)info, (Object)bo);
                if ("1".equals(bo.getConfigStatus())) {
                    bo.setConfigStatusStr("\u542f\u7528");
                } else {
                    bo.setConfigStatusStr("\u505c\u7528");
                }
                if ("1".equals(bo.getTakeUpInvoice())) {
                    bo.setTakeUpInvoiceStr("\u662f");
                } else {
                    bo.setTakeUpInvoiceStr("\u5426");
                }
                if ("1".equals(bo.getConfigType())) {
                    purchaseConfigList.add(bo);
                    continue;
                }
                operateConfigList.add(bo);
            }
            rspBO.setPurchaseConfigList(purchaseConfigList);
            rspBO.setOperateConfigList(operateConfigList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return rspBO;
    }

    @PostMapping(value={"queryAutoInvoiceConfigDetail"})
    public QueryAutoInvoiceConfigDetailRspBO queryAutoInvoiceConfigDetail(@RequestBody QueryAutoInvoiceConfigDetailReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getConfigId() && reqBO.getConfigId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryAutoInvoiceConfigDetailRspBO rspBO = new QueryAutoInvoiceConfigDetailRspBO();
        AutoInvoiceConfigInfo configInfo = this.autoInvoiceConfigMapper.queryAutoInvoiceConfigInfoById(reqBO.getConfigId());
        if (null != configInfo) {
            BeanUtils.copyProperties((Object)configInfo, (Object)rspBO);
            if ("1".equals(configInfo.getConfigStatus())) {
                rspBO.setConfigStatusStr("\u542f\u7528");
            } else {
                rspBO.setConfigStatusStr("\u505c\u7528");
            }
            if ("1".equals(configInfo.getTakeUpInvoice())) {
                rspBO.setTakeUpInvoiceStr("\u662f");
            } else {
                rspBO.setTakeUpInvoiceStr("\u5426");
            }
            if ("1".equals(configInfo.getConfigType())) {
                Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
                List<AutoInvoiceConfigExcept> excepts = this.autoInvoiceConfigMapper.queryAutoInvoiceConfigExceptByConfigId(reqBO.getConfigId(), (Page<Map<String, Object>>)page);
                ArrayList<AutoInvoiceConfigExceptBO> boList = new ArrayList<AutoInvoiceConfigExceptBO>();
                for (AutoInvoiceConfigExcept except : excepts) {
                    AutoInvoiceConfigExceptBO bo = new AutoInvoiceConfigExceptBO();
                    BeanUtils.copyProperties((Object)except, (Object)bo);
                    if ("1".equals(except.getStatus())) {
                        bo.setStatusStr("\u542f\u7528");
                    } else {
                        bo.setStatusStr("\u505c\u7528");
                    }
                    if ("1".equals(except.getTakeUpInvoice())) {
                        bo.setTakeUpInvoiceStr("\u662f");
                    } else {
                        bo.setTakeUpInvoiceStr("\u5426");
                    }
                    boList.add(bo);
                }
                rspBO.setRows(boList);
                rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
                rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
                rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            }
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u67e5\u8be2\u8be6\u60c5\u65e0\u6570\u636e\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return rspBO;
    }
}

