/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.deal.QueryPayOrderInfoListService;
import com.tydic.pfscext.api.deal.bo.QueryPayOrderInfoReqBO;
import com.tydic.pfscext.api.deal.bo.QueryPayOrderInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.enums.PayOrderInfoType;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryPayOrderInfoListService"})
public class QueryPayOrderInfoListServiceImpl
implements QueryPayOrderInfoListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderInfoListServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;

    @PostMapping(value={"queryPayOrderInfoList"})
    public PfscExtRspPageBaseBO<QueryPayOrderInfoRspBO> queryPayOrderInfoList(@RequestBody QueryPayOrderInfoReqBO queryPayOrderInfoReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryPayOrderInfoReqBO));
        }
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        try {
            if (queryPayOrderInfoReqBO.getPayOrderTime() != null) {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                String time = sd.format(queryPayOrderInfoReqBO.getPayOrderTime());
                queryPayOrderInfoReqBO.setPayOrderYear(time.substring(0, 4));
                queryPayOrderInfoReqBO.setPayOrderMonth(time.substring(5, 7));
            }
            ArrayList<Long> payOrderIds = new ArrayList<Long>();
            Page page = new Page(queryPayOrderInfoReqBO.getPageNo().intValue(), queryPayOrderInfoReqBO.getPageSize().intValue());
            List<QueryPayOrderInfoRspBO> payOrderInfoPOs = null;
            payOrderInfoPOs = "5".equals(queryPayOrderInfoReqBO.getPayOrderStatus()) || "6".equals(queryPayOrderInfoReqBO.getPayOrderStatus()) ? this.payOrderInfoMapper.selectPageListAndBill(queryPayOrderInfoReqBO, (Page<Map<String, Object>>)page) : this.payOrderInfoMapper.selectPageList(queryPayOrderInfoReqBO, (Page<Map<String, Object>>)page);
            for (QueryPayOrderInfoRspBO queryPayOrderInfoRspBO2 : payOrderInfoPOs) {
                payOrderIds.add(queryPayOrderInfoRspBO2.getPayOrderId());
            }
            if (payOrderIds.size() > 0) {
                List queryPayOrderInfoRspBOs = payOrderInfoPOs.stream().map(queryPayOrderInfoRspBO -> {
                    String outOrderId;
                    PaymentFlowInfo paymentFlowInfo;
                    queryPayOrderInfoRspBO.setPayOrderStatusStr(PayOrderStatus.getInstance(queryPayOrderInfoRspBO.getPayOrderStatus()).getDescr());
                    if (queryPayOrderInfoRspBO.getPayOrderType() != null && !"".equals(queryPayOrderInfoRspBO.getPayOrderType())) {
                        queryPayOrderInfoRspBO.setPayOrderTypeStr(PayOrderInfoType.getInstance(queryPayOrderInfoRspBO.getPayOrderType()).getDescr());
                    }
                    if (queryPayOrderInfoRspBO.getPayType() != null && !"".equals(queryPayOrderInfoRspBO.getPayType())) {
                        queryPayOrderInfoRspBO.setPayTypeStr(PayFlowPayType.getInstance(queryPayOrderInfoRspBO.getPayType()).getDescr());
                    }
                    if (queryPayOrderInfoRspBO.getInvoiceClasses() != null) {
                        queryPayOrderInfoRspBO.setInvoiceClassesStr(InvoiceClasses.getInstance(queryPayOrderInfoRspBO.getInvoiceClasses().toString()).getDescr());
                    }
                    if (queryPayOrderInfoRspBO.getInvoiceType() != null && InvoiceType.getInstance(queryPayOrderInfoRspBO.getInvoiceType()) != null) {
                        queryPayOrderInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(queryPayOrderInfoRspBO.getInvoiceType()).getDescr());
                    }
                    if (queryPayOrderInfoRspBO.getBillStatus() != null) {
                        queryPayOrderInfoRspBO.setBillStatusStr(BillStatus.getInstance(queryPayOrderInfoRspBO.getBillStatus().toString()).getDescr());
                    }
                    if (queryPayOrderInfoRspBO.getPayChannel() != null && !"".equals(queryPayOrderInfoRspBO.getPayChannel())) {
                        queryPayOrderInfoRspBO.setPayChannelStr(PayChannel.getInstance(queryPayOrderInfoRspBO.getPayChannel()).getDescr());
                    }
                    try {
                        if (queryPayOrderInfoRspBO.getPayOrderYear() != null) {
                            SimpleDateFormat sdf;
                            if (queryPayOrderInfoRspBO.getPayOrderMonth() != null) {
                                sdf = new SimpleDateFormat("yyyy-MM");
                                String orderTime = queryPayOrderInfoRspBO.getPayOrderYear() + "-" + queryPayOrderInfoRspBO.getPayOrderMonth();
                                queryPayOrderInfoRspBO.setPayOrderTime(sdf.parse(orderTime));
                            } else {
                                sdf = new SimpleDateFormat("yyyy");
                                queryPayOrderInfoRspBO.setPayOrderTime(sdf.parse(queryPayOrderInfoRspBO.getPayOrderYear()));
                            }
                        }
                    }
                    catch (ParseException ee) {
                        LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)ee);
                        throw new PfscExtBusinessException("18000", "\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25");
                    }
                    if (!"7".equals(queryPayOrderInfoRspBO.getPayChannel()) && (paymentFlowInfo = this.paymentFlowInfoMapper.selectByOutOrderId(outOrderId = "SERVICE-FEE-" + queryPayOrderInfoRspBO.getPayOrderId())) != null) {
                        queryPayOrderInfoRspBO.setPayType(paymentFlowInfo.getPayType());
                        if (!StringUtils.isEmpty((CharSequence)paymentFlowInfo.getPayType())) {
                            queryPayOrderInfoRspBO.setPayTypeStr(PayFlowPayType.getInstance(paymentFlowInfo.getPayType()).getDescr());
                        }
                        queryPayOrderInfoRspBO.setPayChannel(paymentFlowInfo.getPayChannel());
                        if (!StringUtils.isBlank((CharSequence)paymentFlowInfo.getPayChannel()) && null != PayChannel.getInstance(paymentFlowInfo.getPayChannel())) {
                            queryPayOrderInfoRspBO.setPayChannelStr(PayChannel.getInstance(paymentFlowInfo.getPayChannel()).getDescr());
                        }
                    }
                    return queryPayOrderInfoRspBO;
                }).collect(Collectors.toList());
                rspPage.setRows(queryPayOrderInfoRspBOs);
                rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
                rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
                rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
        return rspPage;
    }
}

