/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.busi.bo.CheckApplyZeroTaxReqBO;
import com.tydic.pfscext.api.busi.bo.CheckApplyZeroTaxRspBO;
import com.tydic.pfscext.api.busi.bo.SaleItemInfoRepBO;
import com.tydic.pfscext.api.busi.bo.SaleItemInfoRspBO;
import com.tydic.pfscext.api.deal.QuerySaleItemInfoListService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleItemServfeeInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QuerySaleItemInfoListService"})
public class QuerySaleItemInfoListServiceImpl
implements QuerySaleItemInfoListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySaleItemInfoListServiceImpl.class);
    @Autowired
    private SaleItemServfeeInfoMapper saleItemServfeeInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    private final String DOWN_LOAD = "1";

    @PostMapping(value={"querySaleItemInfoList"})
    public PfscExtRspPageBaseBO<SaleItemInfoRspBO> querySaleItemInfoList(@RequestBody SaleItemInfoRepBO saleItemInfoRepBO) {
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        try {
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            BeanUtils.copyProperties((Object)saleItemInfoRepBO, (Object)saleItemInfoVO);
            Page page = new Page(saleItemInfoRepBO.getPageNo().intValue(), saleItemInfoRepBO.getPageSize().intValue());
            List<SaleItemInfo> saleItemInfos = this.saleItemServfeeInfoMapper.getListPage(saleItemInfoVO, (Page<Map<String, Object>>)page, null);
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setInspectionId(saleItemInfoRepBO.getInspectionId());
            payItemInfoVO.setOrderId(saleItemInfoRepBO.getOrderId());
            List saleItemInfoRspBOs = saleItemInfos.stream().map(SaleItemInfo2 -> {
                SaleItemInfoRspBO saleItemInfoRspBO = new SaleItemInfoRspBO();
                BeanUtils.copyProperties((Object)SaleItemInfo2, (Object)saleItemInfoRspBO);
                saleItemInfoRspBO.setQuantitySale(saleItemInfoRspBO.getQuantity());
                saleItemInfoRspBO.setSaleUnitPriceSale(saleItemInfoRspBO.getSaleUnitPrice());
                return saleItemInfoRspBO;
            }).collect(Collectors.toList());
            for (SaleItemInfoRspBO rspBO : saleItemInfoRspBOs) {
                rspBO.setPurchaseAmount(rspBO.getAmount());
                rspBO.setPurchaseUnitPrice(rspBO.getSaleUnitPrice());
            }
            rspPage.setRows(saleItemInfoRspBOs);
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOGGER.error("\u901a\u8fc7\u8ba2\u5355id\u67e5\u8be2\u660e\u7ec6\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u901a\u8fc7\u8ba2\u5355id\u67e5\u8be2\u660e\u7ec6\u5217\u8868\u5931\u8d25");
        }
        return rspPage;
    }

    @PostMapping(value={"update"})
    public PfscExtRspBaseBO update(@RequestBody SaleItemInfoRepBO saleItemInfoRepBO) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        try {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setItemNo(saleItemInfoRepBO.getItemNo());
            saleItemInfo.setTaxCatCode(saleItemInfoRepBO.getTaxCatCode());
            saleItemInfo.setInspectionId(saleItemInfoRepBO.getInspectionId());
            this.saleItemInfoMapper.updateByItemNo(saleItemInfo);
            PayItemInfo record = new PayItemInfo();
            record.setItemNo(saleItemInfo.getItemNo());
            record.setTaxId(saleItemInfo.getTaxCatCode().toString());
            record.setInspectionId(saleItemInfoRepBO.getInspectionId());
            this.payItemInfoMapper.updateByPrimaryKeySelective(record);
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u901a\u8fc7\u8ba2\u5355\u660e\u7ec6\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25");
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u901a\u8fc7\u8ba2\u5355\u660e\u7ec6\u66f4\u65b0\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6210\u529f");
        return rspBaseBO;
    }

    @PostMapping(value={"checkBillApplyZeroTax"})
    public CheckApplyZeroTaxRspBO checkBillApplyZeroTax(@RequestBody CheckApplyZeroTaxReqBO reqBO) {
        LOGGER.info("\u67e5\u8be2\u8ba2\u5355\u660e\u7ec60\u7a0e\u7387\u5546\u54c1\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
        CheckApplyZeroTaxRspBO rspBO = new CheckApplyZeroTaxRspBO();
        List inspectionIdList = reqBO.getInspectionIdList();
        ArrayList<Long> inspectionIds = new ArrayList<Long>();
        inspectionIdList.forEach(s -> inspectionIds.add(Long.valueOf(s)));
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getZeroTaxItemByInspectionIds(inspectionIds);
        if (!CollectionUtils.isEmpty(saleItemInfoList)) {
            int index = 0;
            ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u8ba2\u5355\u53f7", saleItemInfo.getSaleOrderCode() == null ? "" : saleItemInfo.getSaleOrderCode());
                item.put("\u9a8c\u6536\u5355\u53f7", saleItemInfo.getInspectionId() == null ? "" : saleItemInfo.getInspectionId());
                exportData.add(item);
            }
            this.uploadFile(exportData, rspBO);
            String fullFilePath = "";
            if ("OSS".equals(this.fileType)) {
                fullFilePath = rspBO.getFileUrl();
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFileUrl());
                fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            }
            rspBO.setFileUrl(fullFilePath);
            ArrayList<SaleItemInfoRspBO> rows = new ArrayList<SaleItemInfoRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                SaleItemInfoRspBO bo = new SaleItemInfoRspBO();
                bo.setSaleOrderCode(saleItemInfo.getSaleOrderCode());
                bo.setInspectionId(saleItemInfo.getInspectionId());
                rows.add(bo);
            }
            rspBO.setRows(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, CheckApplyZeroTaxRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, "0\u7a0e\u7387\u5546\u54c1\u6240\u5728\u8ba2\u5355\u53f7");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "0\u7a0e\u7387\u5546\u54c1\u6240\u5728\u8ba2\u5355\u53f7" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFileUrl(result);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

