/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.notify.impl;

import com.tydic.pfscext.api.notify.CancelApplyInfoService;
import com.tydic.pfscext.api.notify.bo.AuditCancelApplyReqBO;
import com.tydic.pfscext.api.notify.bo.AuditCancelApplyRspBO;
import com.tydic.pfscext.api.notify.bo.CancelApplyInfoBO;
import com.tydic.pfscext.api.notify.bo.QueryCancelApplyInfoReqBO;
import com.tydic.pfscext.api.notify.bo.QueryCancelApplyInfoRspBO;
import com.tydic.pfscext.dao.CancelApplyInfoMapper;
import com.tydic.pfscext.enums.CancelApplyStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.CancelApplyAuditAtomService;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoReqBO;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.notify.CancelApplyInfoService"})
public class CancelApplyInfoServiceImpl
implements CancelApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CancelApplyInfoServiceImpl.class);
    @Resource
    CancelApplyInfoMapper cancelApplyInfoMapper;
    @Resource
    CancelApplyAuditAtomService cancelApplyAuditAtomService;

    @PostMapping(value={"queryCancelInfoList"})
    public QueryCancelApplyInfoRspBO queryCancelInfoList(@RequestBody QueryCancelApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryCancelApplyInfoRspBO rspBO = new QueryCancelApplyInfoRspBO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("notificationNo", reqBO.getNotificationNo());
        List<CancelApplyInfoBO> cancelApplyInfoList = this.cancelApplyInfoMapper.queryCancelInfoList(param);
        if (!CollectionUtils.isEmpty(cancelApplyInfoList)) {
            for (CancelApplyInfoBO bo : cancelApplyInfoList) {
                if (StringUtils.isEmpty((Object)bo.getQxApplyStatus())) continue;
                bo.setQxApplyStatusDesc(CancelApplyStatus.getInstance(bo.getQxApplyStatus()).getDescr());
            }
        } else {
            cancelApplyInfoList = new ArrayList<CancelApplyInfoBO>();
        }
        rspBO.setCancelApplyInfoList(cancelApplyInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"auditCancelApply"})
    public AuditCancelApplyRspBO auditCancelApply(@RequestBody AuditCancelApplyReqBO reqBO) {
        AuditCancelInfoReqBO auditCancelInfoReqBO = new AuditCancelInfoReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)auditCancelInfoReqBO));
        AuditCancelInfoRspBO auditCancelInfoRspBO = this.cancelApplyAuditAtomService.auditCancelInfo(auditCancelInfoReqBO);
        AuditCancelApplyRspBO rspBO = new AuditCancelApplyRspBO();
        BeanUtils.copyProperties((Object)((Object)auditCancelInfoRspBO), (Object)rspBO);
        return rspBO;
    }
}

