/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.notify.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.notify.FscInvoiceExportService;
import com.tydic.pfscext.api.notify.bo.FscInvoiceExportReqBO;
import com.tydic.pfscext.api.notify.bo.FscInvoiceExportRspBO;
import com.tydic.pfscext.api.notify.bo.QueryInvoiceExportVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umc.perf.common.UmcSupplierInfoBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoListAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.notify.FscInvoiceExportService"})
public class FscInvoiceExportServiceImpl
implements FscInvoiceExportService {
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private UmcQrySupplierInfoListAbilityService umcQrySupplierInfoListAbilityService;

    @PostMapping(value={"queryInvoiceExport"})
    public FscInvoiceExportRspBO queryInvoiceExport(@RequestBody FscInvoiceExportReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getExportNoList())) {
            throw new PfscExtBusinessException("0001", "\u8981\u5bfc\u51fa\u7684\u901a\u77e5\u5355\u53f7/\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getExportType())) {
            throw new PfscExtBusinessException("0001", "\u5bfc\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscInvoiceExportRspBO rspBO = new FscInvoiceExportRspBO();
        List<Object> invoiceList = new ArrayList();
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        if ("1".equals(reqBO.getExportType())) {
            invoiceList = this.billNotificationInfoMapper.queryInvoiceExport(reqBO.getExportNoList(), (Page<Map<String, Object>>)page);
            if (invoiceList.size() != reqBO.getExportNoList().size()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8bf7\u52fe\u9009\u5f85\u6536\u7968\u3001\u5df2\u6536\u7968\u7684\u5f00\u7968\u901a\u77e5\u5355\uff01");
                return rspBO;
            }
        } else {
            invoiceList = this.billApplyInfoMapper.queryInvoiceApplyExport(reqBO.getExportNoList(), (Page<Map<String, Object>>)page);
            if (invoiceList.size() != reqBO.getExportNoList().size()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8bf7\u52fe\u9009\u5f85\u6536\u7968\u3001\u5df2\u6536\u7968\u7684\u5f00\u7968\u7533\u8bf7\u5355\uff01");
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty(invoiceList)) {
            HashMap<Long, String> supplierMap = new HashMap<Long, String>();
            HashSet<Long> supplierNos = new HashSet<Long>();
            if (CollectionUtils.isEmpty(invoiceList)) {
                for (QueryInvoiceExportVO queryInvoiceExportVO : invoiceList) {
                    supplierNos.add(queryInvoiceExportVO.getSupplierNo());
                }
            }
            UmcQrySupplierInfoListAbilityReqBO umcQrySupplierInfoListAbilityReqBO = new UmcQrySupplierInfoListAbilityReqBO();
            umcQrySupplierInfoListAbilityReqBO.setPageNo(Integer.valueOf(-1));
            umcQrySupplierInfoListAbilityReqBO.setPageSize(Integer.valueOf(-1));
            umcQrySupplierInfoListAbilityReqBO.setSupplierIds(new ArrayList(supplierNos));
            UmcQrySupplierInfoListAbilityRspBO umcQrySupplierInfoListAbilityRspBO = this.umcQrySupplierInfoListAbilityService.qrySupplierInfoList(umcQrySupplierInfoListAbilityReqBO);
            if (umcQrySupplierInfoListAbilityRspBO != null && !CollectionUtils.isEmpty((Collection)umcQrySupplierInfoListAbilityRspBO.getRows())) {
                for (UmcSupplierInfoBO umcSupplierInfoBO : umcQrySupplierInfoListAbilityRspBO.getRows()) {
                    supplierMap.put(umcSupplierInfoBO.getSupplierId(), umcSupplierInfoBO.getSupplierName());
                }
            }
            for (QueryInvoiceExportVO queryInvoiceExportVO : invoiceList) {
                if (queryInvoiceExportVO.getInvoiceType() != null) {
                    queryInvoiceExportVO.setInvoiceTypeStr(InvoiceType.getInstance(queryInvoiceExportVO.getInvoiceType()).getCodeDescr());
                }
                if (!StringUtils.isEmpty((Object)queryInvoiceExportVO.getSupplierName()) || queryInvoiceExportVO.getSupplierNo() == null || !supplierMap.containsKey(queryInvoiceExportVO.getSupplierNo())) continue;
                queryInvoiceExportVO.setSupplierName((String)supplierMap.get(queryInvoiceExportVO.getSupplierNo()));
            }
            rspBO.setRows(invoiceList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

