/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.order.PebExtFscPayResultAbilityService;
import com.tydic.order.pec.ability.pay.UocPebUpdatePayStatusAbilityService;
import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.api.pay.PayOfflineSubmitService;
import com.tydic.pfscext.api.pay.bo.PayOfflineSubmitServiceReqBO;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.PayOfflineSubmitService"})
public class PayOfflineSubmitServiceImpl
implements PayOfflineSubmitService {
    private static final Logger log = LoggerFactory.getLogger(PayOfflineSubmitServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PayOfflineSubmitServiceImpl.class);
    @Autowired
    private PayProAbleQueryOrderStatusAbilityService payProAbleQueryOrderStatusAbilityService;
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BusiPayResultModifyService busiPayResultModifyService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UocPebUpdatePayStatusAbilityService uocPebUpdatePayStatusAbilityService;
    @Autowired
    private PebExtFscPayResultAbilityService pebExtFscPayResultAbilityService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private FscOrderPayStatusUpdateService fscOrderPayStatusUpdateService;
    @Autowired
    private UserInfoService userInfoService;
    private static final Integer TRADE_MODEL = 0;
    private static final String SUCCESS = "SUCCESS";

    @PostMapping(value={"dealPaySubmitOffline"})
    public PayReturnInfoRspBO dealPaySubmitOffline(@RequestBody PayOfflineSubmitServiceReqBO reqBO) {
        logger.info("\u7ebf\u4e0b\u652f\u4ed8\u63d0\u4ea4\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getOutOrderId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMethod()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayVoucher()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4ed8\u6b3e\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyPayBOList())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u3001\u5f00\u7968\u7f16\u53f7\u3001\u4ed8\u6b3e\u91d1\u989d\u548c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u7ec4\u6210\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyPayBOList = reqBO.getApplyPayBOList();
        ArrayList<String> payableNoList = new ArrayList<String>();
        ArrayList<String> sourceList = new ArrayList<String>();
        for (ApplyPayBO applyPayBO : applyPayBOList) {
            if (!StringUtils.hasText((String)applyPayBO.getPayableNo())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt() == null) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (applyPayBO.getPayAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            if (!StringUtils.hasText((String)applyPayBO.getSource())) {
                throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
            payableNoList.add(applyPayBO.getPayableNo());
            sourceList.add(applyPayBO.getSource());
        }
        try {
            String outOrderId = reqBO.getOutOrderId();
            String payMethod = reqBO.getPayMethod();
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            paymentFlowInfo.setOutOrderId("PAYMENT-" + outOrderId);
            paymentFlowInfo.setPayType(payMethod);
            paymentFlowInfo.setPayChannel(payMethod);
            paymentFlowInfo.setPayAcctName(reqBO.getPayVoucherName());
            paymentFlowInfo.setPayAttche(reqBO.getPayVoucher());
            paymentFlowInfo.setPayOrderId(reqBO.getPayOrderId());
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            String payno = outOrderId;
            ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
            applyPayInfoPO.setPayno(payno);
            applyPayInfoPO.setPayMathod(payMethod);
            applyPayInfoPO.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
            applyPayInfoPO.setPayVoucher(reqBO.getPayVoucher());
            applyPayInfoPO.setPayVoucherName(reqBO.getPayVoucherName());
            applyPayInfoPO.setRemark(reqBO.getRemark());
            this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
            BusiPayResultModifyReqBO busiPayResultModifyReqBO = new BusiPayResultModifyReqBO();
            ArrayList<String> pauNOs = new ArrayList<String>();
            ArrayList<String> status = new ArrayList<String>();
            pauNOs.add(payno);
            status.add("01");
            busiPayResultModifyReqBO.setPayNos(pauNOs);
            busiPayResultModifyReqBO.setStatuss(status);
            ArrayList<String> payableNos = new ArrayList<String>();
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payno);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            HashMap<String, BigDecimal> applyMap = new HashMap<String, BigDecimal>();
            for (ApplyPayBO applyPayBO : applyPayBOList) {
                PayableDetailPO payable = this.checkParamter(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
                applyMap.put(applyPayBO.getPayableNo(), applyPayBO.getPayAmt());
            }
            this.modifyResult(busiPayResultModifyReqBO, reqBO, payableNos);
            rspBO.setResultCode(SUCCESS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u7ebf\u4e0b\u652f\u4ed8\u63d0\u4ea4\u5931\u8d25,\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u7ebf\u4e0b\u652f\u4ed8\u63d0\u4ea4\u5931\u8d25:" + e);
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private PayableDetailPO checkParamter(String payableNo, BigDecimal amount) {
        if (!StringUtils.hasText((String)payableNo)) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u6d89\u53ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO payable = null;
        try {
            payable = this.payableDetailMapper.getModelById(payableNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo, (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25" + e.getMessage());
        }
        if (payable == null) {
            logger.debug("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728,\u5e94\u4ed8\u5355=" + payableNo);
            throw new PfscExtBusinessException("18001", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        return payable;
    }

    private BusiPayResultModifyRspBO modifyResult(BusiPayResultModifyReqBO busiPayResultModifyReqBO, PayOfflineSubmitServiceReqBO payOfflineSubmitServiceReqBO, List<String> payableNos) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.APPLYING) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + newStatus.getDescr());
        }
        for (String payNo : payNos) {
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            ArrayList<String> payableNoList = new ArrayList<String>();
            for (ApplyDetail applyDetail : details) {
                payableNoList.add(applyDetail.getPayableNo());
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            applyPay.setPayStatus(PayResultStatus.PAY_CONFIRMED.getCode());
            applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
            this.applyPayInfoMapper.updateStatus(applyPay);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.PAY_CONFIRMED.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
        }
        return resp;
    }

    private void updateSaleOrderInfoPayStatus(PayableDetailPO payableDetailPO, Long orderId, Long parentOrderId) {
        if (payableDetailPO != null) {
            SaleOrderInfoVO orderInfo = new SaleOrderInfoVO();
            orderInfo.setOrderId(payableDetailPO.getOrderId());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(orderInfo);
            if (!CollectionUtils.isEmpty(saleOrderInfos)) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    FscOrderPayStatusUpdateReqBO fscOrderPayStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
                    fscOrderPayStatusUpdateReqBO.setOrderId(saleOrderInfo.getOrderId());
                    fscOrderPayStatusUpdateReqBO.setParentOrderId(saleOrderInfo.getParentOrderId());
                    this.fscOrderPayStatusUpdateService.updateOrderPayStatus(fscOrderPayStatusUpdateReqBO);
                }
            }
        } else if (orderId != null) {
            FscOrderPayStatusUpdateReqBO payStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
            payStatusUpdateReqBO.setOrderId(orderId);
            if (parentOrderId != null) {
                payStatusUpdateReqBO.setParentOrderId(parentOrderId);
            }
            this.fscOrderPayStatusUpdateService.updateOrderPayStatus(payStatusUpdateReqBO);
        }
    }
}

