/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.order.PebExtFscPayResultAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.order.pec.ability.pay.UocPebUpdatePayStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdatePayStatusReqBO;
import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.busi.BusiAddCreditLineService;
import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.AddCreditLineFscReqBo;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.api.pay.PayReturnInfoService;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoReqBO;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.PayReturnInfoService"})
public class PayReturnInfoServiceImpl
implements PayReturnInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    @Autowired
    private PayProAbleQueryOrderStatusAbilityService payProAbleQueryOrderStatusAbilityService;
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private BusiPayResultModifyService busiPayResultModifyService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UocPebUpdatePayStatusAbilityService uocPebUpdatePayStatusAbilityService;
    @Autowired
    private PebExtFscPayResultAbilityService pebExtFscPayResultAbilityService;
    @Autowired
    private BusiAddCreditLineService busiAddCreditLineService;
    @Autowired
    private FscOrderPayStatusUpdateService fscOrderPayStatusUpdateService;
    @Autowired
    private UserInfoService userInfoService;
    private static final Integer TRADE_MODEL = 0;
    private static final String SUCCESS = "SUCCESS";

    @PostMapping(value={"payReturnInfo"})
    public PayReturnInfoRspBO payReturnInfo(@RequestBody PayReturnInfoReqBO reqBO) {
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getBusiCode()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContent()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u52a0\u5bc6\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String content = reqBO.getContent();
            String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
            this.savelog("PayReturnInfoService", reqBO.toString(), retStr);
            JSONObject jsonObject = JSONObject.fromObject((Object)retStr);
            if (null != jsonObject) {
                String outOrderId = jsonObject.getString("outOrderId");
                String resultCode = jsonObject.getString("resultCode");
                String resultMsg = jsonObject.getString("resultMsg");
                String payMethod = jsonObject.getString("payMethod");
                String paymentInsId = jsonObject.getString("paymentInsId");
                String createUserId = jsonObject.getString("createOperId");
                if (PayMethod.ZHCQT_SF.getCode().equals(payMethod)) {
                    this.updatePayMethod(payMethod, outOrderId, paymentInsId);
                    return rspBO;
                }
                if (PayMethod.OFFLINE_PAY.getCode().equals(payMethod)) {
                    return rspBO;
                }
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(outOrderId);
                paymentFlowInfo.setPaymentStatus(resultCode);
                paymentFlowInfo.setOrderRemark(resultMsg);
                paymentFlowInfo.setResultJson(retStr);
                paymentFlowInfo.setPayType(payMethod);
                paymentFlowInfo.setPayTime(new Date());
                paymentFlowInfo.setPayChannel(paymentInsId);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
                if (SUCCESS.equals(resultCode)) {
                    if (outOrderId.startsWith("SERVICE")) {
                        PayOrderInfoPO po = new PayOrderInfoPO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)po);
                        po.setPayOrderId(Long.valueOf(outOrderId.substring(12)));
                        po.setPayOrderStatus(PayOrderStatus.PAY_TO_CONFIRM.getCode());
                        if (!StringUtils.isEmpty((CharSequence)createUserId)) {
                            po.setPayRegisterUserId(Long.parseLong(createUserId));
                            po.setPayRegisterUserName(this.userInfoService.queryUserNameByUserId(Long.parseLong(createUserId)));
                            po.setPayRegisterTime(new Date());
                        }
                        logger.error("PayOrderInfoServiceImpl\u5165\u53c2\uff1a" + po.toString());
                        this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
                    }
                    if (outOrderId.startsWith("PAYMENT")) {
                        String payno = outOrderId.substring(8);
                        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
                        applyPayInfoPO.setPayno(payno);
                        applyPayInfoPO.setPayMathod(payMethod);
                        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
                        BusiPayResultModifyReqBO busiPayResultModifyReqBO = new BusiPayResultModifyReqBO();
                        ArrayList<String> pauNOs = new ArrayList<String>();
                        ArrayList<String> status = new ArrayList<String>();
                        pauNOs.add(payno);
                        status.add("01");
                        busiPayResultModifyReqBO.setPayNos(pauNOs);
                        busiPayResultModifyReqBO.setStatuss(status);
                        ArrayList<String> payableNos = new ArrayList<String>();
                        List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payno);
                        int size = details.size();
                        if (size == 0) {
                            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
                        }
                        for (ApplyDetail ApplyDetail2 : details) {
                            PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(ApplyDetail2.getPayableNo());
                            this.addCreditLine(payableDetailPO, ApplyDetail2);
                            payableNos.add(payableDetailPO.getPayableNo());
                            PayableDetailPO forUpdate = new PayableDetailPO();
                            forUpdate.setPayableNo(ApplyDetail2.getPayableNo());
                            if (payableDetailPO.getPayableAmt().compareTo(payableDetailPO.getPendingAmt()) == 0) {
                                forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
                            } else {
                                forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
                            }
                            this.payableDetailMapper.updateAmount(forUpdate);
                        }
                        this.modifyResult(busiPayResultModifyReqBO, reqBO, payableNos);
                    }
                }
            }
            rspBO.setResultCode(SUCCESS);
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            this.savelog("PayReturnInfoService", reqBO.toString(), reqBO.getContent());
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25:" + e);
        }
        return rspBO;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private BusiPayResultModifyRspBO modifyResult(BusiPayResultModifyReqBO busiPayResultModifyReqBO, PayReturnInfoReqBO payReturnInfoReqBO, List<String> payableNos) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.APPLYING) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + newStatus.getDescr());
        }
        for (String payNo : payNos) {
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            applyPay.setPayStatus(PayResultStatus.SUCCESS.getCode());
            applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
            this.applyPayInfoMapper.updateStatus(applyPay);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
            ArrayList<String> nopId = new ArrayList<String>();
            for (ApplyDetail applyDetail1 : details) {
                String payableNo = applyDetail1.getPayableNo();
                PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(payableNo);
                ArrayList orderIds = new ArrayList();
                if (null != payableDetailPO) {
                    List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPO.getNotificationNo());
                    if (!(null == payPurchaseOrderInfoList || payPurchaseOrderInfoList.size() <= 0 || TRADE_MODEL.equals(payableDetailPO.getBusiModel()) && payableDetailPO.getPayableType().equals(1))) {
                        UocPebUpdatePayStatusReqBO uocPebUpdatePayStatusReqBO = new UocPebUpdatePayStatusReqBO();
                        uocPebUpdatePayStatusReqBO.setPayMod(applyPay.getPayMathod());
                        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                            payPurchaseOrderInfo.setPayModel("01");
                            this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo);
                            if (!nopId.contains(payPurchaseOrderInfo.getNotificationNo())) {
                                nopId.add(payPurchaseOrderInfo.getNotificationNo());
                            }
                            if (!"1".equals(payPurchaseOrderInfo.getBusiModel())) continue;
                            PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
                            extPayResultReqBO.setOrderId(payPurchaseOrderInfo.getOrderId().toString());
                            extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                            PebExtPayResultRspBO pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(extPayResultReqBO);
                            logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                            if (null != pebExtPayResultRspBO && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                            logger.error("\u8ba2\u5355ID\u4e3a" + payPurchaseOrderInfo.getOrderId() + "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25,,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO.getResultMsg());
                        }
                    }
                    if (null != payableDetailPO.getApplyNo() && !"".equals(payableDetailPO.getApplyNo())) {
                        List<SaleOrderInfo> list = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(payableDetailPO.getApplyNo());
                        if (null != list && !list.isEmpty()) {
                            UocPebUpdatePayStatusReqBO uocPebUpdatePayStatusReqBO = new UocPebUpdatePayStatusReqBO();
                            uocPebUpdatePayStatusReqBO.setPayMod(applyPay.getPayMathod());
                            for (SaleOrderInfo saleOrderInfo : list) {
                                PebExtPayResultReqBO extPayResultReqBO = new PebExtPayResultReqBO();
                                extPayResultReqBO.setOrderId(saleOrderInfo.getOrderId().toString());
                                extPayResultReqBO.setPayMethod(applyPay.getPayMathod());
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
                                PebExtPayResultRspBO pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(extPayResultReqBO);
                                logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                                if (null != pebExtPayResultRspBO && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) continue;
                                logger.error("\u8ba2\u5355ID\u4e3a" + saleOrderInfo.getOrderId() + "\u8c03\u7528\u4fee\u6539\u8ba2\u5355\u4e2d\u5fc3\u7684\u4ed8\u6b3e\u72b6\u6001\u5931\u8d25\uff0c,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO.getResultMsg());
                            }
                        }
                        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                        saleOrderInfo.setApplyNo(payableDetailPO.getApplyNo());
                        saleOrderInfo.setPayStatus(PayableStatus.SUCCESS.getCode());
                        this.saleOrderInfoMapper.updateByApplyNo(saleOrderInfo);
                    }
                    if (null != payableDetailPO && StringUtils.isBlank((CharSequence)payableDetailPO.getApplyNo()) && StringUtils.isBlank((CharSequence)payableDetailPO.getNotificationNo())) {
                        String content = payReturnInfoReqBO.getContent();
                        String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
                        PebExtPayResultReqBO pebExtPayResultReqBO = (PebExtPayResultReqBO)JSON.parseObject((String)retStr, PebExtPayResultReqBO.class);
                        pebExtPayResultReqBO.setContent(content);
                        pebExtPayResultReqBO.setBusiCode(payReturnInfoReqBO.getBusiCode());
                        ArrayList<String> payablesNos = new ArrayList<String>();
                        payablesNos.add(payableNo);
                        pebExtPayResultReqBO.setPayableNos(payablesNos);
                        ArrayList<Long> orders = new ArrayList<Long>();
                        orders.add(payableDetailPO.getOrderId());
                        payableDetailPO.setOrderIdList(orders);
                        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
                        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
                        this.updateSaleOrderInfoPayStatus(payableDetailPO, null, null);
                        logger.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
                        pebExtPayResultReqBO.setTotalFee(payableDetailPOS.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
                        pebExtPayResultReqBO.setOrderId(null != payableDetailPO.getOrderId() ? payableDetailPO.getOrderId().toString() : null);
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + pebExtPayResultReqBO);
                        PebExtPayResultRspBO pebExtPayResultRspBO = this.pebExtFscPayResultAbilityService.dealPayResult(pebExtPayResultReqBO);
                        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
                        if (pebExtPayResultRspBO == null || !SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
                            logger.error("\u5e94\u4ed8\u5355[" + payableNo + "], \u8ba2\u5355[" + pebExtPayResultReqBO.getOrderId() + "]\u56de\u8c03\u8ba2\u5355\u9519\u8bef\uff0c,\u9519\u8bef\u4fe1\u606f:" + pebExtPayResultRspBO.getResultMsg());
                        }
                    }
                }
                ArrayList<String> payAbleNos = new ArrayList<String>();
                payAbleNos.add(payableNo);
                String status = PayableStatus.PAYING.getCode();
                BigDecimal ingAmt = payableDetailPO.getPendingAmt();
                if (payableDetailPO.getPaidAmt() != null) {
                    ingAmt = payableDetailPO.getPaidAmt().add(payableDetailPO.getPendingAmt());
                }
                if (ingAmt.compareTo(payableDetailPO.getPayableAmt()) >= 0) {
                    status = PayableStatus.SUCCESS.getCode();
                }
                this.payableDetailMapper.updateAmtByNOs(payAbleNos, status);
            }
            if (nopId.isEmpty()) continue;
            this.billNotificationInfoMapper.updatePayStatus(nopId, 2);
        }
        return resp;
    }

    private void updateSaleOrderInfoPayStatus(PayableDetailPO payableDetailPO, Long orderId, Long parentOrderId) {
        if (payableDetailPO != null) {
            SaleOrderInfoVO orderInfo = new SaleOrderInfoVO();
            orderInfo.setOrderId(payableDetailPO.getOrderId());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(orderInfo);
            if (!CollectionUtils.isEmpty(saleOrderInfos)) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    FscOrderPayStatusUpdateReqBO fscOrderPayStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
                    fscOrderPayStatusUpdateReqBO.setOrderId(saleOrderInfo.getOrderId());
                    fscOrderPayStatusUpdateReqBO.setParentOrderId(saleOrderInfo.getParentOrderId());
                    this.fscOrderPayStatusUpdateService.updateOrderPayStatus(fscOrderPayStatusUpdateReqBO);
                }
            }
        } else if (orderId != null) {
            FscOrderPayStatusUpdateReqBO payStatusUpdateReqBO = new FscOrderPayStatusUpdateReqBO();
            payStatusUpdateReqBO.setOrderId(orderId);
            if (parentOrderId != null) {
                payStatusUpdateReqBO.setParentOrderId(parentOrderId);
            }
            this.fscOrderPayStatusUpdateService.updateOrderPayStatus(payStatusUpdateReqBO);
        }
    }

    private void addCreditLine(PayableDetailPO payableDetailPO1, ApplyDetail applyDetail) {
        AddCreditLineFscReqBo creditLineFscReqBo = new AddCreditLineFscReqBo();
        creditLineFscReqBo.setChangeType("3");
        BigDecimal changeInfo = applyDetail.getAmt();
        if (payableDetailPO1.getOverduePenalty() != null && !"1".equals(payableDetailPO1.getApproveResult())) {
            changeInfo = changeInfo.subtract(payableDetailPO1.getOverduePenalty());
        }
        creditLineFscReqBo.setChangeInfo(changeInfo);
        creditLineFscReqBo.setPayApplyCode(String.valueOf(applyDetail.getApplyNo()));
        if (payableDetailPO1.getPayableType() == 1 && "1".equals(payableDetailPO1.getBusiModel())) {
            String notificationNo = payableDetailPO1.getNotificationNo();
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(payPurchaseOrderInfo.getPurchaseOrderCode()));
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO1.getPayableType() == 6) {
            String applyNo = payableDetailPO1.getApplyNo();
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getMarketSaleOrderListByApplyNo(applyNo);
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                creditLineFscReqBo.setOrderCode(String.valueOf(saleOrderInfo.getSaleOrderCode()));
                this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
            }
        } else if (payableDetailPO1.getPayableType() == 2 || payableDetailPO1.getPayableType() == 3 || payableDetailPO1.getPayableType() == 5) {
            creditLineFscReqBo.setOrderCode(payableDetailPO1.getPurchaseOrderCode());
            this.busiAddCreditLineService.addCreditLine(creditLineFscReqBo);
        }
        logger.error("##############################\uff1a" + creditLineFscReqBo.toString());
    }

    private void updatePayMethod(String PayMethod2, String outOrderId, String paymentInsId) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        String[] split = outOrderId.split("-");
        applyPayInfoPO.setPayno(split[1]);
        applyPayInfoPO.setPayMathod(PayMethod2);
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderId(outOrderId);
        paymentFlowInfo.setPayType(paymentInsId);
        paymentFlowInfo.setPayChannel(PayMethod2);
        this.paymentFlowInfoMapper.updateByExtJson(paymentFlowInfo);
    }
}

