/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.github.pagehelper.util.StringUtil;
import com.ohaotian.authority.user.service.SelectByOrgAndRoleWebService;
import com.tydic.pfscext.api.zm.ChangeOfReceiptRevertService;
import com.tydic.pfscext.api.zm.bo.ChangOfReceiptItemBO;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptBO;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptInitiateBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.AfterSaleDetailMapper;
import com.tydic.pfscext.dao.AfterSaleMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderItemInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.AfterSale;
import com.tydic.pfscext.dao.po.AfterSaleDetail;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.ChangeOrderInfoPO;
import com.tydic.pfscext.dao.po.ChangeOrderItemInfoPO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.BillApplyInfoStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SequenceNoService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ChangeOfReceiptRevertService"})
public class ChangeOfReceiptRevertServiceImpl
implements ChangeOfReceiptRevertService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeOfReceiptRevertServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;
    @Autowired
    private SequenceNoService publicSeqNoService;
    @Autowired
    private AfterSaleDetailMapper afterSaleDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private ChangeOrderInfoMapper changeOrderInfoMapper;
    @Autowired
    private ChangeOrderItemInfoMapper changeOrderItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SelectByOrgAndRoleWebService selectByOrgAndRoleWebService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PostMapping(value={"changeOfReceipt"})
    public PfscExtRspBaseBO changeOfReceipt(@RequestBody ChangeOfReceiptInitiateBO changeOfReceiptInitiateBO) {
        LOGGER.debug("\u5f02\u5e38\u8ba2\u5355\u53d8\u66f4\u5165\u53c2\uff1a" + changeOfReceiptInitiateBO.toString());
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setSaleOrderCode(changeOfReceiptInitiateBO.getOrderCode());
            saleOrderInfo.setInspectionId(Long.valueOf(changeOfReceiptInitiateBO.getInspectionId()));
            SaleOrderInfo saleOrderInfo1 = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
            if (null == saleOrderInfo1) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u8be5\u9500\u552e\u8ba2\u5355");
            }
            LOGGER.debug("\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
            if (saleOrderInfo1.getOrderAmt().compareTo(changeOfReceiptInitiateBO.getSaleOriginalOrderAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setPurchaseOrderCode(changeOfReceiptInitiateBO.getOrderCode());
            payPurchaseOrderInfo.setInspectionId(Long.valueOf(changeOfReceiptInitiateBO.getInspectionId()));
            PayPurchaseOrderInfo payPurchaseOrderInfo1 = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
            if (null == payPurchaseOrderInfo1) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u5b58\u5728\u8be5\u9500\u552e\u8ba2\u5355");
            }
            LOGGER.debug("\u91c7\u8d2d\u8ba2\u5355====" + payPurchaseOrderInfo1.toString());
            if (payPurchaseOrderInfo1.getOrderAmt().compareTo(changeOfReceiptInitiateBO.getPurchearOriginalOrderAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
            ChangeOrderInfoPO changeOrderInfoPO = new ChangeOrderInfoPO();
            BeanUtils.copyProperties((Object)changeOfReceiptInitiateBO, (Object)changeOrderInfoPO);
            changeOrderInfoPO.setSaleOrderCode(saleOrderInfo1.getSaleOrderCode());
            changeOrderInfoPO.setChangeDate(new Date());
            this.changeOrderInfoMapper.insertSelective(changeOrderInfoPO);
            List changOfReceiptItemBOS = changeOfReceiptInitiateBO.getChangOfReceiptItemBOS();
            if (changOfReceiptItemBOS != null && changOfReceiptItemBOS.size() > 0) {
                for (ChangOfReceiptItemBO cib : changOfReceiptItemBOS) {
                    ChangeOrderItemInfoPO changeOrderItemInfoPO = new ChangeOrderItemInfoPO();
                    BeanUtils.copyProperties((Object)cib, (Object)changeOrderItemInfoPO);
                    changeOrderItemInfoPO.setInspectionId(saleOrderInfo1.getInspectionId());
                    changeOrderItemInfoPO.setOrderId(saleOrderInfo1.getOrderId());
                    if (StringUtil.isNotEmpty((String)cib.getSaleOrderItemNo())) {
                        changeOrderItemInfoPO.setItemNo(Long.parseLong(cib.getSaleOrderItemNo()));
                    }
                    this.changeOrderItemInfoMapper.insertSelective(changeOrderItemInfoPO);
                }
            }
            this.updateBillApplyInfo(changeOfReceiptInitiateBO, saleOrderInfo1);
            this.updateBillNotificationInfo(changeOfReceiptInitiateBO, payPurchaseOrderInfo1);
            if (!saleOrderInfo1.getOrderStatus().equals("00") && !payPurchaseOrderInfo1.getOrderStatus().equals("00")) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pfscExtRspBaseBO.setRespDesc("\u5f02\u5e38\u8ba2\u5355\u53d8\u66f4\u5931\u8d25");
            pfscExtRspBaseBO.setRespCode("18000");
            return pfscExtRspBaseBO;
        }
        pfscExtRspBaseBO.setRespDesc("\u5f02\u5e38\u8ba2\u5355\u4e0a\u4e0b\u6e38\u53d8\u66f4\u6210\u529f");
        pfscExtRspBaseBO.setRespCode("0000");
        return pfscExtRspBaseBO;
    }

    private void updateBillApplyInfo(ChangeOfReceiptInitiateBO changeOfReceiptBO, SaleOrderInfo saleOrderInfo) {
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleOrderInfo.getApplyNo());
        if (BusiModel.TRADE_MODEL.getCode().equals(changeOfReceiptBO.getBusiModel())) {
            if (changeOfReceiptBO.getPayType().equals("03")) {
                if (billApplyInfo == null && OrderStatus.NO_APPLY.getCode().equals(saleOrderInfo.getOrderStatus())) {
                    SaleOrderInfo sif = new SaleOrderInfo();
                    BeanUtils.copyProperties((Object)saleOrderInfo, (Object)sif);
                    sif.setPayStatus(OrderStatus.AFTER_SALE.getCode());
                    this.saleOrderInfoMapper.updateByPrimaryKeySelective(sif);
                } else if (BillApplyInfoStatus.SUBMITED.getCode().equals(billApplyInfo.getBillStatus()) && OrderStatus.APPLIED.getCode().equals(saleOrderInfo.getOrderStatus())) {
                    BillApplyInfo bif = new BillApplyInfo();
                    bif.setApplyNo(saleOrderInfo.getApplyNo());
                    bif.setRemark("\u7531\u552e\u540e\u5f15\u8d77");
                    bif.setBillStatus(NotificationInvoiceStatus.HANGING.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(bif);
                } else if (BillApplyInfoStatus.SUBMITING.getCode().equals(billApplyInfo.getBillStatus())) {
                    BillApplyInfo bif = new BillApplyInfo();
                    bif.setApplyNo(saleOrderInfo.getApplyNo());
                    bif.setRemark("\u7531\u552e\u540e\u5f15\u8d77");
                    bif.setBillStatus(NotificationInvoiceStatus.HANGING.getCode());
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(bif);
                } else if (BillApplyInfoStatus.FINSHSUBMIT.getCode().equals(billApplyInfo.getBillStatus()) && OrderStatus.SEND_BILL.getCode().equals(saleOrderInfo.getOrderStatus())) {
                    BillApplyInfo bif = new BillApplyInfo();
                    bif.setApplyNo(saleOrderInfo.getApplyNo());
                    bif.setRedMarkRefund(1);
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(bif);
                } else if (BillApplyInfoStatus.RECEIVE.getCode().equals(billApplyInfo.getBillStatus()) && OrderStatus.RECEIVE_BILL.getCode().equals(saleOrderInfo.getOrderStatus())) {
                    BillApplyInfo bif = new BillApplyInfo();
                    bif.setApplyNo(saleOrderInfo.getApplyNo());
                    bif.setRedMarkRefund(1);
                    this.billApplyInfoMapper.updateByPrimaryKeySelective(bif);
                }
            }
        } else if (changeOfReceiptBO.getPayType().equals("03")) {
            // empty if block
        }
    }

    private void updateBillNotificationInfo(ChangeOfReceiptInitiateBO changeOfReceiptBO, PayPurchaseOrderInfo payPurchaseOrderInfo) {
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(payPurchaseOrderInfo.getNotificationNo());
        if (BusiModel.TRADE_MODEL.getCode().equals(changeOfReceiptBO.getBusiModel())) {
            if (changeOfReceiptBO.getPayType().equals("03")) {
                if (billNotificationInfo != null && OrderStatus.NO_APPLY.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
                    PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfo1.setOrderStatus(OrderStatus.HANGING.getCode());
                    payPurchaseOrderInfo1.setInspectionId(payPurchaseOrderInfo.getInspectionId());
                    this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
                } else if (NotificationInvoiceStatus.SUBMITED.getCode().equals(billNotificationInfo.getInvoiceStatus()) && OrderStatus.APPLIED.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
                    BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
                    billNotificationInfo1.setInvoiceStatus(NotificationInvoiceStatus.HANGING.getCode());
                    billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
                } else if (NotificationInvoiceStatus.HAS_MAKE.getCode().equals(billNotificationInfo.getInvoiceStatus()) && OrderStatus.SEND_BILL.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
                    BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
                    billNotificationInfo1.setRedMarkRefund(1);
                    billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
                } else if (NotificationInvoiceStatus.RECEIVED.getCode().equals(billNotificationInfo.getInvoiceStatus()) && OrderStatus.RECEIVE_BILL.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
                    BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
                    billNotificationInfo1.setRedMarkRefund(1);
                    billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
                }
            }
        } else if (changeOfReceiptBO.getPayType().equals("03")) {
            BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
            billNotificationInfo1.setInvoiceStatus(NotificationInvoiceStatus.HANGING.getCode());
            billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
        } else if (NotificationInvoiceStatus.HAS_MAKE.getCode().equals(billNotificationInfo.getInvoiceStatus()) && OrderStatus.SEND_BILL.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
            BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
            billNotificationInfo1.setRedMarkRefund(1);
            billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
        } else if (NotificationInvoiceStatus.RECEIVED.getCode().equals(billNotificationInfo.getInvoiceStatus()) && OrderStatus.RECEIVE_BILL.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) {
            BillNotificationInfo billNotificationInfo1 = new BillNotificationInfo();
            billNotificationInfo1.setRedMarkRefund(1);
            billNotificationInfo1.setNotificationNo(billNotificationInfo.getNotificationNo());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(billNotificationInfo1);
        }
    }

    private void check(ChangeOfReceiptBO changeOfReceiptBO) {
        if (null == changeOfReceiptBO && "".equals(changeOfReceiptBO)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getChangeDate() || "".equals(changeOfReceiptBO.getChangeDate())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getInspectionId() || "".equals(changeOfReceiptBO.getInspectionId())) {
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getOrderCode() || "".equals(changeOfReceiptBO.getOrderCode())) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getPurchearNowOrderAmt() || "".equals(changeOfReceiptBO.getPurchearNowOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getPurchearOriginalOrderAmt() || "".equals(changeOfReceiptBO.getPurchearOriginalOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getSaleNowOrderAmt() || "".equals(changeOfReceiptBO.getSaleNowOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == changeOfReceiptBO.getSaleOriginalOrderAmt() || "".equals(changeOfReceiptBO.getSaleOriginalOrderAmt())) {
            throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (changeOfReceiptBO.getPurchearNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getPurchearOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new PfscExtBusinessException("18000", "\u539f\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getSaleNowOrderAmt().compareTo(BigDecimal.ZERO) == -1) {
            throw new PfscExtBusinessException("18000", "\u53d8\u66f4\u540e\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == -1 || changeOfReceiptBO.getSaleOriginalOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new PfscExtBusinessException("18000", "\u539f\u9500\u552e\u8ba2\u5355\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        if (null == changeOfReceiptBO.getChangOfReceiptItemBOS() || changeOfReceiptBO.getChangOfReceiptItemBOS().equals("")) {
            throw new PfscExtBusinessException("18000", "\u5546\u54c1\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)changeOfReceiptBO.getBusiModel())) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u4e1a\u52a1\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void inseartAfterSaleAndItem(ChangeOfReceiptBO changeOfReceiptBO, SaleOrderInfo saleOrderInfo, PayPurchaseOrderInfo payPurchaseOrderInfo) {
        long seq = System.currentTimeMillis();
        AfterSale afterSale = new AfterSale();
        afterSale.setSeq(seq);
        afterSale.setCreateDate(changeOfReceiptBO.getChangeDate());
        afterSale.setInspectionId((long)changeOfReceiptBO.getInspectionId());
        afterSale.setSaleOrderId(saleOrderInfo.getOrderId());
        afterSale.setPurchaseOrderId(payPurchaseOrderInfo.getOrderId());
        afterSale.setMessageType("02");
        afterSale.setProcessType("03");
        afterSale.setProcessStatus("01");
        afterSale.setRemark(changeOfReceiptBO.getRemark());
        afterSale.setPurchaseOrderAmt1(changeOfReceiptBO.getPurchearOriginalOrderAmt());
        afterSale.setPurchaseOrderAmt2(changeOfReceiptBO.getPurchearNowOrderAmt());
        afterSale.setSaleOrderAmt1(changeOfReceiptBO.getSaleOriginalOrderAmt());
        afterSale.setSaleOrderAmt2(changeOfReceiptBO.getSaleNowOrderAmt());
        afterSale.setRemark(changeOfReceiptBO.getRemark());
        this.afterSaleMapper.insertSelective(afterSale);
        for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
            if (null == changOfReceiptItemBO.getSaleOrderItemNo() && changOfReceiptItemBO.getSaleOrderItemNo().equals("")) {
                throw new PfscExtBusinessException("18000", "\u9500\u552e\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changOfReceiptItemBO.getPurchearItemNo() && changOfReceiptItemBO.getPurchearItemNo().equals("")) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changOfReceiptItemBO.getPurchearAmt() && changOfReceiptItemBO.getPurchearAmt().equals("")) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changOfReceiptItemBO.getSaleAmt() && changOfReceiptItemBO.getSaleAmt().equals("")) {
                throw new PfscExtBusinessException("18000", "\u9500\u552e\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changOfReceiptItemBO.getSaleNum() && changOfReceiptItemBO.getSaleNum().equals("")) {
                throw new PfscExtBusinessException("18000", "\u9500\u552e\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == changOfReceiptItemBO.getPurchearNum() && changOfReceiptItemBO.getPurchearNum().equals("")) {
                throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AfterSaleDetail afterSaleDetail = new AfterSaleDetail();
            afterSaleDetail.setRefSeq(seq);
            afterSaleDetail.setPurchaseAmount(changOfReceiptItemBO.getPurchearAmt());
            afterSaleDetail.setPurchaseQuantity(BigDecimal.valueOf(changOfReceiptItemBO.getPurchearNum()));
            afterSaleDetail.setSaleAmount(changOfReceiptItemBO.getSaleAmt());
            afterSaleDetail.setSaleQuantity(BigDecimal.valueOf(changOfReceiptItemBO.getSaleNum()));
            afterSaleDetail.setPurchaseItemNo(Long.valueOf(changOfReceiptItemBO.getPurchearItemNo()));
            afterSaleDetail.setSaleItemNo(Long.valueOf(changOfReceiptItemBO.getSaleOrderItemNo()));
            this.afterSaleDetailMapper.insertSelective(afterSaleDetail);
        }
    }

    private void updateSale(ChangeOfReceiptBO changeOfReceiptBO) {
        SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
        saleOrderInfo1.setOrderAmt(changeOfReceiptBO.getSaleNowOrderAmt());
        saleOrderInfo1.setInspectionId((long)changeOfReceiptBO.getInspectionId());
        saleOrderInfo1.setRemark(changeOfReceiptBO.getRemark());
        LOGGER.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
        this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo1);
        if (changeOfReceiptBO.getSaleNowOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId((long)changeOfReceiptBO.getInspectionId());
            this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
        }
        for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setItemNo(Long.valueOf(changOfReceiptItemBO.getSaleOrderItemNo()));
            saleItemInfo.setInspectionId((long)changeOfReceiptBO.getInspectionId());
            SaleItemInfo saleItemInfo1 = this.saleItemInfoMapper.getModelBy(saleItemInfo);
            LOGGER.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355====" + saleOrderInfo1.toString());
            if (changOfReceiptItemBO.getSaleAmt().compareTo(BigDecimal.ZERO) == -1 && saleItemInfo1.getAmount().compareTo(changOfReceiptItemBO.getSaleAmt().abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getSaleOrderItemNo() + "\u7684\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            if (changOfReceiptItemBO.getSaleNum() < 0L && saleItemInfo1.getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getSaleNum()).abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getSaleOrderItemNo() + "\u7684\u5546\u54c1\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            if (saleItemInfo1.getAmount().compareTo(changOfReceiptItemBO.getSaleAmt().abs()) == 0 && saleItemInfo1.getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getSaleNum()).abs()) == 0) {
                this.saleItemInfoMapper.deleteByPrimaryKey(saleItemInfo1.getSeq());
                continue;
            }
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setSeq(saleItemInfo1.getSeq());
            saleItemInfoVO.setAmount(saleItemInfo1.getAmount().add(changOfReceiptItemBO.getSaleAmt()));
            saleItemInfoVO.setQuantity(saleItemInfo1.getQuantity().add(BigDecimal.valueOf(changOfReceiptItemBO.getSaleNum())));
            this.saleItemInfoMapper.updateRefundLock(saleItemInfoVO);
        }
    }

    private void updatePurchear(ChangeOfReceiptInitiateBO changeOfReceiptBO) {
        PayPurchaseOrderInfo payPurchaseOrderInfo1 = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo1.setOrderAmt(changeOfReceiptBO.getPurchearNowOrderAmt());
        payPurchaseOrderInfo1.setInspectionId(Long.valueOf(changeOfReceiptBO.getInspectionId()));
        payPurchaseOrderInfo1.setRemark(changeOfReceiptBO.getRemark());
        LOGGER.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355=======" + payPurchaseOrderInfo1.toString());
        this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo1);
        if (changeOfReceiptBO.getPurchearNowOrderAmt().compareTo(BigDecimal.ZERO) == 0) {
            PayPurchaseOrderInfo payPurchaseOrderInfo2 = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo2.setInspectionId(Long.valueOf(changeOfReceiptBO.getInspectionId()));
            this.payPurchaseOrderInfoMapper.deleteBy(payPurchaseOrderInfo2);
        }
        for (ChangOfReceiptItemBO changOfReceiptItemBO : changeOfReceiptBO.getChangOfReceiptItemBOS()) {
            PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
            payItemInfoVO.setItemNo(Long.valueOf(changOfReceiptItemBO.getPurchearItemNo()));
            payItemInfoVO.setInspectionId(Long.valueOf(changeOfReceiptBO.getInspectionId()));
            List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
            LOGGER.debug("\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5=======" + payItemInfos.toString());
            if (changOfReceiptItemBO.getPurchearAmt().compareTo(BigDecimal.ZERO) == -1 && payItemInfos.get(0).getAmount().compareTo(changOfReceiptItemBO.getPurchearAmt().abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getPurchearItemNo() + "\u7684\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            if (changOfReceiptItemBO.getPurchearNum() < 0L && payItemInfos.get(0).getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getPurchearNum()).abs()) == -1) {
                throw new PfscExtBusinessException("18000", "\u660e\u7ec6ID\u4e3a" + changOfReceiptItemBO.getPurchearItemNo() + "\u5546\u54c1\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal unTaxAmt = BigDecimal.ZERO;
            BigDecimal aount = BigDecimal.ZERO;
            BigDecimal quantity = BigDecimal.ZERO;
            quantity = payItemInfos.get(0).getQuantity().add(BigDecimal.valueOf(changOfReceiptItemBO.getSaleNum()));
            aount = payItemInfos.get(0).getAmount().add(changOfReceiptItemBO.getSaleAmt());
            if (payItemInfos.get(0).getAmount().compareTo(changOfReceiptItemBO.getPurchearAmt().abs()) == 0 && payItemInfos.get(0).getQuantity().compareTo(new BigDecimal(changOfReceiptItemBO.getPurchearNum()).abs()) == 0) {
                this.payItemInfoMapper.deleteByPrimaryKey(payItemInfos.get(0).getSeq());
                continue;
            }
            taxAmt = payItemInfos.get(0).getAmount().divide(BigDecimal.ONE.add(payItemInfos.get(0).getTaxRate()), 5, 4).multiply(payItemInfos.get(0).getTaxRate()).setScale(2, 4);
            unTaxAmt = aount.subtract(taxAmt);
            PayItemInfo payItemInfo = new PayItemInfo();
            payItemInfo.setItemNo(payItemInfos.get(0).getItemNo());
            payItemInfo.setAmount(aount);
            payItemInfo.setQuantity(quantity);
            payItemInfo.setTaxAmt(taxAmt);
            payItemInfo.setUntaxAmt(unTaxAmt);
            LOGGER.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u5165\u53c2=====" + payItemInfo.toString());
            this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
        }
    }
}

