/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.busi.BusiActivictReconcilitionService;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRepBO;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionDetailImportRedisAddItemReqBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRepBO;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRspBO;
import com.tydic.pfscext.api.busi.vo.ReconcilitionHisListVO;
import com.tydic.pfscext.dao.DicDictionaryMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.ReconciliationSupMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.ReconcilitionHisTempMapper;
import com.tydic.pfscext.dao.bo.DicDictionaryPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.ReconciliationSup;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import com.tydic.pfscext.dao.po.ReconcilitionHisTemp;
import com.tydic.pfscext.dao.po.ReconcilitionListTempPo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetReconciliationDataService;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetReconciliationDataServiceRspBO;
import com.tydic.pfscext.external.api.bo.FscUnacceptedOrderInfoBO;
import com.tydic.pfscext.external.api.bo.PayReconciliationDetailVO;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.busi.impl.BusiReconcilitionServiceImpl;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiActivictReconcilitionService"})
public class BusiActivictReconcilitionServiceImpl
implements BusiActivictReconcilitionService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReconcilitionServiceImpl.class);
    private static final String IS_TEMP_YES = "1";
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    @Autowired
    private BusiGetReconciliationDataService busiGetReconciliationDataService;
    @Autowired
    private ReconcilitionHisTempMapper reconcilitionHisTempMapper;
    @Autowired
    private ReconciliationSupMapper reconciliationSupMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Resource(name="versionSeq")
    public OrderSequence versionSeq;

    @PostMapping(value={"registerReconcilition"})
    public BusiReconcilitionRspBO registerReconcilition(@RequestBody BusiReconcilitionRepBO reqBO) {
        List<String> orderId;
        List<ReconcilitionHis> reconcilitionHis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getVersionNo());
        }
        BusiReconcilitionRspBO rspBO = new BusiReconcilitionRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
            return rspBO;
        }
        Long purchaseNo = null;
        Long purchaserId = null;
        String busiModel = null;
        try {
            List<ReconcilitionHisTemp> listTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            if (CollectionUtils.isEmpty(listTemp)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
                return rspBO;
            }
            ReconciliationSup reconciliationSup = new ReconciliationSup();
            reconciliationSup.setReconciliationDate(new Date());
            reconciliationSup.setSupplierName(listTemp.get(0).getSupplierName());
            reconciliationSup.setUserName(reqBO.getName());
            reconciliationSup.setVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            this.reconciliationSupMapper.insert(reconciliationSup);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u7ed3\u7b97\u4f9b\u5e94\u5546\u5bf9\u8d26\u8bb0\u5f55\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u6dfb\u52a0\u7ed3\u7b97\u4f9b\u5e94\u5546\u5bf9\u8d26\u8bb0\u5f55\u5931\u8d25");
        }
        try {
            reconcilitionHis = this.reconcilitionHisMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(reconcilitionHis)) {
            try {
                this.reconcilitionHisMapper.insertActiveAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode(), reqBO.getName(), purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId, reqBO.getActivityId());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            try {
                this.reconcilitionHisMapper.insertActiveAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode(), reqBO.getName(), purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId, reqBO.getActivityId());
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            try {
                orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
                if (!CollectionUtils.isEmpty(orderId)) {
                    this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
                }
            }
            catch (Exception e) {
                logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            }
            List<ReconcilitionHis> nonacceptanceList = this.reconcilitionHisMapper.selectNonacceptance(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.NON_ACCEPTANCE.getCode(), purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel);
            if (null != nonacceptanceList && !nonacceptanceList.isEmpty()) {
                LinkedList<String> extOrderIdList = new LinkedList<String>();
                for (ReconcilitionHis rechis : nonacceptanceList) {
                    extOrderIdList.add(rechis.getExtOrderId());
                }
                LinkedHashSet middleLinkedHashSet = new LinkedHashSet(extOrderIdList);
                ArrayList<String> afterHashSetList = new ArrayList<String>(middleLinkedHashSet);
                FscUnacceptedOrderInfoBO unacceptedOrder = this.orderService.getUnacceptedOrder(afterHashSetList);
                if (null == unacceptedOrder) {
                    logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                    throw new PfscExtBusinessException("18000", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                }
                logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u6210\u529f\uff01");
                Map orderIdMap = unacceptedOrder.getOrderIdMap();
                Map createTimeMap = unacceptedOrder.getCreateTimeMap();
                Map supplierIdMap = unacceptedOrder.getSupplierIdMap();
                Map supplierNameMap = unacceptedOrder.getSupplierNameMap();
                Map companyIdMap = unacceptedOrder.getCompanyIdMap();
                for (ReconcilitionHis reconhis : nonacceptanceList) {
                    reconhis.setOrderId((String)orderIdMap.get(reconhis.getExtOrderId()));
                    reconhis.setOrderDate((Date)createTimeMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierNo((Integer)supplierIdMap.get(reconhis.getExtOrderId()));
                    reconhis.setSupplierName((String)supplierNameMap.get(reconhis.getExtOrderId()));
                    reconhis.setOperUnitNo((Long)companyIdMap.get(reconhis.getExtOrderId()));
                    reconhis.setPurchaseNo(purchaseNo);
                    reconhis.setUsername(reqBO.getName());
                }
                try {
                    this.reconcilitionHisMapper.insertReconcilitionHisList(nonacceptanceList);
                }
                catch (Exception e) {
                    logger.error("\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                    throw new PfscExtBusinessException("18000", "\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
                }
            }
            try {
                this.reconcilitionHisMapper.insertAftersale(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AFTER_SALE.getCode(), reqBO.getName(), purchaseNo, busiModel, purchaserId);
            }
            catch (Exception e) {
                logger.error("\u5546\u57ce\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u5546\u57ce\u552e\u540e\u4e2d\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
        }
        try {
            this.reconcilitionHisMapper.updateAccountAgreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode(), reqBO.getName(), purchaseNo, busiModel, purchaserId);
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.updateAccountDisagreement(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode(), reqBO.getName(), purchaseNo, busiModel, purchaserId);
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBatchNo(Integer.valueOf(reqBO.getVersionNo()));
        return rspBO;
    }

    @PostMapping(value={"cancelReconclition"})
    public ReconcilitionHisListRspBO cancelReconclition(@RequestBody QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO) {
        ReconcilitionHisListRspBO rspBo = new ReconcilitionHisListRspBO();
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.getOrderList(queryPayPurchaseOrderInfoReqBO);
        String startDate = "";
        String endDate = "";
        if (payPurchaseOrderInfoPOs != null && payPurchaseOrderInfoPOs.size() > 0) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            if (payPurchaseOrderInfoPOs.get(0).getOrderDate() != null) {
                startDate = sd.format(payPurchaseOrderInfoPOs.get(0).getOrderDate());
            }
            if (payPurchaseOrderInfoPOs.get(payPurchaseOrderInfoPOs.size() - 1).getOrderDate() != null) {
                endDate = sd.format(payPurchaseOrderInfoPOs.get(payPurchaseOrderInfoPOs.size() - 1).getOrderDate());
            }
            BusiGetReconciliationDataServiceRspBO busiGetReconciliationDataServiceRspBO = new BusiGetReconciliationDataServiceRspBO();
            BusiGetReconciliationDataServiceReqBO recBO = new BusiGetReconciliationDataServiceReqBO();
            recBO.setSupplierId(queryPayPurchaseOrderInfoReqBO.getSupplierNo());
            recBO.setStartDate(startDate);
            recBO.setEndDate(endDate);
            recBO.setPurchaseNo(queryPayPurchaseOrderInfoReqBO.getCompanyId().toString());
            DicDictionaryPO dic = new DicDictionaryPO();
            dic.setCode(queryPayPurchaseOrderInfoReqBO.getSupplierNo().toString());
            DicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dic);
            recBO.setSupplierName(dicDictionaryPO.getDescrip());
            busiGetReconciliationDataServiceRspBO = this.busiGetReconciliationDataService.getReconciliationData(recBO);
            if (busiGetReconciliationDataServiceRspBO != null && busiGetReconciliationDataServiceRspBO.getDataList() != null && ((BusiGetReconciliationDataRspVO)busiGetReconciliationDataServiceRspBO.getDataList().get(0)).getOrders().size() != 0) {
                ReconcilitionDetailImportRedisAddItemReqBO reItemBO = new ReconcilitionDetailImportRedisAddItemReqBO();
                ArrayList<ReconcilitionListTempPo> list = new ArrayList<ReconcilitionListTempPo>();
                if (busiGetReconciliationDataServiceRspBO.getDataList().size() != 0) {
                    Integer versionNo = null;
                    try {
                        long version = this.versionSeq.nextId();
                        versionNo = (int)version;
                    }
                    catch (Exception e) {
                        throw new PfscExtBusinessException("18000", "\u83b7\u53d6\u7248\u672c\u53f7\u5931\u8d25\uff01");
                    }
                    if (versionNo == null) {
                        versionNo = 0;
                    }
                    for (BusiGetReconciliationDataRspVO reVO : busiGetReconciliationDataServiceRspBO.getDataList()) {
                        Integer versionNum = versionNo + 1;
                        ReconcilitionListTempPo reconcilitionListTempPo = new ReconcilitionListTempPo();
                        for (PayReconciliationDetailVO payReconciliationDetailVO : reVO.getOrders()) {
                            logger.error("\u5bf9\u8c61\uff1a" + payReconciliationDetailVO.toString());
                            reconcilitionListTempPo.setVersionNo(versionNum);
                            reconcilitionListTempPo.setSupplierName(dicDictionaryPO.getDescrip());
                            reconcilitionListTempPo.setExtOrderId(payReconciliationDetailVO.getOrderId());
                            reconcilitionListTempPo.setOutAmt(payReconciliationDetailVO.getOrderPrice());
                            logger.error("\u83b7\u53d6\u91d1\u989d\uff1a" + payReconciliationDetailVO.getOrderPrice());
                            this.reconcilitionHisTempMapper.insertSelective(reconcilitionListTempPo);
                        }
                        list.add(reconcilitionListTempPo);
                        rspBo.setVersionNo(versionNum.toString());
                    }
                }
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            } else {
                rspBo.setRespCode("18000");
                rspBo.setRespDesc("\u7535\u5546\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
        }
        return rspBo;
    }

    private ReconcilitionHisListRspBO queryReconcilitionHisListTo(ReconcilitionHisListRepBO reqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a\u7248\u672c\u53f7\uff1a" + reqBo.getVersionNo() + "\u662f\u5426\u4e34\u65f6\u8868\uff1a" + reqBo.getIsTempTable());
        }
        ReconcilitionHisListRspBO rspBo = new ReconcilitionHisListRspBO();
        UmcQryEnterpriseAccountDetailAbilityReqBO umcReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        UmcQryEnterpriseAccountDetailAbilityRspBO umcRspBO = new UmcQryEnterpriseAccountDetailAbilityRspBO();
        if (!StringUtils.hasText((String)reqBo.getVersionNo())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getIsTempTable())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_TEMP_YES.equals(reqBo.getIsTempTable())) {
            List<ReconcilitionHisTemp> reconcilitionHisTemp;
            try {
                reconcilitionHisTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBo.getVersionNo()));
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
            ArrayList<ReconcilitionHisListVO> reconcilitionHisListVoList = new ArrayList<ReconcilitionHisListVO>();
            for (ReconcilitionHisTemp reconcilitionHisTemps : reconcilitionHisTemp) {
                ReconcilitionHisListVO reconcilitionHisListVO = new ReconcilitionHisListVO();
                BeanUtils.copyProperties((Object)reconcilitionHisTemps, (Object)reconcilitionHisListVO);
                reconcilitionHisListVoList.add(reconcilitionHisListVO);
            }
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            rspBo.setRows(reconcilitionHisListVoList);
            return rspBo;
        }
        logger.error("\u662f\u5426\u4e34\u65f6\u8868\u4e3a\u7a7a\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBo.getVersionNo());
        rspBo.setRespCode("18000");
        rspBo.setRespDesc("\u662f\u5426\u4e34\u65f6\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        rspBo.setRows(new ArrayList());
        return rspBo;
    }

    private List<PayPurchaseOrderInfo> getOrderList(QueryPayPurchaseOrderInfoReqBO reqBO) {
        PayPurchaseOrderInfo payPurchaseOrder = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)reqBO, (Object)payPurchaseOrder);
        payPurchaseOrder.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        String busiModel = "";
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            payPurchaseOrder.setOperUnitNo(reqBO.getCompanyId());
            busiModel = BusiModel.TRADE_MODEL.getCode();
        } else {
            payPurchaseOrder.setPurchaseNo(reqBO.getCompanyId());
            busiModel = BusiModel.MATCH_UP_MODEL.getCode();
        }
        if (null != reqBO.getSupplierNo()) {
            payPurchaseOrder.setSupplierNo(reqBO.getSupplierNo());
        }
        if (reqBO.getActivityId() != null) {
            busiModel = "";
        }
        Long excludeOrg = null;
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            if (null != reqBO.getPurchaseNo()) {
                payPurchaseOrder.setPurchaseNo(reqBO.getPurchaseNo());
            } else {
                excludeOrg = reqBO.getCompanyId();
            }
        }
        if (null != reqBO.getPayModel() && "purchaser".equals(reqBO.getPayModel())) {
            payPurchaseOrder.setPurchaserId(reqBO.getUserId());
        }
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        BeanUtils.copyProperties((Object)payPurchaseOrder, (Object)vo);
        vo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        vo.setOrderDateStart(reqBO.getOrderDateStart());
        vo.setOrderDateEnd(reqBO.getOrderDateEnd());
        vo.setRecvDateStart(reqBO.getRecvDateStart());
        vo.setRecvDateEnd(reqBO.getRecvDateEnd());
        vo.setExcludeOrg(excludeOrg);
        vo.setPurchaserId(payPurchaseOrder.getPurchaserId());
        vo.setBusiModel(busiModel);
        if (reqBO.getQueryPayPurchaseOrderInfoReqBOs() != null) {
            ArrayList<PayPurchaseOrderInfo> payPurchaseOrderInfos = new ArrayList<PayPurchaseOrderInfo>();
            for (QueryPayPurchaseOrderInfoReqBO reqBO1 : reqBO.getQueryPayPurchaseOrderInfoReqBOs()) {
                PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                payPurchaseOrderInfo.setOrderId(reqBO1.getOrderId());
                payPurchaseOrderInfo.setInspectionId(reqBO1.getInspectionId());
                payPurchaseOrderInfos.add(payPurchaseOrderInfo);
            }
            vo.setPayPurchaseOrderInfos(payPurchaseOrderInfos);
        }
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListPageExcludePurchaseByJD(vo);
        return payPurchaseOrderInfoPOs;
    }

    @PostMapping(value={"cancelReconclitionJD"})
    public ReconcilitionHisListRspBO cancelReconclitionJD(@RequestBody QueryPayPurchaseOrderInfoReqBO reqBO) {
        ReconcilitionHisListRspBO rspBO = new ReconcilitionHisListRspBO();
        if (null == reqBO.getSupplierNo()) {
            throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546ID\u5fc5\u987b\u8f93\u5165");
        }
        try {
            DicDictionaryPO dic = new DicDictionaryPO();
            dic.setCode(reqBO.getSupplierNo().toString());
            DicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dic);
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.getOrderList(reqBO);
            Integer versionNum = null;
            try {
                long version = this.versionSeq.nextId();
                versionNum = (int)version;
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u83b7\u53d6\u7248\u672c\u53f7\u5931\u8d25\uff01");
            }
            if (versionNum == null) {
                versionNum = 0;
            }
            Integer e = versionNum;
            Integer n = versionNum = Integer.valueOf(versionNum + 1);
            BusiGetReconciliationDataServiceRspBO busiGetReconciliationDataServiceRspBO = new BusiGetReconciliationDataServiceRspBO();
            ArrayList<ReconcilitionListTempPo> list = new ArrayList<ReconcilitionListTempPo>();
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoPOs) {
                BusiGetReconciliationDataServiceReqBO busiGetReconciliationDataServiceReqBO = new BusiGetReconciliationDataServiceReqBO();
                busiGetReconciliationDataServiceReqBO.setOrderId(payPurchaseOrderInfo.getExtOrderId());
                busiGetReconciliationDataServiceReqBO.setSupplierId(reqBO.getSupplierNo());
                busiGetReconciliationDataServiceReqBO.setSupplierName(dicDictionaryPO.getDescrip());
                String busiModel = payPurchaseOrderInfo.getBusiModel();
                if (null != busiModel && !"".equals(busiModel) && BusiModel.MATCH_UP_MODEL.getCode().equals(payPurchaseOrderInfo.getBusiModel())) {
                    busiGetReconciliationDataServiceReqBO.setJdOrgId(payPurchaseOrderInfo.getJdOrgId());
                }
                if ((busiGetReconciliationDataServiceRspBO = this.busiGetReconciliationDataService.getJDOrderDetailData(busiGetReconciliationDataServiceReqBO)).getDataList() == null || busiGetReconciliationDataServiceRspBO.getDataList().get(0) == null || ((BusiGetReconciliationDataRspVO)busiGetReconciliationDataServiceRspBO.getDataList().get(0)).getOrders() == null || ((BusiGetReconciliationDataRspVO)busiGetReconciliationDataServiceRspBO.getDataList().get(0)).getOrders().size() <= 0) continue;
                for (PayReconciliationDetailVO payReconciliationDetailVO : ((BusiGetReconciliationDataRspVO)busiGetReconciliationDataServiceRspBO.getDataList().get(0)).getOrders()) {
                    ReconcilitionListTempPo reconcilitionListTempPo = new ReconcilitionListTempPo();
                    reconcilitionListTempPo.setVersionNo(versionNum);
                    reconcilitionListTempPo.setSupplierName(dicDictionaryPO.getDescrip());
                    reconcilitionListTempPo.setExtOrderId(payReconciliationDetailVO.getOrderId());
                    reconcilitionListTempPo.setOutAmt(payReconciliationDetailVO.getOrderPrice());
                    logger.error("\u5bf9\u8c61\uff1a" + reconcilitionListTempPo.toString());
                    list.add(reconcilitionListTempPo);
                }
            }
            if (!list.isEmpty()) {
                this.reconcilitionHisTempMapper.insertBatch(list);
            }
            rspBO.setVersionNo(versionNum.toString());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
            throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546ID\u5fc5\u987b\u8f93\u5165");
        }
        return rspBO;
    }

    @PostMapping(value={"registerReconcilitionJD"})
    public BusiReconcilitionRspBO registerReconcilitionJD(@RequestBody BusiReconcilitionRepBO reqBO) {
        List<String> orderId;
        if (logger.isDebugEnabled()) {
            logger.debug("\u7ed3\u7b97\u5bf9\u8d26\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.getVersionNo());
        }
        BusiReconcilitionRspBO rspBO = new BusiReconcilitionRspBO();
        if (!StringUtils.hasText((String)reqBO.getVersionNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
            return rspBO;
        }
        Long purchaseNo = null;
        Long purchaserId = null;
        String busiModel = null;
        try {
            List<ReconcilitionHisTemp> listTemp = this.reconcilitionHisTempMapper.selectByVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            if (CollectionUtils.isEmpty(listTemp)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u65e0\u5bf9\u8d26\u6570\u636e\u4e0d\u80fd\u5bf9\u8d26\uff0c\u8bf7\u5bfc\u5165\u5bf9\u8d26\u6570\u636e");
                return rspBO;
            }
            ReconciliationSup reconciliationSup = new ReconciliationSup();
            reconciliationSup.setReconciliationDate(new Date());
            reconciliationSup.setSupplierName(listTemp.get(0).getSupplierName());
            reconciliationSup.setUserName(reqBO.getName());
            reconciliationSup.setVersionNo(Integer.valueOf(reqBO.getVersionNo()));
            this.reconciliationSupMapper.insert(reconciliationSup);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u7ed3\u7b97\u4f9b\u5e94\u5546\u5bf9\u8d26\u8bb0\u5f55\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u6dfb\u52a0\u7ed3\u7b97\u4f9b\u5e94\u5546\u5bf9\u8d26\u8bb0\u5f55\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.insertAccountByJD(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode(), reqBO.getUsername(), 2, purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId);
            this.reconcilitionHisMapper.insertAccountByJD(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.AGREEMENT.getCode(), reqBO.getUsername(), 4, purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId);
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.AGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.AGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        try {
            this.reconcilitionHisMapper.insertAccountByJD(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode(), reqBO.getUsername(), 1, purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId);
            this.reconcilitionHisMapper.insertAccountByJD(Integer.valueOf(reqBO.getVersionNo()), OrderStatus.AFTER_SALE.getCode(), ReconciliationStatus.DISAGREEMENT.getCode(), reqBO.getUsername(), 3, purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel, purchaserId);
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
        }
        try {
            orderId = this.payPurchaseOrderInfoMapper.selectByrstatus(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.DISAGREEMENT.getCode());
            if (!CollectionUtils.isEmpty(orderId)) {
                this.payPurchaseOrderInfoMapper.updateReconciliation(orderId, ReconciliationStatus.DISAGREEMENT.getCode());
            }
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u91d1\u989d\u4e0d\u4e00\u81f4\u7ed3\u7b97\u5bf9\u8d26\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        List<ReconcilitionHis> nonacceptanceList = this.reconcilitionHisMapper.selectNonacceptance(Integer.valueOf(reqBO.getVersionNo()), ReconciliationStatus.NON_ACCEPTANCE.getCode(), purchaseNo, reqBO.getQueryPayPurchaseOrderInfoReqBOs(), busiModel);
        if (null != nonacceptanceList && !nonacceptanceList.isEmpty()) {
            LinkedList<String> extOrderIdList = new LinkedList<String>();
            for (ReconcilitionHis rechis : nonacceptanceList) {
                extOrderIdList.add(rechis.getExtOrderId());
            }
            LinkedHashSet middleLinkedHashSet = new LinkedHashSet(extOrderIdList);
            ArrayList<String> afterHashSetList = new ArrayList<String>(middleLinkedHashSet);
            FscUnacceptedOrderInfoBO unacceptedOrder = this.orderService.getUnacceptedOrder(afterHashSetList);
            if (null == unacceptedOrder) {
                logger.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5931\u8d25\uff01");
            }
            logger.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\uff0c\u6839\u636e\u5916\u90e8\u8ba2\u5355ID\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u6210\u529f\uff01");
            Map orderIdMap = unacceptedOrder.getOrderIdMap();
            Map createTimeMap = unacceptedOrder.getCreateTimeMap();
            Map supplierIdMap = unacceptedOrder.getSupplierIdMap();
            Map supplierNameMap = unacceptedOrder.getSupplierNameMap();
            Map companyIdMap = unacceptedOrder.getCompanyIdMap();
            for (ReconcilitionHis reconhis : nonacceptanceList) {
                reconhis.setOrderId((String)orderIdMap.get(reconhis.getExtOrderId()));
                reconhis.setOrderDate((Date)createTimeMap.get(reconhis.getExtOrderId()));
                reconhis.setSupplierNo((Integer)supplierIdMap.get(reconhis.getExtOrderId()));
                reconhis.setSupplierName((String)supplierNameMap.get(reconhis.getExtOrderId()));
                reconhis.setOperUnitNo((Long)companyIdMap.get(reconhis.getExtOrderId()));
            }
            try {
                this.reconcilitionHisMapper.insertReconcilitionHisList(nonacceptanceList);
            }
            catch (Exception e) {
                logger.error("\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25\uff0c\u7248\u672c\u53f7\u4e3a\uff1a" + reqBO.getVersionNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u5546\u57ce\u672a\u9a8c\u6536\u7ed3\u7b97\u5bf9\u8d26\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setBatchNo(Integer.valueOf(reqBO.getVersionNo()));
        return rspBO;
    }
}

