/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.trade.PaymentFlowService;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoBO;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoReqBO;
import com.tydic.pfscext.api.trade.bo.PaymentFlowInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.FlowType;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayFlowPayType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.PaymentFlowService"})
public class PaymentFlowServiceImpl
implements PaymentFlowService {
    private static final Logger logger = LoggerFactory.getLogger(PaymentFlowServiceImpl.class);
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"addPaymentFlow"})
    public PfscExtRspBaseBO addPaymentFlow(@RequestBody PaymentFlowInfoBO paymentFlowInfoBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u7ed3\u7b97\u6d41\u6c34\uff1a" + paymentFlowInfoBO);
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        BeanUtils.copyProperties((Object)paymentFlowInfoBO, (Object)paymentFlowInfo);
        paymentFlowInfo.setCreateTime(new Date());
        this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        pfscExtRspBaseBO.setRespCode("0000");
        pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"queryListPage"})
    public PfscExtRspPageBaseBO<PaymentFlowInfoRspBO> queryListPage(@RequestBody PaymentFlowInfoReqBO paymentFlowInfoReqBO) {
        Page page;
        List<PaymentFlowInfo> paymentFlowInfos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7ed3\u7b97\u6d41\u6c34\uff1a" + paymentFlowInfoReqBO);
        }
        PfscExtRspPageBaseBO rspBO = new PfscExtRspPageBaseBO();
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        BeanUtils.copyProperties((Object)paymentFlowInfoReqBO, (Object)paymentFlowInfo);
        paymentFlowInfo.setOrgId(null);
        if (!"0".equals(paymentFlowInfoReqBO.getIsProfessionalOrgExt())) {
            paymentFlowInfo.setPayOrgNo(paymentFlowInfoReqBO.getCompanyId());
        }
        if ((paymentFlowInfos = this.paymentFlowInfoMapper.qryPaymentFlowList(paymentFlowInfo, (Page<Map<String, Object>>)(page = new Page(paymentFlowInfoReqBO.getPageNo().intValue(), paymentFlowInfoReqBO.getPageSize().intValue())))) != null && paymentFlowInfos.size() > 0) {
            List<SaleOrderInfo> saleOrderInfos;
            ArrayList<String> orderCodes = new ArrayList<String>();
            for (PaymentFlowInfo paymentFlowInfoPO : paymentFlowInfos) {
                orderCodes.add(paymentFlowInfoPO.getOrderCode());
            }
            HashMap<String, SaleOrderInfo> maps = new HashMap<String, SaleOrderInfo>();
            if (orderCodes.size() > 0 && (saleOrderInfos = this.saleOrderInfoMapper.getListBySaleCode(orderCodes)) != null && saleOrderInfos.size() > 0) {
                for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                    maps.put(saleOrderInfo.getSaleOrderCode(), saleOrderInfo);
                }
            }
            ArrayList<PaymentFlowInfoRspBO> payFlows = new ArrayList<PaymentFlowInfoRspBO>();
            for (PaymentFlowInfo paymentFlowInfoPO : paymentFlowInfos) {
                PaymentFlowInfoRspBO paymentFlowInfoRspBO = new PaymentFlowInfoRspBO();
                BeanUtils.copyProperties((Object)paymentFlowInfoPO, (Object)paymentFlowInfoRspBO);
                if (paymentFlowInfoPO.getFlowFlag() != null) {
                    paymentFlowInfoRspBO.setFlowFlagStr(FlowFlag.getInstance(paymentFlowInfoPO.getFlowFlag()).getDescr());
                }
                if (paymentFlowInfoPO.getFlowType() != null) {
                    paymentFlowInfoRspBO.setFlowTypeStr(FlowType.getInstance(paymentFlowInfoPO.getFlowType().toString()).getDescr());
                }
                if (paymentFlowInfoPO.getPayChannel() != null && !"".equals(paymentFlowInfoPO.getPayChannel())) {
                    paymentFlowInfoRspBO.setPayChannelStr(PayChannel.getInstance(paymentFlowInfoPO.getPayChannel()).getDescr());
                }
                if (paymentFlowInfoPO.getPayType() != null) {
                    paymentFlowInfoRspBO.setPayTypeStr(PayFlowPayType.getInstance(paymentFlowInfoPO.getPayType()).getDescr());
                }
                if (paymentFlowInfoPO.getOrderCode() != null && maps.get(paymentFlowInfoPO.getOrderCode()) != null) {
                    paymentFlowInfoRspBO.setOrderId(((SaleOrderInfo)maps.get(paymentFlowInfoPO.getOrderCode())).getOrderId());
                    paymentFlowInfoRspBO.setPurchaseOrderId(((SaleOrderInfo)maps.get(paymentFlowInfoPO.getOrderCode())).getPurchaseOrderId());
                }
                payFlows.add(paymentFlowInfoRspBO);
            }
            rspBO.setRows(payFlows);
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

