/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.busi.bo.ReconciliationReqBo;
import com.tydic.pfscext.api.notify.SendOrderReconcileService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.api.notify.bo.MailFileBO;
import com.tydic.pfscext.api.trade.ReconcilitionEmailService;
import com.tydic.pfscext.base.ComFscFileAppBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.po.ReconcilitionHis;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.ReconcilitionEmailService"})
public class ReconcilitionEmailServiceImpl
implements ReconcilitionEmailService {
    private static final Logger logger = LoggerFactory.getLogger(ReconcilitionEmailServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String path = "fsc";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${fastdfs.downloadUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Autowired
    private SendOrderReconcileService sendOrderReconcileService;
    private String[] sheetNames = new String[]{"\u91d1\u989d\u4e0d\u4e00\u81f4\u8ba2\u5355", "\u672a\u9a8c\u6536\u8ba2\u5355"};
    private String[][] outMap = new String[][]{{"supplierName", "A", "S"}, {"orderId", "B", "S"}, {"orderDate", "C", "T"}, {"reconciliationDate", "D", "T"}, {"extOrderId", "E", "S"}, {"purchaseProjectId", "F", "S"}, {"orderAmt", "G", "D"}, {"outAmt", "H", "D"}};
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;

    @PostMapping(value={"ReconcilitionEmail"})
    public PfscExtRspBaseBO ReconcilitionEmail(@RequestBody ReconciliationReqBo reconciliationReqBo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u90ae\u4ef6\u53d1\u9001\u670d\u52a1\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reconciliationReqBo.getVersionNo());
        }
        final FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        reconciliationReqBo.setTabId(Integer.valueOf(2));
        reconciliationReqBo.setReconciliationStatus(Integer.valueOf(2));
        List<ReconcilitionHis> listrows = this.reconcilitionHisMapper.getHisByCondition(reconciliationReqBo);
        reconciliationReqBo.setTabId(Integer.valueOf(3));
        reconciliationReqBo.setReconciliationStatus(Integer.valueOf(3));
        List<ReconcilitionHis> noAccrows = this.reconcilitionHisMapper.getHisByCondition(reconciliationReqBo);
        if (listrows != null && listrows.size() > 0 || noAccrows != null && noAccrows.size() > 0) {
            int idx;
            String cellName;
            String fieldName;
            int i;
            Object[] fieldsData;
            ExcelFile excel = new ExcelFile();
            int sheetIdx = 0;
            excel.createSheet(this.sheetNames[sheetIdx]);
            Object[] headerTitle = new String[]{"\u4f9b\u5e94\u5546", "\u8ba2\u5355\u7f16\u53f7", "\u8ba2\u5355\u65e5\u671f", "\u786e\u8ba4\u5230\u8d27\u65e5\u671f", "\u7535\u5546\u8ba2\u5355\u7f16\u53f7", "\u8d26\u5957", "\u7535\u5546\u53ef\u7ed3\u7b97\u91d1\u989d", "\u5546\u57ce\u53ef\u7ed3\u7b97\u91d1\u989d"};
            String[] cellFormat = new String[1];
            cellFormat = new String[headerTitle.length];
            excel.setCellsFormat(sheetIdx, cellFormat);
            excel.addRow(sheetIdx, headerTitle, 14);
            if (listrows != null && listrows.size() > 0) {
                for (ReconcilitionHis reconcilitionHis : listrows) {
                    fieldsData = new String[headerTitle.length];
                    for (i = 0; i < this.outMap.length; ++i) {
                        fieldName = this.outMap[i][0];
                        cellName = this.outMap[i][1];
                        idx = ExcelFile.cellNameToIndex((String)cellName);
                        fieldsData[idx] = "orderDate".equals(fieldName) && reconcilitionHis.getOrderDate() != null ? DateFormatUtils.format((Date)reconcilitionHis.getOrderDate(), (String)"yyyy-MM-dd") : ("reconciliationDate".equals(fieldName) && reconcilitionHis.getReconciliationDate() != null ? DateFormatUtils.format((Date)reconcilitionHis.getReconciliationDate(), (String)"yyyy-MM-dd") : this.getProp(reconcilitionHis, fieldName));
                    }
                    logger.debug("\u5bfc\u51fa\u901a\u77e5\u5355\u4fe1\u606f=" + Arrays.toString(fieldsData));
                    excel.addRow(sheetIdx, fieldsData, 14);
                }
                fscRemindReqBO.setOperNo(listrows.get(0).getOperUnitNo());
                fscRemindReqBO.setOrderId(listrows.get(0).getPurchaseNo());
                fscRemindReqBO.setPayModel(listrows.get(0).getPayModel());
            }
            excel.createSheet(this.sheetNames[++sheetIdx]);
            excel.addRow(sheetIdx, headerTitle, 14);
            if (noAccrows != null && noAccrows.size() > 0) {
                for (ReconcilitionHis reconcilitionHis : noAccrows) {
                    fieldsData = new String[headerTitle.length];
                    for (i = 0; i < this.outMap.length; ++i) {
                        fieldName = this.outMap[i][0];
                        cellName = this.outMap[i][1];
                        idx = ExcelFile.cellNameToIndex((String)cellName);
                        fieldsData[idx] = "orderDate".equals(fieldName) && reconcilitionHis.getOrderDate() != null ? DateFormatUtils.format((Date)reconcilitionHis.getOrderDate(), (String)"yyyy-MM-dd") : ("reconciliationDate".equals(fieldName) && reconcilitionHis.getReconciliationDate() != null ? DateFormatUtils.format((Date)reconcilitionHis.getReconciliationDate(), (String)"yyyy-MM-dd") : this.getProp(reconcilitionHis, fieldName));
                    }
                    logger.debug("\u5bfc\u51fa\u901a\u77e5\u5355\u4fe1\u606f=" + Arrays.toString(fieldsData));
                    excel.addRow(sheetIdx, fieldsData, 14);
                }
                fscRemindReqBO.setOperNo(noAccrows.get(0).getOperUnitNo());
                fscRemindReqBO.setOrgId(noAccrows.get(0).getPurchaseNo());
                fscRemindReqBO.setPayModel(noAccrows.get(0).getPayModel());
            }
            excel.close();
            File file = this.getFileByExcel(excel);
            String fileUrl = this.upload(file, reconciliationReqBo);
            logger.debug("fileUrl=" + fileUrl);
            MailFileBO mailFileBO = new MailFileBO();
            mailFileBO.setFileName("\u5bf9\u8d26\u9644\u4ef6");
            mailFileBO.setFileUrl(fileUrl);
            ArrayList<MailFileBO> mailFileBOS = new ArrayList<MailFileBO>();
            mailFileBOS.add(mailFileBO);
            fscRemindReqBO.setMailFileBOS(mailFileBOS);
            new Thread(){

                @Override
                public void run() {
                    logger.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2: " + fscRemindReqBO);
                    ReconcilitionEmailServiceImpl.this.sendOrderReconcileService.send(fscRemindReqBO);
                }
            }.start();
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private File getFileByExcel(ExcelFile excel) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            excel.saveAsOutStream((OutputStream)outStream);
            file = File.createTempFile("file", ".xls");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception e) {
            logger.error("url\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ZTBusinessException("url\u8f6c\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95edio\u5931\u8d25\uff1a", (Throwable)e);
                throw new ZTBusinessException("\u5173\u95edio\u5931\u8d25");
            }
        }
        return file;
    }

    private String upload(File file, ReconciliationReqBo reconciliationReqBo) {
        InputStream inputStream = null;
        try {
            logger.error("\u53d1\u7968file1\uff1a" + file);
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            inputStream = multipartFile.getInputStream();
            String fileName = multipartFile.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            ComFscFileAppBO comFscFileAppBO = new ComFscFileAppBO();
            comFscFileAppBO.setFile(bytes);
            comFscFileAppBO.setFileName(fileName);
            comFscFileAppBO.setFileType(suffix);
            logger.error("\u53d1\u7968comFscFileAppBO\uff1a" + comFscFileAppBO);
            String string = this.upload(comFscFileAppBO, reconciliationReqBo);
            return string;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }

    private String upload(ComFscFileAppBO file, ReconciliationReqBo reconciliationReqBo) {
        try {
            String fileUrl;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = null;
            fileName = reconciliationReqBo.getSaleOrderCode() + file.getFileType();
            String path = this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                String httphead = "https://";
                if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png") || path.endsWith(".pdf")) {
                    httphead = "http://";
                }
                fileUrl = httphead + this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                String httphead = "http://";
                fileUrl = httphead + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            return fileUrl;
        }
        catch (Exception e) {
            logger.error("\u53d1\u7968fileUrl\uff1a", (Throwable)e);
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }

    private Object getProp(Object bean, String name) {
        String v = null;
        try {
            v = BeanUtils.getProperty((Object)bean, (String)name);
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bfb\u53d6Bean\u5c5e\u6027\u5230Excel\u6570\u636e\u5217\u5931\u8d25,name=" + name, (Throwable)e);
            return null;
        }
    }
}

