/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiCheckAccountBalanceTranDetailService;
import com.tydic.pfscext.api.busi.bo.BusiCheckAccountBalanceTranDetailPageRspBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckAccountBalanceTranDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckAccountBalanceTranDetailRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SubAcctInfoMapper;
import com.tydic.pfscext.dao.TranDetailMapper;
import com.tydic.pfscext.dao.bo.TranDetailExt;
import com.tydic.pfscext.dao.po.TranDetail;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BusinessType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.busi.impl.BusiCheckAccountBalanceManageServiceImpl;
import com.tydic.pfscext.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCheckAccountBalanceTranDetailServiceImpl
implements BusiCheckAccountBalanceTranDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCheckAccountBalanceManageServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public BusiCheckAccountBalanceTranDetailPageRspBO query(BusiCheckAccountBalanceTranDetailReqBO reqBO) {
        if (isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4f59\u989d\u4e0b\u5f00\u7968\u7533\u8bf7\u660e\u7ec6\u5165\u53c2{}", (Object)reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiCheckAccountBalanceTranDetailPageRspBO resultRspBO = new BusiCheckAccountBalanceTranDetailPageRspBO();
        SubAcctInfoExt subAcctInfoExt = new SubAcctInfoExt();
        subAcctInfoExt.setSubAcctNo(reqBO.getSubAcctNo());
        List<SubAcctInfoExt> subAcctInfoExtList = this.subAcctInfoMapper.selectWihtMainAcct(subAcctInfoExt);
        if (CollectionUtils.isEmpty(subAcctInfoExtList)) {
            throw new PfscExtBusinessException("18001", "\u8d44\u91d1\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        SubAcctInfoExt subAcctInfo = subAcctInfoExtList.get(0);
        resultRspBO.setSubAcctName(subAcctInfo.getSubAcctName());
        resultRspBO.setPurchaseUnitName(this.organizationInfoService.queryProjectName(subAcctInfo.getProjectId()).getAccountName());
        BigDecimal addItemAmtSum = this.getTranDetailAddItemSum(subAcctInfo.getSubAcctNo());
        BigDecimal invoiceAmtSum = this.getAmtSumApplyInfo(subAcctInfo.getProjectId(), OrderSource.ELECTRIC_AREA.getCode(), BillStatus.SEND_BILL.getCode(), subAcctInfo.getSuperiorOrgId());
        resultRspBO.setCheckBalanceAmtSum(addItemAmtSum.subtract(invoiceAmtSum));
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        TranDetailExt tranDetailExt = new TranDetailExt();
        tranDetailExt.setSubAcctNo(reqBO.getSubAcctNo());
        tranDetailExt.setBusinessType(reqBO.getBusinessType());
        tranDetailExt.setServiceNo(reqBO.getServiceNo());
        tranDetailExt.setTranDateStart(reqBO.getTranDate());
        tranDetailExt.setTranDateEnd(reqBO.getEndTranDate());
        if (reqBO.getEndTranDate() != null) {
            String endDate = DateUtil.dateToStr(reqBO.getEndTranDate(), "yyyy-MM-dd") + " 23:59:59";
            tranDetailExt.setTranDateEnd(DateUtil.strToDate(endDate, "yyyy-MM-dd HH:mm:ss"));
        }
        List<TranDetail> data = this.tranDetailMapper.selectManageTranDetailPageList(tranDetailExt, (Page<Map<String, Object>>)page);
        ArrayList<BusiCheckAccountBalanceTranDetailRspBO> rows = new ArrayList<BusiCheckAccountBalanceTranDetailRspBO>();
        for (TranDetail tranDetail : data) {
            BusiCheckAccountBalanceTranDetailRspBO infoRspBO = new BusiCheckAccountBalanceTranDetailRspBO();
            infoRspBO.setBusinessType(tranDetail.getBusinessType());
            infoRspBO.setBusinessTypeDescr(this.enumsService.getDescr(BusinessType.getInstance(tranDetail.getBusinessType())));
            infoRspBO.setServiceNo(tranDetail.getServiceNo());
            infoRspBO.setTranDate(tranDetail.getTranDate());
            if (BigDecimal.ZERO.compareTo(tranDetail.getTranAmt()) > 0) {
                infoRspBO.setSubtractItemAmt(tranDetail.getTranAmt().negate());
                infoRspBO.setAddItemAmt(BigDecimal.ZERO);
            } else {
                infoRspBO.setAddItemAmt(tranDetail.getTranAmt());
                infoRspBO.setSubtractItemAmt(BigDecimal.ZERO);
            }
            rows.add(infoRspBO);
        }
        resultRspBO.setRows(rows);
        resultRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        resultRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        resultRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return resultRspBO;
    }

    private BigDecimal getAmtSumApplyInfo(Long projectId, String source, String billStatus, Long operUnitNo) {
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setPurchaseProjectId(projectId);
        billApplyInfoVO.setBillStatus(billStatus);
        billApplyInfoVO.setSource(source);
        billApplyInfoVO.setOperUnitNo(operUnitNo);
        BigDecimal sumAmt = this.billApplyInfoMapper.getAmtSumApplyInfo(billApplyInfoVO);
        return sumAmt;
    }

    private BigDecimal getTranDetailAddItemSum(String subAcctNo) {
        TranDetailExt ext = new TranDetailExt();
        ext.setSubAcctNo(subAcctNo);
        BigDecimal addItemAmt = this.tranDetailMapper.selectManageTranDetailSum(ext);
        return addItemAmt;
    }
}

