/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQryAccountBalanceService;
import com.tydic.pfscext.api.busi.bo.BusiQryAccountBalanceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryAccountBalanceRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SourceMappingService;
import com.tydic.pfscext.service.atom.SubAccountService;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryAccountBalanceService"})
public class BusiQryAccountBalanceServiceImpl
implements BusiQryAccountBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryAccountBalanceServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private SourceMappingService sourceMappingService;

    @PostMapping(value={"busiQryAccount"})
    public BusiQryAccountBalanceRspBO busiQryAccount(@RequestBody BusiQryAccountBalanceReqBO busiQryAccountReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + busiQryAccountReqBO.toString());
        }
        if (null == busiQryAccountReqBO.getOperatingUnitNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1-\u4e13\u4e1a\u673a\u6784\u7f16\u53f7[operatingUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiQryAccountReqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiQryAccountReqBO.getPurchaseUnitNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7[purchaseUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == busiQryAccountReqBO.getPurchaseBookNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1-\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u7f16\u53f7[getPurchaseBookNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(busiQryAccountReqBO.getSource());
        SubAcctInfoExt subAcctInfo = this.subAccountService.getWithMainAccount(busiQryAccountReqBO.getOperatingUnitNo(), targetSource, busiQryAccountReqBO.getPurchaseUnitNo(), busiQryAccountReqBO.getPurchaseBookNo(), null);
        if (subAcctInfo == null) {
            logger.debug("\u67e5\u8be2\u865a\u62df\u5b50\u8d26\u6237\u5165\u53c2\u4e3a\uff1a operUnitNo=" + busiQryAccountReqBO.getOperatingUnitNo() + ", souce=" + busiQryAccountReqBO.getSource() + ", purchaseUnitNo=" + busiQryAccountReqBO.getPurchaseUnitNo() + ", projectId=" + busiQryAccountReqBO.getPurchaseBookNo() + ", serviceType= null");
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8d26\u6237\u4f59\u989d\u4e1a\u52a1\u670d\u52a1-\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a\u865a\u62df\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        BusiQryAccountBalanceRspBO accountRspBO = new BusiQryAccountBalanceRspBO();
        accountRspBO.setRemainOverDraft(subAcctInfo.getOverdraft().subtract(subAcctInfo.getUsedOverdraft()));
        accountRspBO.setAcctBalance(subAcctInfo.getBalance());
        BigDecimal amountCanUse = subAcctInfo.getBalance().add(subAcctInfo.getOverdraft());
        if (busiQryAccountReqBO.getTxnAmount() != null && amountCanUse.compareTo(busiQryAccountReqBO.getTxnAmount()) >= 0) {
            accountRspBO.setFlag(true);
        } else {
            accountRspBO.setFlag(false);
        }
        accountRspBO.setRespCode("0000");
        accountRspBO.setRespDesc("\u6210\u529f");
        return accountRspBO;
    }
}

