/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQueryDetailRecAmtConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailHeadRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailListRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailRecAmtConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailRecAmtConfirmRspBO;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.RecvAmtDetailMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.RecAmtConfirm;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.dao.vo.RecvAmtDetailVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQueryDetailRecAmtConfirmService"})
public class BusiQueryDetailRecAmtConfirmServiceImpl
implements BusiQueryDetailRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;

    @PostMapping(value={"queryDetailRecAmtConfirm"})
    public BusiQueryDetailRecAmtConfirmRspBO queryDetailRecAmtConfirm(@RequestBody BusiQueryDetailRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocNum() == null) {
            throw new PfscExtBusinessException("0001", "\u5355\u636e\u7f16\u53f7[docNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(reqBO.getDocNum());
        if (recAmtConfirm == null) {
            throw new PfscExtBusinessException("0001", "\u672a\u67e5\u8be2\u5230\u8be5\u6536\u6b3e\u5355[" + reqBO.getDocNum() + "]");
        }
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        advanceReceiveVO.setOrderBy("tt.SEQ desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<AdvanceReceive> rows = null;
        rows = OrderSource.ELECTRIC_MARKET.getCode().equals(recAmtConfirm.getSource()) ? this.advanceReceiveMapper.selectListPage(advanceReceiveVO, (Page<Map<String, Object>>)page) : this.advanceReceiveMapper.selectListPageDlzq(advanceReceiveVO, (Page<Map<String, Object>>)page);
        BusiQueryDetailRecAmtConfirmRspBO rspBO = new BusiQueryDetailRecAmtConfirmRspBO();
        BusiQueryDetailHeadRecAmtConfirmRspBO head = new BusiQueryDetailHeadRecAmtConfirmRspBO();
        rspBO.setHead(head);
        ArrayList<BusiQueryDetailListRecAmtConfirmRspBO> detailRows = new ArrayList<BusiQueryDetailListRecAmtConfirmRspBO>();
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        head.setDocNum(String.valueOf(recAmtConfirm.getDocNum()));
        String orgName = this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId());
        head.setOrgName(orgName);
        for (AdvanceReceive row : rows) {
            BusiQueryDetailListRecAmtConfirmRspBO detail = new BusiQueryDetailListRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(row));
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            detail.setStatusDescr(AdvanceReceiveStatus.getInstance(row.getStatus()).getCodeDescr());
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(row.getSource())) {
                detail.setWriteoffAmtThisTime(row.getTranAmt());
            } else {
                RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
                recvAmtDetailVO.setDocNum(recAmtConfirm.getDocNum());
                recvAmtDetailVO.setAdvRecvSeq(row.getSeq());
                RecvAmtDetailVO queryAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
                detail.setWriteoffAmtThisTime(queryAmtDetailVO.getAmount());
            }
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detailRows.add(detail);
        }
        return rspBO;
    }
}

