/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.QueryBillApplyForImportInvoiceService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.JDAssignStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.busi.impl.QueryBillApplyForMailServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryBillApplyForImportInvoiceService"})
public class QueryBillApplyForImportInvoiceServiceImpl
implements QueryBillApplyForImportInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryBillApplyForImportInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"queryToMail"})
    public QueryBillApplyForMailRspBO queryToMail(@RequestBody QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u90ae\u5bc4(\u5bfc\u5165\u7684\u53d1\u7968)\uff08\u4e0d\u5305\u62ec\u5e73\u53f0\u4f7f\u7528\u8d39\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new PfscExtBusinessException("0001", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        String orderBy = "b.SEQ asc";
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoiceImport(reqBO, orderBy);
        ArrayList<PurchaseNoListVO> mails = new ArrayList<PurchaseNoListVO>();
        ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
        String invoceName = null;
        String name = null;
        for (int i = 0; i < invoiceForMailVOs.size(); ++i) {
            InvoiceForMailVO firstInvoice;
            PurchaseNoListVO mail;
            InvoiceForMailVO invocie = invoiceForMailVOs.get(i);
            if (!StringUtils.hasText(invoceName) || !StringUtils.hasText(name)) {
                invoices.add(invocie);
            } else if (invoceName.equals(invocie.getInvoceName()) && name.equals(invocie.getName())) {
                invoices.add(invocie);
            } else {
                if (!invoices.isEmpty()) {
                    mail = new PurchaseNoListVO();
                    mail.setIsImport("1");
                    mail.setInvoceName(invoceName);
                    mail.setName(name);
                    firstInvoice = (InvoiceForMailVO)invoices.get(0);
                    mail.setMobile(firstInvoice.getMobile());
                    mail.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                    mail.setDetailAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
                    mail.setCount(Integer.valueOf(invoices.size()));
                    mail.setInvoiceForMailList(invoices);
                    mails.add(mail);
                }
                invoices = new ArrayList();
                invoices.add(invocie);
            }
            invoceName = invocie.getInvoceName();
            name = invocie.getName();
            if (i != invoiceForMailVOs.size() - 1 || invoices.isEmpty()) continue;
            mail = new PurchaseNoListVO();
            mail.setIsImport("1");
            mail.setInvoceName(invoceName);
            mail.setName(name);
            firstInvoice = (InvoiceForMailVO)invoices.get(0);
            mail.setMobile(firstInvoice.getMobile());
            mail.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
            mail.setDetailAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
            mail.setCount(Integer.valueOf(invoices.size()));
            mail.setInvoiceForMailList(invoices);
            mails.add(mail);
        }
        QueryBillApplyForMailRspBO rspBO = new QueryBillApplyForMailRspBO();
        rspBO.setRows(mails);
        rspBO.setRecordsTotal(Integer.valueOf(mails.size()));
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setPageNo(Integer.valueOf(1));
        return rspBO;
    }

    @PostMapping(value={"queryMailed"})
    public QueryBillApplyForMailRspBO queryMailed(@RequestBody QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5df2\u90ae\u5bc4(\u5bfc\u5165\u7684\u53d1\u7968)\uff08\u4e0d\u5305\u62ec\u5e73\u53f0\u4f7f\u7528\u8d39\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new PfscExtBusinessException("0001", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        reqBO.setOrderBy("c.SEQ asc");
        List<InvoiceForMailVO> invoiceList = this.saleInvoiceMailInfoMapper.getHasMailInvoiceListImport(reqBO);
        reqBO.setInvoceNameLike(null);
        ArrayList<PurchaseNoListVO> mails = new ArrayList<PurchaseNoListVO>();
        String mailTicketNo = null;
        ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            PurchaseNoListVO mail;
            InvoiceForMailVO firstInvoice;
            InvoiceForMailVO invoice = invoiceList.get(i);
            if (mailTicketNo == null || mailTicketNo.equals(invoice.getMailTicketNo())) {
                invoices.add(invoice);
            } else {
                if (!invoices.isEmpty()) {
                    firstInvoice = (InvoiceForMailVO)invoices.get(0);
                    mail = new PurchaseNoListVO();
                    BeanUtils.copyProperties((Object)firstInvoice, (Object)mail);
                    mails.add(mail);
                    mail.setIsImport("1");
                    mail.setDetailAddress(mail.getAddress());
                    mail.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(mail.getJdAssignStatus())));
                    mail.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(mail.getMailStatus())));
                    mail.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                    mail.setCount(Integer.valueOf(invoices.size()));
                    mail.setInvoiceForMailList(invoices);
                }
                invoices = new ArrayList();
                invoices.add(invoice);
            }
            if (i == invoiceList.size() - 1 && !invoices.isEmpty()) {
                firstInvoice = (InvoiceForMailVO)invoices.get(0);
                mail = new PurchaseNoListVO();
                BeanUtils.copyProperties((Object)firstInvoice, (Object)mail);
                mails.add(mail);
                mail.setIsImport("1");
                mail.setDetailAddress(mail.getAddress());
                mail.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(mail.getJdAssignStatus())));
                mail.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(mail.getMailStatus())));
                mail.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                mail.setCount(Integer.valueOf(invoices.size()));
                mail.setInvoiceForMailList(invoices);
            }
            mailTicketNo = invoice.getMailTicketNo();
        }
        QueryBillApplyForMailRspBO rspBO = new QueryBillApplyForMailRspBO();
        rspBO.setRows(mails);
        rspBO.setRecordsTotal(Integer.valueOf(mails.size()));
        rspBO.setTotal(Integer.valueOf(1));
        rspBO.setPageNo(Integer.valueOf(1));
        return rspBO;
    }
}

