/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQueryNotificationSplitResultService;
import com.tydic.pfscext.api.busi.bo.BusiNotificationExReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationNoSplitGroupBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationOrderGroupBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationPurchaseUnitGroupBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationSplitGroupRspBO;
import com.tydic.pfscext.api.busi.vo.OrderInfoVO;
import com.tydic.pfscext.api.busi.vo.OrderItemVO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.dao.vo.QueryReconcilitionOrderVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BusiNotificationSplitService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQueryNotificationSplitResultService"})
public class BusiQueryNotificationSplitResultServiceImpl
implements BusiQueryNotificationSplitResultService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQueryNotificationSplitResultServiceImpl.class);
    private static final String SELECT_ALL_YES = "Y";
    private static final String SELECT_ALL_NO = "N";
    private static final String GROUPWAY_NOSPLIT = "noSplitGroup";
    private static final String GROUPWAY_PURUNIT = "purchaseUnitGroup";
    private static final String GROUPWAY_ORDER = "orderGroup";
    private static final String MAX_ORDER_AMT = "500";
    private static final Integer MAX_ORDER_NUM = 300;
    private PayItemInfoMapper payItemInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private OrganizationInfoService organizationInfoService;
    private BusiNotificationSplitService busiNotificationSplitService;

    @Autowired
    public BusiQueryNotificationSplitResultServiceImpl(PayItemInfoMapper payItemInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, OrganizationInfoService organizationInfoService, BusiNotificationSplitService busiNotificationSplitService) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.busiNotificationSplitService = busiNotificationSplitService;
    }

    @PostMapping(value={"querySplitResult"})
    public BusiNotificationSplitGroupRspBO querySplitResult(@RequestBody BusiNotificationExReqBO busiNotificationExReqBO) {
        String groupWay;
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u7968\u901a\u77e5\u62c6\u5206\u7ed3\u679c\u67e5\u8be2\u5165\u53c2:" + busiNotificationExReqBO);
        }
        if (null == busiNotificationExReqBO.getMaxOrderNumber() || busiNotificationExReqBO.getMaxOrderNumber() <= 0) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u8ba2\u5355\u6570[maxOrderNumber]\u4e0d\u6b63\u786e");
        }
        if (null == busiNotificationExReqBO.getMaxOrderAmt()) {
            throw new PfscExtBusinessException("0001", "\u5355\u5f20\u901a\u77e5\u6700\u5927\u91d1\u989d\u6570[maxOrderAmt]\u4e0d\u6b63\u786e");
        }
        String busiModel = null;
        busiModel = "0".equals(busiNotificationExReqBO.getIsProfessionalOrgExt()) ? BusiModel.TRADE_MODEL.getCode() : BusiModel.MATCH_UP_MODEL.getCode();
        List<Object> orderInfos = new LinkedList();
        if (null != busiNotificationExReqBO.getVersionNo()) {
            QueryReconcilitionOrderVO queryReconcilitionOrderVO = new QueryReconcilitionOrderVO();
            queryReconcilitionOrderVO.setVersionNo(busiNotificationExReqBO.getVersionNo());
            queryReconcilitionOrderVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            queryReconcilitionOrderVO.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            queryReconcilitionOrderVO.setOrderBy("orderDate asc");
            payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListByReconcilition(queryReconcilitionOrderVO);
            if (CollectionUtils.isEmpty(payPurchaseOrderInfoPOs)) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
            }
            orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            groupWay = busiNotificationExReqBO.getGroupWay();
        } else {
            if (null == busiNotificationExReqBO.getSelectAllFlag()) {
                throw new PfscExtBusinessException("0001", "\u662f\u5426\u5168\u9009\u6807\u8bc6[selectAllFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getOrderDateEnd()) {
                throw new PfscExtBusinessException("0001", "\u7ed3\u675f\u65e5\u671f[orderDateEnd]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getCompanyId()) {
                throw new PfscExtBusinessException("0001", "Session\u4e13\u4e1a\u516c\u53f8\u673a\u6784ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == busiNotificationExReqBO.getGroupWay()) {
                throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f[groupWay]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            groupWay = busiNotificationExReqBO.getGroupWay();
            if (!(GROUPWAY_NOSPLIT.equals(groupWay) || GROUPWAY_PURUNIT.equals(groupWay) || GROUPWAY_ORDER.equals(groupWay))) {
                throw new PfscExtBusinessException("0001", "\u5206\u7ec4\u65b9\u5f0f\u4e0d\u6b63\u786e");
            }
            if (!SELECT_ALL_YES.equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag()) && !SELECT_ALL_NO.equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5168\u9009\u6807\u8bc6[selectAllFlag]\u53ea\u80fd\u8f93\u5165Y\u6216N");
            }
            if (SELECT_ALL_YES.equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                if (null == busiNotificationExReqBO.getSupplierNo()) {
                    throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u7f16\u53f7[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                PayPurchaseOrderInfoVO payPurchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                payPurchaseOrderInfoVO.setSource(busiNotificationExReqBO.getSource());
                if ("0".equals(busiNotificationExReqBO.getIsProfessionalOrgExt())) {
                    payPurchaseOrderInfoVO.setOperUnitNo(busiNotificationExReqBO.getCompanyId());
                    payPurchaseOrderInfoVO.setPurchaseNo(busiNotificationExReqBO.getPurchaseNo());
                } else {
                    payPurchaseOrderInfoVO.setPurchaseNo(busiNotificationExReqBO.getCompanyId());
                }
                payPurchaseOrderInfoVO.setPurchaseOrderCode(busiNotificationExReqBO.getPurchaseOrderCode());
                payPurchaseOrderInfoVO.setExtOrderId(busiNotificationExReqBO.getExtOrderId());
                payPurchaseOrderInfoVO.setSupplierNo(busiNotificationExReqBO.getSupplierNo());
                payPurchaseOrderInfoVO.setOrderDateStart(busiNotificationExReqBO.getOrderDateStart());
                payPurchaseOrderInfoVO.setOrderDateEnd(busiNotificationExReqBO.getOrderDateEnd());
                payPurchaseOrderInfoVO.setRecvDateStart(busiNotificationExReqBO.getRecvDateStart());
                payPurchaseOrderInfoVO.setRecvDateEnd(busiNotificationExReqBO.getRecvDateEnd());
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(busiNotificationExReqBO.getSource())) {
                    payPurchaseOrderInfoVO.setReconcilitionStatus(busiNotificationExReqBO.getReconcilitionStatus());
                }
                if (null != busiNotificationExReqBO.getMinPayableAmt() && !"".equals(busiNotificationExReqBO.getMinPayableAmt())) {
                    payPurchaseOrderInfoVO.setPayAmtStart(new BigDecimal(busiNotificationExReqBO.getMinPayableAmt()));
                }
                if (null != busiNotificationExReqBO.getMaxPayableAmt() && !"".equals(busiNotificationExReqBO.getMaxPayableAmt())) {
                    payPurchaseOrderInfoVO.setPayAmtEnd(new BigDecimal(busiNotificationExReqBO.getMaxPayableAmt()));
                }
                payPurchaseOrderInfoVO.setOrderBy("orderDate asc");
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(busiNotificationExReqBO.getSource())) {
                    payPurchaseOrderInfoVO.setPurchaseSaleType(busiNotificationExReqBO.getPurchaseSaleType());
                }
                payPurchaseOrderInfoVO.setBusiModel(busiModel);
                payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListExt(payPurchaseOrderInfoVO);
                if (payPurchaseOrderInfoPOs.isEmpty()) {
                    throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u5e94\u5f85\u5f00\u7968\u7ed3\u679c\u67e5\u8be2\u4e3a\u7a7a");
                }
                orderInfos = this.moveOrderInfosToVO(payPurchaseOrderInfoPOs);
            } else if (SELECT_ALL_NO.equalsIgnoreCase(busiNotificationExReqBO.getSelectAllFlag())) {
                if (null == busiNotificationExReqBO.getOrderInfos()) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u8ba2\u5355\u5217\u8868\u4e0d\u5f97\u4e3a\u7a7a");
                }
                orderInfos = busiNotificationExReqBO.getOrderInfos();
            }
        }
        if (CollectionUtils.isEmpty(orderInfos)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        Integer maxOrderNumber = busiNotificationExReqBO.getMaxOrderNumber();
        BigDecimal maxOrderAmt = new BigDecimal(busiNotificationExReqBO.getMaxOrderAmt());
        if (maxOrderNumber > MAX_ORDER_NUM) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u8ba2\u5355\u6570\u91cf\u4e3a300\u6761");
        }
        if (maxOrderAmt.compareTo(new BigDecimal(MAX_ORDER_AMT)) > 0) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4e00\u5f20\u5f00\u7968\u901a\u77e5\u5355\u6700\u5927\u5141\u8bb8\u5f00\u7968\u91d1\u989d\u4e3a500\u4e07\u5143");
        }
        BusiNotificationSplitGroupRspBO busiNotificationSplitGroupRspBO = new BusiNotificationSplitGroupRspBO();
        switch (groupWay) {
            case "noSplitGroup": {
                LinkedList<BusiNotificationNoSplitGroupBO> noSplitGroupBoList = new LinkedList<BusiNotificationNoSplitGroupBO>();
                List<List<OrderInfoVO>> orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, GROUPWAY_NOSPLIT, maxOrderAmt);
                for (List<OrderInfoVO> list : orderInfosList) {
                    BusiNotificationNoSplitGroupBO busiNotificationNoSplitGroupBo = new BusiNotificationNoSplitGroupBO();
                    HashSet<Long> purchaseUnitSet = new HashSet<Long>();
                    BigDecimal sumAmt = BigDecimal.ZERO;
                    for (OrderInfoVO orderInfoVO : list) {
                        sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
                        purchaseUnitSet.add(orderInfoVO.getPurchaseNo());
                    }
                    busiNotificationNoSplitGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(list.get(0).getSupplierNo()));
                    busiNotificationNoSplitGroupBo.setPurchaseUnitCount(Integer.valueOf(purchaseUnitSet.size()));
                    busiNotificationNoSplitGroupBo.setOrderCount(Integer.valueOf(list.size()));
                    busiNotificationNoSplitGroupBo.setOrderAmt(sumAmt);
                    noSplitGroupBoList.add(busiNotificationNoSplitGroupBo);
                }
                busiNotificationSplitGroupRspBO.setNoSplitGroupBoList(noSplitGroupBoList);
                busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(noSplitGroupBoList.size()));
                break;
            }
            case "purchaseUnitGroup": {
                LinkedList<BusiNotificationPurchaseUnitGroupBO> purchaseUnitGroupBoList = new LinkedList<BusiNotificationPurchaseUnitGroupBO>();
                List<List<OrderInfoVO>> orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, maxOrderNumber, GROUPWAY_PURUNIT, maxOrderAmt);
                for (List<OrderInfoVO> list : orderInfosList) {
                    BusiNotificationPurchaseUnitGroupBO busiNotificationPurchaseUnitGroupBo = new BusiNotificationPurchaseUnitGroupBO();
                    busiNotificationPurchaseUnitGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(list.get(0).getSupplierNo()));
                    busiNotificationPurchaseUnitGroupBo.setPurchaseUnitName(this.organizationInfoService.queryProjectName(list.get(0).getPurchaseProjectId()).getAccountName());
                    busiNotificationPurchaseUnitGroupBo.setOrderCount(Integer.valueOf(list.size()));
                    BigDecimal sumAmt = BigDecimal.ZERO;
                    for (OrderInfoVO orderInfoVO : list) {
                        sumAmt = sumAmt.add(orderInfoVO.getOrderAmt());
                    }
                    busiNotificationPurchaseUnitGroupBo.setOrderAmt(sumAmt);
                    purchaseUnitGroupBoList.add(busiNotificationPurchaseUnitGroupBo);
                }
                busiNotificationSplitGroupRspBO.setPurchaseUnitGroupBoList(purchaseUnitGroupBoList);
                busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(purchaseUnitGroupBoList.size()));
                break;
            }
            case "orderGroup": {
                LinkedList<BusiNotificationOrderGroupBO> orderGroupBoList = new LinkedList<BusiNotificationOrderGroupBO>();
                List<List<OrderInfoVO>> orderInfosList = this.busiNotificationSplitService.getSplitResult(orderInfos, null, GROUPWAY_ORDER, maxOrderAmt);
                for (List<OrderInfoVO> list : orderInfosList) {
                    BusiNotificationOrderGroupBO busiNotificationOrderGroupBo = new BusiNotificationOrderGroupBO();
                    busiNotificationOrderGroupBo.setSupplierName(this.organizationInfoService.querySupplierName(list.get(0).getSupplierNo()));
                    busiNotificationOrderGroupBo.setPurchaseUnitName(this.organizationInfoService.queryOrgName(list.get(0).getPurchaseNo()));
                    busiNotificationOrderGroupBo.setPurchaseOrderCode(list.get(0).getPurchaseOrderCode());
                    busiNotificationOrderGroupBo.setOrderAmt(list.get(0).getOrderAmt());
                    orderGroupBoList.add(busiNotificationOrderGroupBo);
                }
                busiNotificationSplitGroupRspBO.setOrderGroupBoList(orderGroupBoList);
                busiNotificationSplitGroupRspBO.setOrderCount(Integer.valueOf(orderGroupBoList.size()));
                break;
            }
        }
        busiNotificationSplitGroupRspBO.setRespCode("0000");
        busiNotificationSplitGroupRspBO.setRespDesc("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u62c6\u5206\u7ed3\u679c\u6210\u529f");
        return busiNotificationSplitGroupRspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        if (!CollectionUtils.isEmpty(orderInfos)) {
            for (PayPurchaseOrderInfo singleInfo : orderInfos) {
                OrderInfoVO singleVO = new OrderInfoVO();
                singleVO.setConfirmDate(singleInfo.getRecvDate());
                singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
                singleVO.setLastConfirmDate(singleInfo.getRecvDate());
                singleVO.setOrderAmt(singleInfo.getOrderAmt());
                singleVO.setOrderCreateDate(singleInfo.getOrderDate());
                singleVO.setOrderCreator(singleInfo.getPurchaserName());
                singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
                singleVO.setExtOrderId(singleInfo.getExtOrderId());
                singleVO.setOrderStatus(singleInfo.getOrderStatus());
                singleVO.setOrderType(singleInfo.getOrderType());
                singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
                singleVO.setPurchaseProjectId(singleInfo.getPurchaseProjectId());
                singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
                singleVO.setSupplierNo(singleInfo.getSupplierNo());
                singleVO.setSource(singleInfo.getSource());
                PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
                payItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
                payItemInfoVO.setInspectionId(singleInfo.getInspectionId());
                List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectBy(payItemInfoVO);
                if (CollectionUtils.isEmpty(itemInfos)) {
                    throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getPurchaseOrderCode() + "\u6ca1\u6709\u5546\u54c1\u660e\u7ec6");
                }
                LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
                for (PayItemInfo itemInfo : itemInfos) {
                    OrderItemVO vo = new OrderItemVO();
                    vo.setItemName(itemInfo.getItemName());
                    vo.setSpec(itemInfo.getSpec());
                    vo.setModel(itemInfo.getModel());
                    vo.setUnit(itemInfo.getUnitName());
                    vo.setUnitId(itemInfo.getUnitId());
                    vo.setQuantity(itemInfo.getQuantity());
                    vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                    vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                    itemVOs.add(vo);
                }
                singleVO.setItemList(itemVOs);
                infos.add(singleVO);
            }
        }
        return infos;
    }
}

