/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.trade.impl;

import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailRspBO;
import com.tydic.pfscext.api.trade.QueryOverduePenaltyDetailsService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.ApproveResult;
import com.tydic.pfscext.enums.ApproveStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.trade.QueryOverduePenaltyDetailsService"})
public class QueryOverduePenaltyDetailsServiceImpl
implements QueryOverduePenaltyDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(QueryOverduePenaltyDetailsServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"queryDetails"})
    public QueryPayableDetailRspBO queryDetails(@RequestBody QueryPayableDetailReqBO querypayableDetailReqBO) {
        if (querypayableDetailReqBO.getPayableNos() == null || querypayableDetailReqBO.getPayableNos().size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayableDetailRspBO queryPayableDetailRspBO = new QueryPayableDetailRspBO();
        try {
            ArrayList<PayableDetailBO> payableDetailBOs = new ArrayList<PayableDetailBO>();
            PayableDetailVO payableDetailVO = new PayableDetailVO();
            BeanUtils.copyProperties((Object)querypayableDetailReqBO, (Object)payableDetailVO);
            List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailVO);
            if (payableDetailPOs != null && payableDetailPOs.size() > 0) {
                for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                    PayableDetailBO payableDetailBO = new PayableDetailBO();
                    BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
                    if (payableDetailPO.getPayableType() != null) {
                        payableDetailBO.setPayableTypeStr(PayableType.getInstance(payableDetailPO.getPayableType().toString()).getDescr());
                    }
                    if (payableDetailPO.getPayableStatus() != null) {
                        payableDetailBO.setPayableStatusStr(PayableStatus.getInstance(payableDetailPO.getPayableStatus()).getDescr());
                    }
                    if (payableDetailPO.getApproveStatus() != null) {
                        payableDetailBO.setApproveStatusStr(ApproveStatus.getInstance(payableDetailPO.getApproveStatus().toString()).getDescr());
                    }
                    if (payableDetailPO.getApproveResult() != null) {
                        payableDetailBO.setApproveResultStr(ApproveResult.getInstance(payableDetailPO.getApproveResult().toString()).getDescr());
                    }
                    payableDetailBOs.add(payableDetailBO);
                }
            }
            queryPayableDetailRspBO.setList(payableDetailBOs);
            queryPayableDetailRspBO.setRespCode("0000");
            queryPayableDetailRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u903e\u671f\u91d1\u989d\u8be6\u60c5\u670d\u52a1\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u903e\u671f\u91d1\u989d\u8be6\u60c5\u670d\u52a1\u67e5\u8be2\u5931\u8d25");
        }
        return queryPayableDetailRspBO;
    }

    @PostMapping(value={"calculateOverduePenalty"})
    public PfscExtRspBaseBO calculateOverduePenalty() {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.add(5, -1);
            String date = sd.format(calendar.getTime());
            List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectListByPaidDate(date);
            ArrayList purchaseNos = new ArrayList();
            ArrayList<String> notPayableNos = new ArrayList<String>();
            HashMap map = new HashMap();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                notPayableNos.add(payableDetailPO.getPayableNo());
            }
            if (notPayableNos.size() > 0) {
                this.payableDetailMapper.updateOverduePenalty(notPayableNos);
            }
            this.payableDetailMapper.updateOverduePenaltyByOverdue();
            pfscExtRspBaseBO.setRespCode("0000");
            pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97\u903e\u671f\u8fdd\u7ea6\u91d1\u91d1\u989d\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u8ba1\u7b97\u903e\u671f\u8fdd\u7ea6\u91d1\u91d1\u989d\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }
}

