/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.deal.AddBillApplyService;
import com.tydic.pfscext.api.deal.bo.CreateBillApplyReqBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceMailInfoBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.service.atom.BillSNService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.AddBillApplyService"})
public class AddBillApplyServiceImpl
implements AddBillApplyService {
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody CreateBillApplyReqBO reqBO) {
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        if (reqBO == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getPayOrderId() == null || "".equals(reqBO.getPayOrderId())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u7f34\u8d39\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Integer invoiceType = reqBO.getInvoiceType();
        if (null == invoiceType) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        SaleInvoiceInfoBO invoiceInfo = reqBO.getInvoiceInfoVO();
        if (invoiceInfo == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
            return rspBO;
        }
        String invoiceClasses = reqBO.getInvoiceClasses();
        if (!StringUtils.hasText((String)invoiceClasses)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u53d1\u7968\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        SaleInvoiceMailInfoBO mailAddrInfo = reqBO.getMailAddrInfo();
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) {
            if (mailAddrInfo == null) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
                return rspBO;
            }
            if (!StringUtils.hasText((String)mailAddrInfo.getReceiver())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.hasText((String)mailAddrInfo.getTel())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u6536\u4ef6\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.hasText((String)mailAddrInfo.getAddrDesc())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u6536\u4ef6\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
        } else if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
            if (!StringUtils.hasText((String)reqBO.getReceiveInvoicePhone())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u6536\u7968\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.hasText((String)reqBO.getReceiveInvoiceEmail())) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u6536\u7968\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
        }
        String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
        Long payOrderId = Long.valueOf(reqBO.getPayOrderId());
        PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(payOrderId);
        if (null == payOrderInfoPO) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u672a\u67e5\u5230\u6240\u52fe\u9009\u8ba2\u5355\u7684\u4fe1\u606f");
            return rspBO;
        }
        if (!PayOrderStatus.CONFIRMED.getCode().equals(payOrderInfoPO.getPayOrderStatus())) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u8bf7\u52fe\u9009\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u7f34\u8d39\u7684\u8ba2\u5355");
            return rspBO;
        }
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setSupplierNo(payOrderInfoPO.getSupplierId());
        billApplyInfo.setSupplierName(payOrderInfoPO.getSupplierName());
        billApplyInfo.setPayFeeType("2");
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        billApplyInfo.setUserId(reqBO.getUserId());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
        billApplyInfo.setInvoiceClasses(reqBO.getInvoiceClasses());
        billApplyInfo.setAmt(reqBO.getAmt());
        billApplyInfo.setInvoiceType(reqBO.getInvoiceType().toString());
        billApplyInfo.setInvoceName(invoiceInfo.getInvoceName());
        billApplyInfo.setTaxNo(invoiceInfo.getTaxNo());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getPhone());
        billApplyInfo.setBankName(invoiceInfo.getBankName());
        billApplyInfo.setBankAcctNo(invoiceInfo.getBankAcctNo());
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) {
            billApplyInfo.setName(mailAddrInfo.getReceiver());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown(mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        } else {
            billApplyInfo.setReceiveInvoicePhone(reqBO.getReceiveInvoicePhone());
            billApplyInfo.setReceiveInvoiceEmail(reqBO.getReceiveInvoiceEmail());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.ELECTRONIC_INVOICE.getCode());
        }
        this.billApplyInfoMapper.insert(billApplyInfo);
        PayOrderInfoPO po = new PayOrderInfoPO();
        po.setPayOrderId(payOrderId);
        po.setApplyNo(applyNo);
        po.setPayOrderStatus(PayOrderStatus.TO_BE_INVOICE.getCode());
        this.payOrderInfoMapper.updateByPrimaryKeySelective(po);
        return rspBO;
    }
}

