/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.StocksDetailMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.StocksDetail;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.StocksDetailVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OutstockInfoStatus;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService"})
public class BusiCreateOutstockInfoServiceImpl
implements BusiCreateOutstockInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiCreateOutstockInfoServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private AccountantEngineService accountantEngineService;

    @PostMapping(value={"addOutstockInfo"})
    public BusiCreateOutstockInfoRspBO addOutstockInfo(@RequestBody BusiCreateOutstockInfoReqBO reqBO) {
        BusiCreateOutstockInfoRspBO rspBO = new BusiCreateOutstockInfoRspBO();
        if (reqBO.getApplyNo() == null && !StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date outstockDate = new Date();
        String applyNo = reqBO.getApplyNo();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        String outstockNo = this.billSNService.getSnAsString(BillType.STOCK_OUT);
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal untaxAmt = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        log.error("saleInvoiceInfoList==============" + saleInvoiceInfoList);
        for (SaleInvoiceInfo invoice : saleInvoiceInfoList) {
            taxAmt = taxAmt.add(invoice.getTaxAmt());
            untaxAmt = untaxAmt.add(invoice.getUntaxAmt());
            amt = amt.add(invoice.getAmt());
            List<SaleInvoiceDetail> saleInvoiceDetaillist = this.saleInvoiceDetailMapper.selectByInvoiceNo(invoice.getInvoiceNo());
            log.error("saleInvoiceDetaillist==============" + saleInvoiceDetaillist);
            for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetaillist) {
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                saleItemInfoVO.setApplyNo(applyNo);
                saleItemInfoVO.setInspectionId(saleInvoiceDetail.getInspectionId());
                saleItemInfoVO.setItemNo(saleInvoiceDetail.getItemNo());
                saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
                log.error("\u7535\u5b50\u8d85\u5e02\u662f\u6309\u5546\u54c1\u6570\u91cf\u7ef4\u5ea6\u63d0\u4ea4\u5f00\u7968\u7684" + saleItemInfoVO);
                if (saleItemInfoVO == null) {
                    throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OutstockDetail outstockDetail = new OutstockDetail();
                BeanUtils.copyProperties((Object)saleItemInfoVO, (Object)outstockDetail);
                outstockDetail.setSeq(null);
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    outstockDetail.setQuantity(saleItemInfoVO.getQuantityApply());
                }
                outstockDetail.setAmount(saleInvoiceDetail.getAmount());
                outstockDetail.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
                outstockDetail.setTaxAmt(saleInvoiceDetail.getTaxAmt());
                outstockDetail.setOutstockNo(outstockNo);
                outstockDetail.setInvoiceNo(invoice.getInvoiceNo());
                outstockDetail.setInvoiceCode(invoice.getInvoiceCode());
                outstockDetail.setOutstockDate(outstockDate);
                this.outstockDetailMapper.insertSelective(outstockDetail);
                StocksDetail stocksDetail = this.stocksDetailMapper.selectBypurchaseUnitPriceSkuId(saleItemInfoVO.getSaleUnitPrice(), saleItemInfoVO.getSkuId());
                if (stocksDetail == null) {
                    log.error("\u8c03\u7528\u51fa\u5e93\u670d\u52a1\u5931\u8d25\u3002\u5e93\u5b58\u5546\u54c1[\u9a8c\u6536\u5355\u53f7=" + saleItemInfoVO.getInspectionId() + "\uff0c\u91c7\u8d2d\u5546\u54c1\u884c\u53f7=" + saleItemInfoVO.getPurchaseItemNo() + "]\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + reqBO);
                    throw new PfscExtBusinessException("0001", "\u8c03\u7528\u51fa\u5e93\u670d\u52a1\u5931\u8d25\u3002\u5e93\u5b58\u5546\u54c1[\u9a8c\u6536\u5355\u53f7=" + saleItemInfoVO.getInspectionId() + "\uff0c\u91c7\u8d2d\u5546\u54c1\u884c\u53f7=" + saleItemInfoVO.getPurchaseItemNo() + "]\u4e0d\u5b58\u5728\u3002");
                }
                StocksDetailVO stocksDetailVO = new StocksDetailVO();
                stocksDetailVO.setSeq(stocksDetail.getSeq());
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    stocksDetailVO.setSaleQuantity(saleItemInfoVO.getQuantityApply());
                } else {
                    stocksDetailVO.setSaleQuantity(saleItemInfoVO.getQuantity());
                }
                this.stocksDetailMapper.updateRemainQuantity(stocksDetailVO);
            }
        }
        OutstockInfo outstockInfo = new OutstockInfo();
        outstockInfo.setOutstockNo(outstockNo);
        outstockInfo.setOutstockDate(outstockDate);
        outstockInfo.setPurchaseNo(billApplyInfo.getPurchaseNo());
        outstockInfo.setPurchaseProjectId(billApplyInfo.getPurchaseProjectId());
        outstockInfo.setSource(source);
        outstockInfo.setCompanyOrg(billApplyInfo.getOperUnitNo());
        outstockInfo.setUntaxAmt(untaxAmt);
        outstockInfo.setTaxAmt(taxAmt);
        outstockInfo.setAmount(amt);
        outstockInfo.setSupplierNo(billApplyInfo.getSupplierNo());
        outstockInfo.setApplyNo(applyNo);
        outstockInfo.setStatus(OutstockInfoStatus.NO_SUM.getCode());
        outstockInfo.setBranchCompany(billApplyInfo.getBranchCompany());
        this.outstockInfoMapper.insertSelective(outstockInfo);
        rspBO.setOutstockNo(outstockNo);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

