/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryEntryInfoDetailService;
import com.tydic.pfscext.api.busi.bo.BusiQryEntryInfoDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryEntryInfoDetailRspBO;
import com.tydic.pfscext.api.busi.bo.EntryInfoDetailBO;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryEntryInfoDetailService"})
public class BusiQryEntryInfoDetailServiceImpl
implements BusiQryEntryInfoDetailService {
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;

    @PostMapping(value={"qryEntryInfoDetail"})
    public BusiQryEntryInfoDetailRspBO qryEntryInfoDetail(@RequestBody BusiQryEntryInfoDetailReqBO reqBO) {
        if (reqBO.getSkuId() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u5e93\u5355\u67e5\u770b\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getPurchaseUnitPrice() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u5e93\u5355\u67e5\u770b\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiQryEntryInfoDetailRspBO rspBO = new BusiQryEntryInfoDetailRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
        ArrayList<EntryInfoDetailBO> receiptInfoList = new ArrayList<EntryInfoDetailBO>();
        try {
            boolean flag = true;
            BeanUtils.copyProperties((Object)reqBO, (Object)receiptInfoPO);
            List<ReceiptInfoPO> receiptInfoBOS = this.receiptInfoMapper.getListByCon(receiptInfoPO, (Page<Map<String, Object>>)page, "t.ENTRY_DATE");
            if (!CollectionUtils.isEmpty(receiptInfoBOS)) {
                for (ReceiptInfoPO bo : receiptInfoBOS) {
                    flag = true;
                    for (EntryInfoDetailBO detailBO : receiptInfoList) {
                        if (detailBO.getSkuId().longValue() != bo.getSkuId().longValue() || detailBO.getPurchaseUnitPrice().compareTo(bo.getPurchaseUnitPrice()) != 0 || !bo.getEntryNo().equals(detailBO.getEntryNo())) continue;
                        detailBO.getQuantity().add(bo.getQuantity());
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    EntryInfoDetailBO entryInfoDetailBO = new EntryInfoDetailBO();
                    BeanUtils.copyProperties((Object)bo, (Object)entryInfoDetailBO);
                    receiptInfoList.add(entryInfoDetailBO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5165\u5e93\u5355\u67e5\u8be2" + e.getMessage());
        }
        rspBO.setRows(receiptInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

