/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryOutstockInfoListService;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockInfoListReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockInfoListRspBO;
import com.tydic.pfscext.api.busi.bo.QryOutstockInfo;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.vo.QueryOutstockInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OutstockInfoStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryOutstockInfoListService"})
public class BusiQryOutstockInfoListServiceImpl
implements BusiQryOutstockInfoListService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryOutstockInfoListServiceImpl.class);
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"qryOutstockInfoList"})
    public BusiQryOutstockInfoListRspBO qryOutstockInfoList(@RequestBody BusiQryOutstockInfoListReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getSource())) {
            throw new PfscExtBusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = "t.OUTSTOCK_NO DESC";
        BusiQryOutstockInfoListRspBO rspPageBO = new BusiQryOutstockInfoListRspBO();
        QueryOutstockInfoVO queryOutstockInfoVO = new QueryOutstockInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryOutstockInfoVO);
        queryOutstockInfoVO.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<OutstockInfo> returnOutstockList = this.outstockInfoMapper.getOutStockInfoList(queryOutstockInfoVO, (Page<Map<String, Object>>)page);
        if (null == returnOutstockList || returnOutstockList.isEmpty()) {
            return rspPageBO;
        }
        ArrayList<QryOutstockInfo> outstockVOList = new ArrayList<QryOutstockInfo>();
        for (OutstockInfo outstockInfoPO : returnOutstockList) {
            QryOutstockInfo outstockInfoVO = new QryOutstockInfo();
            BeanUtils.copyProperties((Object)outstockInfoPO, (Object)outstockInfoVO);
            String purchaseName = this.organizationInfoService.queryOrgName(outstockInfoPO.getPurchaseNo());
            outstockInfoVO.setPurchaseName(purchaseName);
            String statusDesc = this.enumsService.getDescr(OutstockInfoStatus.getInstance(outstockInfoPO.getStatus()));
            outstockInfoVO.setStatusStr(statusDesc);
            String sourceDescr = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockInfoPO.getSource()));
            outstockInfoVO.setSourcStr(sourceDescr);
            outstockVOList.add(outstockInfoVO);
        }
        rspPageBO.setRows(outstockVOList);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

