/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.logistics.api.UlcOrderTrackQueryAbilityService;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityRspBo;
import com.tydic.logistics.common.general.UlcOrderTraceInfoDataBo;
import com.tydic.pfscext.api.busi.QueryBillApplyForMailService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceDetailRspBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceReqBO;
import com.tydic.pfscext.api.busi.bo.QueryExpressTraceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiApplyMailVO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.base.PfscExtReqPageBaseBO;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.enums.InvoiceMailSentStatusCustom;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.JDAssignStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiEMSExpressService;
import com.tydic.pfscext.external.api.BusiJdExpressService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.JdExpressTokenService;
import com.tydic.pfscext.utils.BeanUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryBillApplyForMailService"})
public class QueryBillApplyForMailServiceImpl
implements QueryBillApplyForMailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryBillApplyForMailServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BusiEMSExpressService busiEMSExpressService;
    @Autowired
    private UlcOrderTrackQueryAbilityService ulcOrderTrackQueryAbilityService;

    @PostMapping(value={"queryInvoiceForMail"})
    public QueryBillApplyForMailRspBO queryInvoiceForMail(@RequestBody QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = FscStringUtils.obtainOrderBy((PfscExtReqPageBaseBO)reqBO, "d_bill_apply_info c", null);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        List<PurchaseNoListVO> purchaseNoListVOs = this.saleInvoiceMailInfoMapper.queryToMailListPage(reqBO, (Page<Map<String, Object>>)page, orderBy);
        reqBO.setInvoceNameLike(null);
        reqBO.setInvoceName(null);
        reqBO.setReceiverLike(null);
        reqBO.setReceiver(null);
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        reqBO.setKeyFields(keyFields);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(purchaseNoListVO.getInvoceName());
            keyField.setName(purchaseNoListVO.getName());
        }
        orderBy = " a.INVOICE_NO asc";
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(reqBO, orderBy);
        for (PurchaseNoListVO purchaseNoListVO : purchaseNoListVOs) {
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (!purchaseNoListVO.getInvoceName().equals(invoice.getInvoceName()) || !purchaseNoListVO.getName().equals(invoice.getName())) continue;
                invoices.add(invoice);
                iterator.remove();
            }
            if (!invoices.isEmpty()) {
                InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
                purchaseNoListVO.setMobile(firstInvoice.getMobile());
                purchaseNoListVO.setMobile(firstInvoice.getMobile());
                purchaseNoListVO.setPurchaseName(firstInvoice.getPurchaseName());
                purchaseNoListVO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(firstInvoice.getInvoiceType()))));
                purchaseNoListVO.setDetailAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
                purchaseNoListVO.setAddress(QueryBillApplyForMailServiceImpl.getDetailAddress(firstInvoice));
                purchaseNoListVO.setReceiver(firstInvoice.getName());
            }
            purchaseNoListVO.setCount(Integer.valueOf(invoices.size()));
            purchaseNoListVO.setInvoiceForMailList(invoices);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    @PostMapping(value={"queryInvoiceSent"})
    public QueryBillApplyForMailRspBO queryInvoiceSent(@RequestBody QueryBillApplyForMailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5df2\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        QueryBillApplyForMailRspBO rspPageBO = new QueryBillApplyForMailRspBO();
        String orderBy = StringUtils.hasText((String)reqBO.getOrderBy()) ? reqBO.getOrderBy() : " b.MAIL_TICKET_NO asc";
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        reqBO.setInvoceNameLike(reqBO.getInvoceName());
        reqBO.setInvoceName(null);
        List<SaleInvoiceMailInfo> mails = this.saleInvoiceMailInfoMapper.queryMailedListPage(reqBO, InvoiceMailSentStatusCustom.DONE.getCode(), (Page<Map<String, Object>>)page, orderBy);
        QueryBillApplyForMailReqBO reqBO2 = new QueryBillApplyForMailReqBO();
        reqBO2.setOrderBy(" a.MAIL_TICKET_NO asc,a.ORDER_ID asc");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<PurchaseNoListVO> purchaseNoListVOs = new ArrayList<PurchaseNoListVO>();
        for (SaleInvoiceMailInfo mail : mails) {
            PurchaseNoListVO vo = new PurchaseNoListVO();
            org.springframework.beans.BeanUtils.copyProperties((Object)mail, (Object)vo);
            purchaseNoListVOs.add(vo);
            reqBO2.setExpressNo(mail.getMailTicketNo());
            List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.getHasMailInvoiceList(reqBO2);
            for (InvoiceForMailVO invoiceForMailVO : invoiceForMailVOs) {
                invoiceForMailVO.setInvoiceDateString(dateFormat.format(invoiceForMailVO.getInvoiceDate()));
            }
            if (invoiceForMailVOs != null && invoiceForMailVOs.size() > 0) {
                vo.setPurchaseName(invoiceForMailVOs.get(0).getPurchaseName());
            }
            vo.setName(vo.getReceiver());
            vo.setMobile(vo.getTel());
            vo.setDetailAddress(vo.getAddress());
            vo.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(vo.getJdAssignStatus())));
            vo.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(vo.getMailStatus())));
            vo.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(mail.getInvoiceType()))));
            vo.setCreateDateString(dateFormat.format(vo.getCreateDate()));
            vo.setCount(Integer.valueOf(invoiceForMailVOs.size()));
            vo.setInvoiceForMailList(invoiceForMailVOs);
        }
        rspPageBO.setRows(purchaseNoListVOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    @PostMapping(value={"queryExpressTrace"})
    public QueryExpressTraceRspBO queryExpressTrace(@RequestBody QueryExpressTraceReqBO reqBO) {
        List<SaleInvoiceMailInfo> listForRecieverInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u7269\u6d41\u4fe1\u606f\u670d\u52a1 \u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u4e13\u4e1a\u516c\u53f8[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getLogisticsCenterId() == null) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u90ae\u5bc4\u8be6\u60c5-\u7269\u6d41\u4e2d\u5fc3id[LogisticsCenterId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryExpressTraceRspBO rspBO = new QueryExpressTraceRspBO();
        ArrayList<QueryExpressTraceDetailRspBO> rows = new ArrayList<QueryExpressTraceDetailRspBO>();
        UlcOrderTrackQueryAbilityReqBo ulcOrderTrackQueryAbilityReqBo = new UlcOrderTrackQueryAbilityReqBo();
        ulcOrderTrackQueryAbilityReqBo.setOutLogisticsOrderId(reqBO.getLogisticsCenterId());
        UlcOrderTrackQueryAbilityRspBo ulcOrderTrackQueryAbilityRspBo = this.ulcOrderTrackQueryAbilityService.dealUlcOrderTrackQuery(ulcOrderTrackQueryAbilityReqBo);
        if (ulcOrderTrackQueryAbilityRspBo != null && ulcOrderTrackQueryAbilityRspBo.getTraceList() != null) {
            for (UlcOrderTraceInfoDataBo ulcOrderTraceInfoDataBo : ulcOrderTrackQueryAbilityRspBo.getTraceList()) {
                QueryExpressTraceDetailRspBO queryExpressTraceDetailRspBO = new QueryExpressTraceDetailRspBO();
                if (ulcOrderTraceInfoDataBo.getStatusTime() != null) {
                    queryExpressTraceDetailRspBO.setOpeTime(sd.format(ulcOrderTraceInfoDataBo.getStatusTime()));
                }
                queryExpressTraceDetailRspBO.setOpeTitle(ulcOrderTraceInfoDataBo.getSignDesc() + "-" + ulcOrderTraceInfoDataBo.getStatusDesc());
                rows.add(queryExpressTraceDetailRspBO);
            }
            rspBO.setRows(rows);
        }
        if (!CollectionUtils.isEmpty(listForRecieverInfo = this.saleInvoiceMailInfoMapper.selectByExpressNo(reqBO.getExpressNo()))) {
            SaleInvoiceMailInfo firstRecieverInfo = listForRecieverInfo.get(0);
            BeanUtils.null2DefaultValue(firstRecieverInfo);
            rspBO.setRecieverName(firstRecieverInfo.getReceiver());
            rspBO.setRecieverTel(firstRecieverInfo.getTel());
            rspBO.setRecieverAddr(firstRecieverInfo.getAddress());
        }
        return rspBO;
    }

    static String getDetailAddress(InvoiceForMailVO invoiceForMailVO) {
        String detailAddress = "";
        if (null != invoiceForMailVO) {
            if (StringUtils.hasText((String)invoiceForMailVO.getAddress())) {
                detailAddress = invoiceForMailVO.getAddress();
            } else {
                String province = FscStringUtils.valueOf(invoiceForMailVO.getProvince());
                String city = FscStringUtils.valueOf(invoiceForMailVO.getCity());
                String county = FscStringUtils.valueOf(invoiceForMailVO.getCounty());
                String town = FscStringUtils.valueOf(invoiceForMailVO.getTown());
                String addrDesc = FscStringUtils.valueOf(invoiceForMailVO.getAddrDesc());
                detailAddress = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            }
        }
        return detailAddress;
    }
}

