/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoItemReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoReqBO;
import com.tydic.pfscext.api.deal.BusiPushSaleOrderInfoForFrameService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleOrderPayStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BusiPushSaleOrderInfoForFrameService"})
public class BusiPushSaleOrderInfoForFrameServiceImpl
implements BusiPushSaleOrderInfoForFrameService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPushSaleOrderInfoForFrameServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Resource(name="frameOrderIdSeq")
    private OrderSequence frameOrderIdSeqSeqService;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiPushSaleOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiPushSaleOrderInfoOrderReqBO orderInfo = reqBO.getOrderInfo();
        if (orderInfo == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long purchaseOrderId = orderInfo.getPurchaseOrderId();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null || purchaseOrderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushSaleOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushSaleOrderInfoItemReqBO>(itemList.size() + 1);
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
                continue;
            }
            BusiPushSaleOrderInfoItemReqBO itemInMap = (BusiPushSaleOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
            itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
            itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
        }
        itemList = new ArrayList(itemMap.values());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setOrderId(orderId);
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setOrderId(orderId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
        if (saleOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u8ba2\u5355[\u8ba2\u5355\u53f7=" + orderId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u8ba2\u5355[\u8ba2\u5355\u5355\u53f7=" + orderId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
            }
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setOrderId(orderId);
            this.saleItemInfoMapper.deleteBy(saleItemInfo);
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setOrderId(orderId);
            this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
        }
        String source = orderInfo.getSource();
        saleOrderInfo = new SaleOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)saleOrderInfo);
        saleOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String supplierName = this.organizationInfoService.querySupplierName(saleOrderInfo.getSupplierNo());
        saleOrderInfo.setSupplierName(supplierName);
        String orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getPurchaseNo());
        saleOrderInfo.setPurchaseName(orgName);
        orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getOperUnitNo());
        saleOrderInfo.setOperUnitName(orgName);
        saleOrderInfo.setApplyNo(null);
        saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        saleOrderInfo.setPayStatus(SaleOrderPayStatus.PENDING.getCode());
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(saleOrderInfo.getPurchaseProjectId());
            saleOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (null != saleOrderInfo.getPayType()) {
            switch (saleOrderInfo.getPayType()) {
                case "0": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        saleOrderInfo.setIsPayFlag("0");
        Long inspectionID = 0L;
        try {
            inspectionID = this.frameOrderIdSeqSeqService.nextId();
            saleOrderInfo.setInspectionId(inspectionID);
            this.saleOrderInfoMapper.insert(saleOrderInfo);
        }
        catch (Exception e) {
            logger.error("\u9500\u552e\u8ba2\u5355\u6dfb\u52a0\u5931\u8d25:" + e.toString());
        }
        ArrayList<SaleItemInfo> saleItemInfoList = new ArrayList<SaleItemInfo>();
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)saleItemInfo);
            saleItemInfo.setOrderId(orderId);
            saleItemInfo.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
            saleItemInfo.setInspectionId(inspectionID);
            saleItemInfo.setPurchaseOrderId(purchaseOrderId);
            saleItemInfo.setApplyNo(null);
            saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                saleItemInfo.setUnitName("\u4e2a");
            }
            if (StringUtils.hasText((String)saleItemInfo.getSkuName()) && saleItemInfo.getSkuName().length() > 100) {
                saleItemInfo.setSkuName(saleItemInfo.getSkuName().substring(0, 100));
            }
            if (saleItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (StringUtils.hasText((String)itemInfo.getTaxId())) {
                try {
                    saleItemInfo.setTaxCatCode(Long.parseLong(itemInfo.getTaxId()));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25,\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a:" + itemInfo.getTaxId());
                }
            }
            if (null == saleItemInfo.getTaxRate()) {
                saleItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            }
            if (null != saleItemInfo.getSettleRate() && saleItemInfo.getSettleRate().intValue() == 0) {
                saleItemInfo.setSettleRate(null);
            }
            saleItemInfoList.add(saleItemInfo);
        }
        if (saleItemInfoList.isEmpty()) {
            logger.error("\u8ba2\u5355[\u8ba2\u5355\u53f7=" + orderId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355[\u8ba2\u5355\u53f7=" + orderId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.saleItemInfoMapper.insertBatch(saleItemInfoList);
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

