/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.activity.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.activity.QueryPaySaleOrderInfoYgflService;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.activity.QueryPaySaleOrderInfoYgflService"})
public class QueryPaySaleOrderInfoYgflServiceImpl
implements QueryPaySaleOrderInfoYgflService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPaySaleOrderInfoYgflServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5458\u5de5\u798f\u5229\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaseProjectId()) {
            throw new PfscExtBusinessException("18000", "\u8d26\u5957\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            try {
                order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u3010UmcQryEnterpriseAccountDetailAbilityService\u3011\u5f02\u5e38");
            }
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

