/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiBatchInvoiceVerifyService;
import com.tydic.pfscext.api.busi.BusiInvoiceVerifyService;
import com.tydic.pfscext.api.busi.bo.BusiBatchInvoiceVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiBatchInvoiceVerifyRspBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyReqBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiBatchInvoiceVerifyServiceImpl
implements BusiBatchInvoiceVerifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiBatchInvoiceVerifyServiceImpl.class);
    @Autowired(required=false)
    private BusiInvoiceVerifyService busiInvoiceVerifyService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    public BusiBatchInvoiceVerifyRspBO invoiceVerify(BusiBatchInvoiceVerifyReqBO reqBO) {
        int maxThreadSize;
        List notificationNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1\u5165\u53c2=" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(notificationNos = reqBO.getNotificationNos()))) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSignMode().toString())) {
            throw new PfscExtBusinessException("0001", "\u7b7e\u6536\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBO.getSignMode().toString())) {
            throw new PfscExtBusinessException("0001", "\u7b7e\u6536\u6807\u5fd7\u6709\u8bef");
        }
        int size = notificationNos.size();
        ExecutorService executorService = Executors.newFixedThreadPool(size > (maxThreadSize = this.enumsService.queryMaxThreadSize()) ? maxThreadSize : size);
        CountDownLatch latch = new CountDownLatch(size);
        for (String notificationNo : notificationNos) {
            BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (null == bill) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728!");
            }
            executorService.submit(new TaskRunnable(latch, notificationNo, reqBO.getSignMode(), bill.getOperNo(), bill.getUserId()));
        }
        try {
            latch.await(this.enumsService.queryMaxSleepTime(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        if (null != executorService) {
            executorService.shutdown();
        }
        BusiBatchInvoiceVerifyRspBO verifyRspBO = new BusiBatchInvoiceVerifyRspBO();
        verifyRspBO.setResultInfo("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u5b8c\u6210,\u8bf7\u786e\u8ba4\u7ed3\u679c");
        return verifyRspBO;
    }

    class TaskRunnable
    implements Runnable {
        private final CountDownLatch latch;
        private final String notificationNo;
        private final Integer signMode;
        private final Long companyId;
        private final Long userId;

        public TaskRunnable(CountDownLatch latch, String notificationNo, Integer signMode, Long companyId, Long userId) {
            this.latch = latch;
            this.notificationNo = notificationNo;
            this.signMode = signMode;
            this.companyId = companyId;
            this.userId = userId;
        }

        @Override
        public void run() {
            try {
                BusiInvoiceVerifyReqBO invoiceVerifyReqBO = new BusiInvoiceVerifyReqBO();
                invoiceVerifyReqBO.setSignMode(this.signMode);
                invoiceVerifyReqBO.setNotificationNo(this.notificationNo);
                invoiceVerifyReqBO.setCompanyId(this.companyId);
                invoiceVerifyReqBO.setUserId(this.userId);
                BusiBatchInvoiceVerifyServiceImpl.this.busiInvoiceVerifyService.invoiceVerify(invoiceVerifyReqBO);
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u7b7e\u6536\u51fa\u9519:" + e.getMessage());
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

