/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiForConfirmQryAdvanceRecService;
import com.tydic.pfscext.api.busi.bo.BusiForConfirmAdvanceRecQueryReqBO;
import com.tydic.pfscext.api.busi.bo.BusiForConfirmAdvanceRecQueryRspBO;
import com.tydic.pfscext.api.busi.bo.BusiForConfirmAdvanceRecQuerySubRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.dao.AdvanceReceiveExtMapper;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.bo.AdvanceReceiveExtBO;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.InquiryPayFeeType;
import com.tydic.pfscext.enums.InquiryPaymentStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.SubAccountService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiForConfirmQryAdvanceRecServiceImpl
implements BusiForConfirmQryAdvanceRecService {
    private static final Logger logger = LoggerFactory.getLogger(BusiForConfirmQryAdvanceRecServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private static ThreadLocal<BigDecimal> localSumPayMoney = new ThreadLocal();
    private static Date localMaxPayFinshTime = null;
    private boolean maxPayFinshTimeFlag = true;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;

    public BusiForConfirmAdvanceRecQueryRspBO queryBusiForConfirmAdvanceRecByPageList(BusiForConfirmAdvanceRecQueryReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u94f6\u884c\u6d41\u6c34\u4fe1\u606f\u5e76\u5339\u914d\u7f34\u8d39\u8ba2\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getPaymentStatus())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u9009\u62e9\u4ed8\u6b3e\u72b6\u6001");
        }
        this.maxPayFinshTimeFlag = true;
        localMaxPayFinshTime = null;
        localSumPayMoney = new ThreadLocal();
        AdvanceReceiveVO advanceQueryVO = new AdvanceReceiveVO();
        advanceQueryVO.setOrgId(reqBO.getCompanyId());
        advanceQueryVO.setSource(OrderSource.CONSULT_PRICE.getCode());
        Integer serviceType = 0;
        if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(reqBO.getPayFeeType())) {
            serviceType = SubAccountServiceType.PLATFORM_FEE.getCode();
        } else if (reqBO.getPayFeeTypeList().contains(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode()) || reqBO.getPayFeeTypeList().contains(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode())) {
            serviceType = SubAccountServiceType.SERVICE_FEE.getCode();
        }
        SubAcctInfoExt subAccInfoExt = this.subAccountService.getWithMainAccount(advanceQueryVO.getOrgId(), advanceQueryVO.getSource(), advanceQueryVO.getOrgId(), null, serviceType);
        if (subAccInfoExt == null) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u8be5\u673a\u6784\u5bf9\u5e94\u7684\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        BusiForConfirmAdvanceRecQueryRspBO rspPageBO = new BusiForConfirmAdvanceRecQueryRspBO();
        rspPageBO.setBalanceAmt(subAccInfoExt.getBalance());
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        String payConfigTransferAcctName = this.enumsService.queryLikeSupplierPayTransferAcctName();
        if (InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(reqBO.getPaymentStatus())) {
            advanceReceiveVO.setIncludeTransferAcctName(payConfigTransferAcctName);
            if (!StringUtils.isEmpty((Object)reqBO.getTransferAcctName())) {
                advanceReceiveVO.setTransferAcctName(reqBO.getTransferAcctName());
            }
        } else if (InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(reqBO.getPaymentStatus())) {
            advanceReceiveVO.setExcludeTransferAcctName(payConfigTransferAcctName);
            if (!StringUtils.isEmpty((Object)reqBO.getTransferAcctName())) {
                advanceReceiveVO.setTransferAcctName(reqBO.getTransferAcctName());
            }
        }
        advanceReceiveVO.setTranAmt(reqBO.getTranAmt());
        advanceReceiveVO.setPostDateBegin(reqBO.getPostDateBegin());
        advanceReceiveVO.setPostDateEnd(reqBO.getPostDateEnd());
        advanceReceiveVO.setPayOrderNoList(reqBO.getPayOrderNoList());
        advanceReceiveVO.setRecSubAcct(subAccInfoExt.getSubAcctNo());
        advanceReceiveVO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
        advanceReceiveVO.setOrderBy(" UNWRITEOFF_AMT desc, post_date desc ");
        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
        HashSet<String> paymentStatusSet = new HashSet<String>();
        paymentStatusSet.add(InquiryPaymentStatus.CHECK_SUCCEED.getCode());
        paymentStatusSet.add(InquiryPaymentStatus.OFFLINE_PAID.getCode());
        inquiryPayOrderExt.setPaymentStatusSet(paymentStatusSet);
        inquiryPayOrderExt.setPayOrderNoList(reqBO.getPayOrderNoList());
        inquiryPayOrderExt.setSortOrder(" PAY_FINSH_TIME DESC ");
        ArrayList<InquiryPayOrder> inquiryList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPayOrderNoList())) {
            inquiryList = this.inquiryPayOrderMapper.getInquiryOrderByPaymentStatusList(inquiryPayOrderExt);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<BusiForConfirmAdvanceRecQuerySubRspBO> result = new LinkedList<BusiForConfirmAdvanceRecQuerySubRspBO>();
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectByConditionsPageList(advanceReceiveVO, (Page<Map<String, Object>>)page);
        for (AdvanceReceive row : rows) {
            BusiForConfirmAdvanceRecQuerySubRspBO detail = new BusiForConfirmAdvanceRecQuerySubRspBO();
            detail.setMatchStatus(this.matchTransferAcctName(inquiryList, row));
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setRecOrgName(this.organizationInfoService.queryOrgName(row.getRecOrgId()));
            detail.setRecTypeName(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)subAccInfoExt.getSource())));
            detail.setStatusDescr(this.enumsService.getDescr(AdvanceReceiveStatus.getInstance(row.getStatus())));
            result.add(detail);
        }
        this.sortBySomeCodition(result, inquiryList, payConfigTransferAcctName, reqBO.getPaymentStatus());
        if (InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(reqBO.getPaymentStatus()) && null != reqBO.getPayFeeTypeList() && !reqBO.getPayFeeTypeList().isEmpty() && (reqBO.getPayFeeTypeList().contains(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode()) || reqBO.getPayFeeTypeList().contains(InquiryPayFeeType.PURCH_SERVICE_FEE.getCode()))) {
            LinkedList<AdvanceReceiveExtBO> advanceExtList = new LinkedList();
            AdvanceReceiveExtBO queryExtBO = new AdvanceReceiveExtBO();
            queryExtBO.setTransferAcctName(reqBO.getTransferAcctName());
            queryExtBO.setPostDateBegin(reqBO.getPostDateBegin());
            queryExtBO.setPostDateEnd(reqBO.getPostDateEnd());
            queryExtBO.setTranAmt(reqBO.getTranAmt());
            queryExtBO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            queryExtBO.setRecOrgId(reqBO.getCompanyId());
            queryExtBO.setSource(OrderSource.CONSULT_PRICE.getCode());
            advanceExtList = this.advanceReceiveExtMapper.selectByConditionsList(queryExtBO);
            List<BusiForConfirmAdvanceRecQuerySubRspBO> otherResult = this.specialSortBySomeCodition(advanceExtList, inquiryList);
            result.addAll(otherResult);
        }
        localSumPayMoney.remove();
        rspPageBO.setRows(result);
        rspPageBO.setRecordsTotal(Integer.valueOf(result.size()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages() == 0 ? 1 : page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo() == 0 ? 1 : page.getPageNo()));
        return rspPageBO;
    }

    private Integer matchTransferAcctName(List<InquiryPayOrder> inquiryList, AdvanceReceive advanceReceive) {
        if (StringUtils.isEmpty((Object)advanceReceive.getTransferAcctName())) {
            return 0;
        }
        BigDecimal payMoneySum = BigDecimal.ZERO;
        String payConfigTransferAcctName = this.enumsService.queryLikeSupplierPayTransferAcctName();
        Iterator<InquiryPayOrder> iter = inquiryList.iterator();
        while (iter.hasNext()) {
            String supplierName;
            InquiryPayOrder inquiryPayOrder = iter.next();
            payMoneySum = payMoneySum.add(inquiryPayOrder.getPayMoney());
            if (InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus())) {
                if (!StringUtils.hasText((String)payConfigTransferAcctName) || !advanceReceive.getTransferAcctName().contains(payConfigTransferAcctName) || !this.maxPayFinshTimeFlag || inquiryPayOrder.getPayFinshTime() == null) continue;
                this.maxPayFinshTimeFlag = false;
                localMaxPayFinshTime = inquiryPayOrder.getPayFinshTime();
                continue;
            }
            if (!InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) || !StringUtils.hasText((String)(supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId()))) || !supplierName.contains(advanceReceive.getTransferAcctName()) || advanceReceive.getUnWriteoffAmt().compareTo(inquiryPayOrder.getPayMoney()) != 0) continue;
            iter.remove();
            return 1;
        }
        localSumPayMoney.set(payMoneySum);
        return 0;
    }

    private void sortBySomeCodition(List<BusiForConfirmAdvanceRecQuerySubRspBO> result, List<InquiryPayOrder> inquiryList, String payConfigTransferAcctName, String paymentStatus) {
        boolean flag = false;
        if (localSumPayMoney.get() != null && localMaxPayFinshTime != null && InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(paymentStatus)) {
            BigDecimal unWriteoffAmt;
            for (BusiForConfirmAdvanceRecQuerySubRspBO querySubPspBO : result) {
                unWriteoffAmt = querySubPspBO.getUnWriteoffAmt();
                if (!payConfigTransferAcctName.contains(querySubPspBO.getTransferAcctName()) || querySubPspBO.getPostDate().compareTo(localMaxPayFinshTime) < 0) continue;
                if (localSumPayMoney.get().compareTo(unWriteoffAmt) < 0) {
                    flag = true;
                    continue;
                }
                if (localSumPayMoney.get().compareTo(unWriteoffAmt) != 0) continue;
                querySubPspBO.setMatchStatus(Integer.valueOf(1));
                inquiryList.clear();
                break;
            }
            if (flag && !CollectionUtils.isEmpty(inquiryList)) {
                for (BusiForConfirmAdvanceRecQuerySubRspBO querySubPspBO : result) {
                    unWriteoffAmt = querySubPspBO.getUnWriteoffAmt();
                    if (!payConfigTransferAcctName.contains(querySubPspBO.getTransferAcctName()) || querySubPspBO.getPostDate().compareTo(localMaxPayFinshTime) < 0 || localSumPayMoney.get().compareTo(unWriteoffAmt) >= 0) continue;
                    querySubPspBO.setMatchStatus(Integer.valueOf(1));
                    inquiryList.clear();
                    break;
                }
            }
        }
        BigDecimal unWriteoffAmtSum = BigDecimal.ZERO;
        BigDecimal payMoneyAmtTotal = BigDecimal.ZERO;
        boolean matchFlag = false;
        if (localSumPayMoney.get() != null && localMaxPayFinshTime != null && InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(paymentStatus)) {
            Iterator<InquiryPayOrder> iter = inquiryList.iterator();
            block2: while (iter.hasNext()) {
                InquiryPayOrder inquiryPayOrder = iter.next();
                boolean payMoneyFlag = true;
                for (BusiForConfirmAdvanceRecQuerySubRspBO subRspBO : result) {
                    if (StringUtils.isEmpty((Object)subRspBO.getTransferAcctName()) || !InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus()) || !StringUtils.hasText((String)payConfigTransferAcctName) || !subRspBO.getTransferAcctName().contains(payConfigTransferAcctName) || !new Integer(0).equals(subRspBO.getMatchStatus())) continue;
                    matchFlag = true;
                    if (payMoneyAmtTotal.compareTo(BigDecimal.ZERO) == 0) {
                        if (payMoneyFlag) {
                            payMoneyFlag = false;
                            payMoneyAmtTotal = payMoneyAmtTotal.add(inquiryPayOrder.getPayMoney());
                        }
                    } else if (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) <= 0) {
                        if (payMoneyFlag) {
                            payMoneyFlag = false;
                            payMoneyAmtTotal = payMoneyAmtTotal.add(inquiryPayOrder.getPayMoney());
                        }
                        if (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) <= 0) {
                            iter.remove();
                            continue block2;
                        }
                    }
                    if (subRspBO.getPostDate().compareTo(localMaxPayFinshTime) >= 0) {
                        if (payMoneyFlag) {
                            payMoneyFlag = false;
                            payMoneyAmtTotal = payMoneyAmtTotal.add(inquiryPayOrder.getPayMoney());
                        }
                        if (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) <= 0) {
                            iter.remove();
                            continue block2;
                        }
                        subRspBO.setMatchStatus(Integer.valueOf(1));
                        unWriteoffAmtSum = unWriteoffAmtSum.add(subRspBO.getUnWriteoffAmt());
                    }
                    if (payMoneyAmtTotal.compareTo(BigDecimal.ZERO) <= 0 || payMoneyAmtTotal.compareTo(unWriteoffAmtSum) > 0) continue;
                    iter.remove();
                    continue block2;
                }
            }
        }
        if (localSumPayMoney.get() != null && localSumPayMoney.get().compareTo(payMoneyAmtTotal) >= 0 && InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(paymentStatus) && (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) > 0 || !matchFlag)) {
            block4: for (int index = 0; index < inquiryList.size(); ++index) {
                InquiryPayOrder payOrder = inquiryList.get(index);
                if (!matchFlag && index == 0) {
                    payMoneyAmtTotal = payMoneyAmtTotal.add(payOrder.getPayMoney());
                }
                if (index != 0) {
                    payMoneyAmtTotal = payMoneyAmtTotal.add(payOrder.getPayMoney());
                }
                for (BusiForConfirmAdvanceRecQuerySubRspBO subRspBO : result) {
                    if (StringUtils.isEmpty((Object)subRspBO.getTransferAcctName()) || !InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(payOrder.getPaymentStatus()) || !StringUtils.hasText((String)payConfigTransferAcctName) || !subRspBO.getTransferAcctName().contains(payConfigTransferAcctName) || !new Integer(0).equals(subRspBO.getMatchStatus())) continue;
                    if (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) <= 0) continue block4;
                    unWriteoffAmtSum = unWriteoffAmtSum.add(subRspBO.getUnWriteoffAmt());
                    subRspBO.setMatchStatus(Integer.valueOf(1));
                    if (payMoneyAmtTotal.compareTo(unWriteoffAmtSum) > 0) continue;
                    continue block4;
                }
            }
        }
        if (InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(paymentStatus)) {
            int inquiryLength = inquiryList.size();
            HashSet<String> supplierSet = new HashSet<String>();
            for (int index = 0; index < inquiryList.size(); ++index) {
                InquiryPayOrder payBO = inquiryList.get(index);
                String supplierName = this.organizationInfoService.querySupplierName(payBO.getSupplierId());
                if (StringUtils.isEmpty((Object)supplierName) || !supplierSet.add(supplierName)) continue;
                for (BusiForConfirmAdvanceRecQuerySubRspBO querySubRspBO : result) {
                    if (!new Integer(0).equals(querySubRspBO.getMatchStatus()) || !supplierName.equals(querySubRspBO.getTransferAcctName())) continue;
                    querySubRspBO.setSupplierNameSort(Integer.valueOf(inquiryLength - index));
                }
            }
        }
        Collections.sort(result);
    }

    private List<BusiForConfirmAdvanceRecQuerySubRspBO> specialSortBySomeCodition(List<AdvanceReceiveExtBO> advanceExtList, List<InquiryPayOrder> inquiryList) {
        LinkedList<BusiForConfirmAdvanceRecQuerySubRspBO> otherResult = new LinkedList<BusiForConfirmAdvanceRecQuerySubRspBO>();
        for (AdvanceReceiveExtBO extBO : advanceExtList) {
            BusiForConfirmAdvanceRecQuerySubRspBO subRspBO = new BusiForConfirmAdvanceRecQuerySubRspBO();
            BeanUtils.copyProperties((Object)extBO, (Object)subRspBO);
            subRspBO.setMatchStatus(Integer.valueOf(0));
            subRspBO.setRecOrgName(this.organizationInfoService.queryOrgName(extBO.getRecOrgId()));
            subRspBO.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)extBO.getSource())));
            subRspBO.setStatusDescr(this.enumsService.getDescr(AdvanceReceiveStatus.getInstance(extBO.getStatus())));
            Iterator<InquiryPayOrder> iter = inquiryList.iterator();
            while (iter.hasNext()) {
                InquiryPayOrder inquiryPayOrder = iter.next();
                String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
                if (StringUtils.isEmpty((Object)supplierName) || !supplierName.contains(subRspBO.getTransferAcctName()) || subRspBO.getUnWriteoffAmt().compareTo(inquiryPayOrder.getPayMoney()) != 0) continue;
                subRspBO.setMatchStatus(Integer.valueOf(1));
                iter.remove();
                break;
            }
            otherResult.add(subRspBO);
        }
        HashSet<String> supplierSet = new HashSet<String>();
        int inquiryLength = inquiryList.size();
        for (int index = 0; index < inquiryLength; ++index) {
            InquiryPayOrder inquiryPayOrder = inquiryList.get(index);
            String supplierName = this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId());
            if (StringUtils.isEmpty((Object)supplierName) || !supplierSet.add(supplierName)) continue;
            for (BusiForConfirmAdvanceRecQuerySubRspBO subRspBO : otherResult) {
                if (subRspBO.getMatchStatus() != 0 || !supplierName.contains(subRspBO.getTransferAcctName())) continue;
                subRspBO.setSupplierNameSort(Integer.valueOf(inquiryLength - index));
            }
        }
        Collections.sort(otherResult);
        return otherResult;
    }
}

