/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiGetInvoiceService;
import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfscext.api.busi.vo.BusiGetInvoiceResultVO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.enums.InvoiceMailStatus;
import com.tydic.pfscext.enums.InvoiceStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataRspVO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemBO;
import com.tydic.pfscext.external.api.bo.BusiGetInvoiceItemListRspBO;
import com.tydic.pfscext.service.atom.PayInvoiceService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiGetInvoiceService"})
public class BusiGetInvoiceServiceImpl
implements BusiGetInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiGetInvoiceServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper notificationInfomapper;
    @Autowired
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private PayInvoiceService payInvoiceService;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    private boolean isBusy = false;

    @PostMapping(value={"isBusy"})
    public boolean isBusy() {
        return this.isBusy;
    }

    @PostMapping(value={"dealInvoice"})
    public BusiGetInvoiceServiceRspBO dealInvoice(@RequestBody BusiGetInvoiceServiceReqBO busiGetInvoiceServiceReqBO) {
        this.isBusy = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + busiGetInvoiceServiceReqBO.toString());
        }
        try {
            BusiGetInvoiceServiceRspBO busiGetInvoiceServiceRspBO = this.process();
            return busiGetInvoiceServiceRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiGetInvoiceServiceRspBO process() {
        BusiGetInvoiceServiceRspBO rspBO = new BusiGetInvoiceServiceRspBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        List<BillNotificationInfo> invoiceList = this.notificationInfomapper.selectList(billNotificationInfo);
        if (invoiceList.isEmpty()) {
            LOGGER.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a01(\u5df2\u63d0\u4ea4)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        for (BillNotificationInfo info : invoiceList) {
            String markId = info.getNotificationNo();
            String id = String.valueOf(info.getSupplierNo());
            dataMap.put(markId, id);
        }
        LOGGER.debug("\u9700\u8981\u8f6e\u8be2\u53d1\u7968\u8d44\u6599\u7684\u901a\u77e5\u5355,count=" + invoiceList.size() + ",dataMap=" + dataMap);
        BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
        getInvoiceDataReqBO.setIdMap(dataMap);
        List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
        if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
            LOGGER.debug("\u6ca1\u6709\u67e5\u8be2\u5230\u5f00\u7968\u6570\u636e\uff0c\u7a0b\u5e8f\u9000\u51fa");
            return rspBO;
        }
        ArrayList list = new ArrayList();
        rspBO.setResultList(list);
        return this.dealData(invoiceDataList, rspBO);
    }

    private BusiGetInvoiceServiceRspBO dealData(List<BusiGetInvoiceDataRspVO> invoiceDataList, BusiGetInvoiceServiceRspBO rspBO) {
        ArrayList<PayInvoiceDetail> payInvoiceDetails = new ArrayList<PayInvoiceDetail>();
        for (BusiGetInvoiceDataRspVO invoiceData : invoiceDataList) {
            try {
                BusiGetInvoiceResultVO resultVO = new BusiGetInvoiceResultVO();
                LOGGER.debug("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u7ed3\u679c:" + invoiceData.getNotificationNo() + "," + invoiceData.getResultCode() + "," + invoiceData.getResultMsg() + ",sup=" + invoiceData.getSupplierNo() + "(" + invoiceData.getSupplierCode() + ")");
                BeanUtils.copyProperties((Object)invoiceData, (Object)resultVO);
                rspBO.getResultList().add(resultVO);
                PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)invoiceData, (Object)invoiceInfo);
                if (StringUtils.hasText((String)invoiceData.getInvoiceNo())) {
                    invoiceInfo.setInvoiceStatus(InvoiceStatus.HAS_MAKE.getCode());
                    invoiceInfo.setMailStatus(InvoiceMailStatus.NOT_SENT.getCode());
                    try {
                        this.payInvoiceService.createInvoice(invoiceInfo);
                        BusiGetInvoiceDataServiceReqBO busiGetInvoiceDataServiceReqBO = new BusiGetInvoiceDataServiceReqBO();
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("invoiceId", invoiceInfo.getInvoiceNo());
                        map.put("invoiceCode", invoiceInfo.getInvoiceCode());
                        map.put("supplierId", invoiceInfo.getSupplierNo());
                        busiGetInvoiceDataServiceReqBO.setIdMap(map);
                        BusiGetInvoiceItemListRspBO busiGetInvoiceItemListRspBO = this.apiGetInvoiceDataService.getInvoiceItems(busiGetInvoiceDataServiceReqBO);
                        if (busiGetInvoiceItemListRspBO == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs() == null || busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs().size() <= 0) continue;
                        List<PayInvoiceDetail> invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                        if (!invoiceDetails.isEmpty()) {
                            try {
                                this.payInvoiceDetailMapper.deleteByInvoiceNo(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
                            }
                            catch (Exception e) {
                                LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                                continue;
                            }
                        }
                        List<PayItemInfo> list = this.payItemInfoMapper.selectByNotifNo(invoiceData.getNotificationNo());
                        for (BusiGetInvoiceItemBO busiGetInvoiceItemBO : busiGetInvoiceItemListRspBO.getBusiGetInvoiceItemBOs()) {
                            PayInvoiceDetail payInvoiceDetail = new PayInvoiceDetail();
                            BeanUtils.copyProperties((Object)busiGetInvoiceItemBO, (Object)payInvoiceDetail);
                            payInvoiceDetail.setInvoiceCode(invoiceInfo.getInvoiceCode());
                            payInvoiceDetail.setInvoiceNo(invoiceInfo.getInvoiceNo());
                            payInvoiceDetail.setInvoiceDate(invoiceInfo.getInvoiceDate());
                            BigDecimal taxRate = payInvoiceDetail.getTaxRate().divide(new BigDecimal(100));
                            payInvoiceDetail.setTaxRate(taxRate);
                            for (PayItemInfo payItemInfo : list) {
                                if (!String.valueOf(payItemInfo.getOrderId()).equals(busiGetInvoiceItemBO.getOrderCode()) || !payItemInfo.getExtSkuId().equals(busiGetInvoiceItemBO.getExtSkuId())) continue;
                                payInvoiceDetail.setOrderId(payItemInfo.getOrderId());
                                payInvoiceDetail.setInspectionId(payItemInfo.getInspectionId());
                                payInvoiceDetail.setItemNo(payItemInfo.getItemNo());
                                payInvoiceDetail.setSkuId(payItemInfo.getSkuId());
                                payInvoiceDetails.add(payInvoiceDetail);
                            }
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u63a5\u53e3\u53d1\u7968\u4fe1\u606f\u5931\u8d25!" + invoiceInfo, (Throwable)e);
                        continue;
                    }
                }
                this.busiUpdateNotificationExcepService.updateNotificationException(invoiceData.getResultMsg(), invoiceData.getNotificationNo());
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25:", (Throwable)e);
            }
        }
        try {
            LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u6570\u91cf", (Object)payInvoiceDetails.size());
            if (payInvoiceDetails.size() > 0) {
                this.payInvoiceDetailMapper.insertByBatch(payInvoiceDetails);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

