/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQryMailExportService;
import com.tydic.pfscext.api.busi.QueryBillApplyForMailService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailRspBO;
import com.tydic.pfscext.api.busi.vo.BusiExportBillApplyForMailVO;
import com.tydic.pfscext.api.busi.vo.PurchaseNoListVO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.umc.ability.UmcLogisticsRelaAbilityService;
import com.tydic.umc.ability.bo.LogisticsRelaAbilityBO;
import com.tydic.umc.ability.bo.UmcLogisticsRelaAbilitReqBO;
import com.tydic.umc.ability.bo.UmcLogisticsRelaAbilityRspBO;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryMailExportService"})
public class BusiQryMailExportServiceImpl
implements BusiQryMailExportService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryMailExportServiceImpl.class);
    @Autowired
    private UmcLogisticsRelaAbilityService umcLogisticsRelaAbilityService;
    @Autowired
    private QueryBillApplyForMailService queryBillApplyForMailService;

    @PostMapping(value={"qryExportInvoiceForMail"})
    public PfscExtRspPageBaseBO<BusiExportBillApplyForMailVO> qryExportInvoiceForMail(@RequestBody QueryBillApplyForMailReqBO reqBo) {
        LogisticsRelaAbilityBO logisticsRelaAbilityBO = new LogisticsRelaAbilityBO();
        UmcLogisticsRelaAbilitReqBO reqBO = new UmcLogisticsRelaAbilitReqBO();
        reqBO.setOperType("5");
        reqBO.setUserId(reqBO.getMemId());
        UmcLogisticsRelaAbilityRspBO queryFlagAddrInfor = this.umcLogisticsRelaAbilityService.operLogisticsRela(reqBO);
        if (queryFlagAddrInfor != null && queryFlagAddrInfor.getRows() != null) {
            logisticsRelaAbilityBO = (LogisticsRelaAbilityBO)queryFlagAddrInfor.getRows().get(0);
        }
        ArrayList<BusiExportBillApplyForMailVO> busiExportBillApplyForMailVOS = new ArrayList<BusiExportBillApplyForMailVO>();
        int serialNumber = 0;
        QueryBillApplyForMailRspBO queryInvoiceForMail = this.queryBillApplyForMailService.queryInvoiceForMail(reqBo);
        if (queryInvoiceForMail != null && queryInvoiceForMail.getRows() != null) {
            for (PurchaseNoListVO purchaseNoListVO : queryInvoiceForMail.getRows()) {
                BusiExportBillApplyForMailVO busiExportBillApplyForMailVO = new BusiExportBillApplyForMailVO();
                BeanUtils.copyProperties((Object)purchaseNoListVO, (Object)busiExportBillApplyForMailVO);
                busiExportBillApplyForMailVO.setSerialNumber(Integer.valueOf(++serialNumber));
                busiExportBillApplyForMailVO.setSenderAddrDesc(this.buildAddr(logisticsRelaAbilityBO));
                busiExportBillApplyForMailVO.setSenderName(logisticsRelaAbilityBO.getContactName());
                busiExportBillApplyForMailVO.setSenderTel(logisticsRelaAbilityBO.getContactMobile());
                busiExportBillApplyForMailVOS.add(busiExportBillApplyForMailVO);
            }
        }
        PfscExtRspPageBaseBO rspPageBaseBO = new PfscExtRspPageBaseBO();
        rspPageBaseBO.setRows(busiExportBillApplyForMailVOS);
        rspPageBaseBO.setRecordsTotal(Integer.valueOf(busiExportBillApplyForMailVOS.size()));
        rspPageBaseBO.setPageNo(Integer.valueOf(1));
        rspPageBaseBO.setTotal(Integer.valueOf(busiExportBillApplyForMailVOS.size()));
        return rspPageBaseBO;
    }

    private String buildAddr(LogisticsRelaAbilityBO logisticsRelaAbilityBO) {
        String addr = "";
        if (StringUtils.isNotBlank((String)logisticsRelaAbilityBO.getContactProvinceId())) {
            addr = addr + logisticsRelaAbilityBO.getContactProvinceName();
        }
        if (StringUtils.isNotBlank((String)logisticsRelaAbilityBO.getContactCityId())) {
            addr = addr + logisticsRelaAbilityBO.getContactCityName();
        }
        if (StringUtils.isNotBlank((String)logisticsRelaAbilityBO.getContactCountryId())) {
            addr = addr + logisticsRelaAbilityBO.getContactCountryName();
        }
        if (StringUtils.isNotBlank((String)logisticsRelaAbilityBO.getContactAddress())) {
            addr = addr + logisticsRelaAbilityBO.getContactAddress();
        }
        return addr;
    }
}

