/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQrySaleOrderDetailInfoForApplyService;
import com.tydic.pfscext.api.busi.bo.BusiSaleOrderDetailInfoForApplyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleOrderDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.SaleItemInfoRspBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderInfoRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.ProjectInfoBO;
import com.tydic.pfscext.external.api.bo.TsupplierInfoRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQrySaleOrderDetailInfoForApplyService"})
public class BusiQrySaleOrderDetailInfoForApplyServiceImpl
implements BusiQrySaleOrderDetailInfoForApplyService {
    private static final Logger log = LoggerFactory.getLogger(BusiQrySaleOrderDetailInfoForApplyServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"querySaleOrderDetailInfoForApply"})
    public BusiSaleOrderDetailInfoRspBO querySaleOrderDetailInfoForApply(@RequestBody BusiSaleOrderDetailInfoForApplyReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug(" \u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getInspectionId()) {
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiSaleOrderDetailInfoRspBO rspBO = new BusiSaleOrderDetailInfoRspBO();
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(reqBO.getInspectionId());
        saleOrderInfo.setOrderId(reqBO.getOrderId());
        SaleOrderInfo saleOrder = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        if (saleOrder == null) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a" + reqBO.toString() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\u3002");
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u5165\u53c2\uff1a" + reqBO.toString() + "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
        }
        SaleOrderInfoRspBO saleOrderInfoRspBO = new SaleOrderInfoRspBO();
        BeanUtils.copyProperties((Object)saleOrder, (Object)saleOrderInfoRspBO);
        saleOrderInfoRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrder.getOrderStatus())));
        PayPurchaseOrderInfo purchaseOrder = new PayPurchaseOrderInfo();
        purchaseOrder.setInspectionId(saleOrder.getInspectionId());
        purchaseOrder = this.payPurchaseOrderInfoMapper.getModelBy(purchaseOrder);
        if (purchaseOrder == null) {
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u9a8c\u6536\u5355\u53f7\uff1a" + saleOrder.getInspectionId() + "\u627e\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355");
        }
        saleOrderInfoRspBO.setExtOrderId(purchaseOrder.getExtOrderId());
        String serviceName = "";
        try {
            TsupplierInfoRspBO supplier;
            serviceName = "UmcQryEnterpriseAccountDetailAbilityService";
            ProjectInfoBO projectInfoBO = this.organizationInfoService.queryProjectName(saleOrder.getPurchaseProjectId());
            if (projectInfoBO != null) {
                saleOrderInfoRspBO.setPurchaseProjectName(projectInfoBO.getPurchaseOrgName());
            }
            serviceName = "UmcQrySupplierInfoListAbilityService";
            ArrayList<Long> supIds = new ArrayList<Long>();
            supIds.add(saleOrder.getSupplierNo());
            Map<Long, TsupplierInfoRspBO> suppliers = this.organizationInfoService.querySupplies(supIds);
            if (suppliers != null && (supplier = suppliers.get(saleOrder.getSupplierNo())) != null) {
                saleOrderInfoRspBO.setLinkMan(supplier.getLinkMan());
                saleOrderInfoRspBO.setTel(supplier.getTel());
                saleOrderInfoRspBO.setPhoneNumber(supplier.getPhoneNumber());
                saleOrderInfoRspBO.setAddrDesc(supplier.getAddrDesc());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3" + serviceName + "\u5f02\u5e38");
        }
        rspBO.setSaleOrderInfo(saleOrderInfoRspBO);
        SaleItemInfoVO vo = new SaleItemInfoVO();
        vo.setOrderId(reqBO.getOrderId());
        vo.setInspectionId(reqBO.getInspectionId());
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
        ArrayList<SaleItemInfoRspBO> itemList = new ArrayList<SaleItemInfoRspBO>();
        for (SaleItemInfo saleItemInfo : saleItemInfoList) {
            SaleItemInfoRspBO saleItemInfoRspBO = new SaleItemInfoRspBO();
            BeanUtils.copyProperties((Object)saleItemInfo, (Object)saleItemInfoRspBO);
            itemList.add(saleItemInfoRspBO);
        }
        rspBO.setSaleItemList(itemList);
        return rspBO;
    }
}

