/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiQueryRecAmtConfirmService;
import com.tydic.pfscext.api.busi.bo.BusiQueryRecAmtConfirmDetailRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryRecAmtConfirmReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryRecAmtConfirmRspBO;
import com.tydic.pfscext.dao.RecAmtConfirmMapper;
import com.tydic.pfscext.dao.vo.RecAmtConfirmPagination;
import com.tydic.pfscext.dao.vo.RecAmtConfirmVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.RecAmtConfirmStatus;
import com.tydic.pfscext.enums.ReceiptStatus;
import com.tydic.pfscext.enums.WFStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.UserDetailInfoBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQueryRecAmtConfirmService"})
public class BusiQueryRecAmtConfirmServiceImpl
implements BusiQueryRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryRecAmtConfirmServiceImpl.class);
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private OrganizationInfoService organizationInfoService;
    private EnumsService enumsService;
    private UserInfoService userInfoService;

    @Autowired
    public BusiQueryRecAmtConfirmServiceImpl(RecAmtConfirmMapper recAmtConfirmMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService, UserInfoService userInfoService) {
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
        this.userInfoService = userInfoService;
    }

    @PostMapping(value={"queryRecAmtConfirm"})
    public BusiQueryRecAmtConfirmRspBO queryRecAmtConfirm(@RequestBody BusiQueryRecAmtConfirmReqBO reqBO) {
        UserDetailInfoBO userDetailInfoBO;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null != (userDetailInfoBO = this.userInfoService.queryUserInfoByUserId(reqBO.getUserId()))) {
            reqBO.setOrgId(userDetailInfoBO.getOrgId());
            reqBO.setCompanyId(userDetailInfoBO.getCompanyId());
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirmPagination pagination = new RecAmtConfirmPagination();
        try {
            BeanUtils.copyProperties((Object)reqBO, (Object)pagination);
            pagination.setOrgId(reqBO.getCompanyId());
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u521d\u59cb\u5316\u5206\u9875\u67e5\u8be2\u7ec4\u4ef6\u51fa\u9519");
        }
        if (pagination.getCreateDateEnd() != null) {
            try {
                String createDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(pagination.getCreateDateEnd()) + " 23:59:59";
                pagination.setCreateDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        pagination.setStatus(RecAmtConfirmStatus.VALID.getCode());
        pagination.setOrderBy("c.DOC_NUM desc");
        pagination.initPagination();
        int recordsTotal = this.recAmtConfirmMapper.selectCountByConditionExt(pagination);
        pagination.completePagination(recordsTotal);
        List<RecAmtConfirmVO> rows = this.recAmtConfirmMapper.selectByConditionExt(pagination);
        BusiQueryRecAmtConfirmRspBO rspBO = new BusiQueryRecAmtConfirmRspBO();
        BeanUtils.copyProperties((Object)pagination, (Object)rspBO);
        ArrayList<BusiQueryRecAmtConfirmDetailRspBO> detailRows = new ArrayList<BusiQueryRecAmtConfirmDetailRspBO>();
        for (RecAmtConfirmVO row : rows) {
            BusiQueryRecAmtConfirmDetailRspBO detail = new BusiQueryRecAmtConfirmDetailRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setDocNum(String.valueOf(row.getDocNum()));
            String orgName = this.organizationInfoService.queryOrgName(row.getOrgId());
            detail.setOrgName(orgName);
            detail.setStatusDescr(this.enumsService.getDescr(RecAmtConfirmStatus.getInstance(row.getStatus())));
            detail.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            if (StringUtils.isNotBlank((CharSequence)detail.getApprovalStatus())) {
                detail.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(detail.getApprovalStatus())));
            }
            detail.setLastOperator(this.userInfoService.queryUserNameByUserId(row.getLastOperator()));
            detail.setReceiptStatusDescr(this.enumsService.getDescr(ReceiptStatus.getInstance(row.getReceiptStatus())));
            detailRows.add(detail);
        }
        rspBO.setRows(detailRows);
        return rspBO;
    }
}

