/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.service.atom.FscCancelApplyPayAtomService;
import com.tydic.pfscext.service.atom.bo.FscCancelApplyPayAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscCancelApplyPayAtomRspBO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscCancelApplyPayAtomService")
public class FscCancelApplyPayAtomServiceImpl
implements FscCancelApplyPayAtomService {
    private ApplyPayInfoMapper applyPayInfoMapper;
    private ApplyDetailMapper applyDetailMapper;
    private PayableDetailMapper payableDetailMapper;

    @Autowired
    public FscCancelApplyPayAtomServiceImpl(ApplyPayInfoMapper applyPayInfoMapper, ApplyDetailMapper applyDetailMapper, PayableDetailMapper payableDetailMapper) {
        this.applyPayInfoMapper = applyPayInfoMapper;
        this.applyDetailMapper = applyDetailMapper;
        this.payableDetailMapper = payableDetailMapper;
    }

    @Override
    public FscCancelApplyPayAtomRspBO cancelApplyPay(FscCancelApplyPayAtomReqBO reqBO) {
        FscCancelApplyPayAtomRspBO rspBO = new FscCancelApplyPayAtomRspBO();
        String validateArgStr = this.validateArg(reqBO);
        if (StringUtils.hasText((String)validateArgStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(validateArgStr);
            return rspBO;
        }
        String docNum = reqBO.getDocNum();
        List<ApplyDetail> applyDetailList = this.applyDetailMapper.selectPayableList(docNum);
        if (!CollectionUtils.isEmpty(applyDetailList)) {
            for (ApplyDetail applyDetail : applyDetailList) {
                int delete;
                BigDecimal amt = applyDetail.getAmt();
                String payableNo = applyDetail.getPayableNo();
                PayableDetailPO payableDetailInfo = this.payableDetailMapper.getModelById(payableNo);
                if (null != payableDetailInfo) {
                    PayableDetailPO payableDetailPO = new PayableDetailPO();
                    payableDetailPO.setPendingAmt(payableDetailInfo.getPendingAmt().subtract(amt));
                    payableDetailPO.setPayableStatus(PayableStatus.PENDING.getCode());
                    payableDetailPO.setPayableNo(payableNo);
                    int update = this.payableDetailMapper.updateByPayableNo(payableDetailPO);
                    if (update < 1) {
                        rspBO.setRespCode("18006");
                        rspBO.setRespDesc("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5355\u5931\u8d25");
                        return rspBO;
                    }
                    int delete2 = this.applyDetailMapper.deleteByPrimaryKey(docNum, payableNo);
                    if (delete2 < 1) {
                        rspBO.setRespCode("18006");
                        rspBO.setRespDesc("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5355\u5931\u8d25");
                        return rspBO;
                    }
                }
                if ((delete = this.applyPayInfoMapper.deleteById(docNum)) >= 1) continue;
                rspBO.setRespCode("18006");
                rspBO.setRespDesc("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5355\u5931\u8d25");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("18001");
            rspBO.setRespDesc("\u627e\u4e0d\u5230\u4ed8\u6b3e\u7533\u8bf7\u660e\u7ec6");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u53d6\u6d88\u4ed8\u6b3e\u7533\u8bf7\u5355\u6210\u529f");
        return rspBO;
    }

    private String validateArg(FscCancelApplyPayAtomReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getDocNum()) {
            return "\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

