/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom;

import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoReqBO;
import com.tydic.contract.api.supplier.bo.QueryContractSupplierInfoRspBO;
import com.tydic.contract.api.supplier.service.QueryContractSupplierService;
import com.tydic.pfscext.api.busi.BusiPayConfigDetailQryDetailService;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailFscQryListReqBo;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailFscQryListRspBo;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.InvokePaycenterService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.DatesUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payPayableService")
public class PayableService {
    private static final Logger logger = LoggerFactory.getLogger(PayableService.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private InvokePaycenterService invokePaycenterService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private QueryContractSupplierService queryContractSupplierService;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BusiPayConfigDetailQryDetailService busiPayConfigDetailQryDetailService;

    public void applyForNew(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 1);
    }

    public void cancelPay(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 2);
    }

    public void completePay(String payableNo, BigDecimal amount) {
        this.doAction(payableNo, amount, 3);
    }

    private PayableDetailPO checkParamter(String payableNo, BigDecimal amount) {
        if (!StringUtils.hasText((String)payableNo)) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u6d89\u53ca\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO payable = null;
        try {
            payable = this.payableDetailMapper.getModelById(payableNo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo, (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u5931\u8d25" + e.getMessage());
        }
        if (payable == null) {
            logger.debug("\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728,\u5e94\u4ed8\u5355=" + payableNo);
            throw new PfscExtBusinessException("18001", "\u5e94\u4ed8\u5355\u4e0d\u5b58\u5728");
        }
        return payable;
    }

    private void doAction(String payableNo, BigDecimal amount, int actType) {
        logger.debug("---\u51c6\u5907\u5904\u7406\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d\u64cd\u4f5c,\u5e94\u4ed8\u5355\u53f7=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",actType=" + actType);
        PayableDetailPO payable = this.checkParamter(payableNo, amount);
        if (payable.getPendingAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d(pendingAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new PfscExtBusinessException("18000", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u4e2d\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        if (payable.getPayableAmt() == null) {
            logger.debug("\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d(payableAmt)\u4e3anull,\u5e94\u4ed8\u5355\u53f7=" + payableNo);
            throw new PfscExtBusinessException("18000", "\u6b64\u5e94\u4ed8\u5355\u7684\u4ed8\u6b3e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
        }
        PayableDetailPO forUpdate = new PayableDetailPO();
        forUpdate.setPayableAmt(payable.getPendingAmt());
        if (actType == 1) {
            if (payable.getPayableAmt().compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u603b\u91d1\u989d=" + payable.getPayableAmt());
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5e94\u4ed8\u5355\u53f7\u7684\u603b\u91d1\u989d" + payable.getPayableAmt());
            }
            BigDecimal remainAmt = payable.getPayableAmt().subtract(payable.getPaidAmt()).subtract(payable.getPendingAmt());
            if (remainAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u5269\u4f59\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u5269\u4f59\u91d1\u989d=" + remainAmt);
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u5269\u4f59\u9700\u652f\u4ed8\u7684\u91d1\u989d" + remainAmt);
            }
            forUpdate.setPendingAmt(amount);
            forUpdate.setPayableStatus(PayableStatus.PAYING.getCode());
        } else {
            BigDecimal pendingAmt = payable.getPendingAmt();
            BigDecimal paidAmt = payable.getPaidAmt();
            if (pendingAmt.compareTo(amount) < 0) {
                logger.debug("\u5e94\u4ed8\u4ed8\u6b3e\u5931\u8d25,\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u91d1\u989d,\u5e94\u4ed8\u5355=" + payableNo + ",\u6d89\u53ca\u91d1\u989d=" + amount + ",\u4ed8\u6b3e\u4e2d\u91d1\u989d=" + payable.getPendingAmt());
                throw new PfscExtBusinessException("18000", "\u6d89\u53ca\u7684\u91d1\u989d\u8d85\u51fa\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d" + payable.getPendingAmt());
            }
            if (actType == 3) {
                if ((paidAmt = paidAmt.add(amount)).compareTo(payable.getPayableAmt()) == 0) {
                    forUpdate.setPayableStatus(PayableStatus.SUCCESS.getCode());
                }
                forUpdate.setPaidAmt(amount);
            }
            forUpdate.setPendingAmt(amount.negate());
            pendingAmt = pendingAmt.subtract(amount);
            if (pendingAmt.compareTo(BigDecimal.ZERO) == 0 && paidAmt.compareTo(BigDecimal.ZERO) == 0) {
                forUpdate.setPayableStatus(PayableStatus.PENDING.getCode());
            }
        }
        forUpdate.setPayableNo(payableNo);
        logger.debug("\u51c6\u5907\u4fee\u6539\u5e94\u4ed8\u5355\u7684\u76f8\u5173\u91d1\u989d,act=" + actType + ",\u53c2\u6570=" + forUpdate);
        int cnt = this.payableDetailMapper.updateAmount(forUpdate);
        if (cnt != 1) {
            logger.error("\u5e94\u4ed8\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u91d1\u989d\u5931\u8d25,\u5e94\u4ed8\u5355=" + payableNo + ",\u91d1\u989d=" + amount + ",\u66f4\u65b0\u6570=" + cnt);
            throw new PfscExtBusinessException("18006", "\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25,\u6b64\u9884\u4ed8\u5355\u53d1\u751f\u4e86\u53d8\u5316,\u8bf7\u91cd\u65b0\u64cd\u4f5c.");
        }
    }

    public List<PayableDetailPO> createApplyPayableBill(String applyNo, Long companyId, String companyName) {
        BillApplyInfo singleNotiInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (singleNotiInfo == null) {
            throw new PfscExtBusinessException("18001", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355");
        }
        String source = singleNotiInfo.getSource();
        ArrayList<PayableDetailPO> result = new ArrayList<PayableDetailPO>();
        QueryContractSupplierInfoReqBO queryContractSupplierInfoReqBO = new QueryContractSupplierInfoReqBO();
        queryContractSupplierInfoReqBO.setEnterPurchaserId(singleNotiInfo.getSupplierNo());
        queryContractSupplierInfoReqBO.setCategoryType(Integer.valueOf(1));
        QueryContractSupplierInfoRspBO RspBO = this.queryContractSupplierService.queryContratSupplierByEnterPurchaserId(queryContractSupplierInfoReqBO);
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        if (null == RspBO || !"0000".equals(RspBO.getCode())) {
            logger.error("\u4ea7\u751f\u5e94\u6536\u5931\u8d25(\u7535\u5b50\u8d85\u5e02),\u627e\u4e0d\u5230\u4f9b\u5e94\u5546\u7684\u5408\u540c\u53f7,\u4f9b\u5e94\u5546=" + singleNotiInfo.getSupplierNo());
        } else {
            saleItemInfo.setSaleContractCode(RspBO.getContractCode());
            saleItemInfo.setUnitId(RspBO.getContractId());
        }
        result.add(this.createApplyPayable(singleNotiInfo, source, PayablePayType.PREPAY, saleItemInfo, singleNotiInfo.getOperUnitNo(), singleNotiInfo.getSupplierNo(), singleNotiInfo.getAmt(), PayableStatus.PENDING, companyId, companyName));
        ((PayableDetailPO)result.get(0)).setNeedAgainstAmt(BigDecimal.ZERO);
        return result;
    }

    public List<PayableDetailPO> createPayableBill(String notificationNo, Long companyId, String busiType) {
        BillNotificationInfo singleNotiInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (singleNotiInfo == null) {
            throw new PfscExtBusinessException("18001", "\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355");
        }
        String source = singleNotiInfo.getSource();
        ArrayList<PayableDetailPO> result = new ArrayList<PayableDetailPO>();
        Date payDate = DatesUtils.dateAddMonths(new Date(), 0);
        QueryContractSupplierInfoReqBO queryContractSupplierInfoReqBO = new QueryContractSupplierInfoReqBO();
        queryContractSupplierInfoReqBO.setEnterPurchaserId(singleNotiInfo.getSupplierNo());
        queryContractSupplierInfoReqBO.setCategoryType(Integer.valueOf(1));
        QueryContractSupplierInfoRspBO RspBO = this.queryContractSupplierService.queryContratSupplierByEnterPurchaserId(queryContractSupplierInfoReqBO);
        PayItemInfo ord = new PayItemInfo();
        if (null == RspBO || !"0000".equals(RspBO.getCode())) {
            logger.error("\u4ea7\u751f\u5e94\u6536\u5931\u8d25(\u7535\u5b50\u8d85\u5e02),\u627e\u4e0d\u5230\u4f9b\u5e94\u5546\u7684\u5408\u540c\u53f7,\u4f9b\u5e94\u5546=" + singleNotiInfo.getSupplierNo());
        } else {
            ord.setUnitName(RspBO.getContractCode());
            ord.setUnitId(RspBO.getContractId());
        }
        result.add(this.createPayable(singleNotiInfo, source, PayablePayType.PAY, ord, singleNotiInfo.getOperNo(), singleNotiInfo.getSupplierNo(), singleNotiInfo.getAmt(), PayableStatus.PENDING, payDate, companyId, busiType));
        ((PayableDetailPO)result.get(0)).setNeedAgainstAmt(BigDecimal.ZERO);
        return result;
    }

    public PayableDetailPO createPrepayBill(PayItemInfo ord, Long operUnitNo, Long supNo, BigDecimal payableAmt, String source, String busiType) {
        if (ord == null || ord.getOrderId() == null) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (supNo == null) {
            throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u5fc5\u987b\u8f93\u5165");
        }
        if (operUnitNo == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8ID\u5fc5\u987b\u8f93\u5165");
        }
        if (source == null) {
            throw new PfscExtBusinessException("0001", "\u6240\u5c5e\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        if (payableAmt == null || payableAmt.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.createPayable(null, source, PayablePayType.PREPAY, ord, operUnitNo, supNo, payableAmt, PayableStatus.PENDING, null, null, busiType);
    }

    private PayableDetailPO createPayable(BillNotificationInfo notification, String source, PayablePayType payType, PayItemInfo item, Long operUnitNo, Long supNo, BigDecimal payableAmt, PayableStatus status, Date payDate, Long companyId, String busiType) {
        PayableDetailPO po = new PayableDetailPO();
        String snNo = this.getPayInfoId("CG");
        if (busiType.equals("0")) {
            snNo = this.getPayInfoId("YY");
        }
        po.setPayableNo(snNo);
        if (notification != null) {
            po.setNotificationNo(notification.getNotificationNo());
            po.setProfessionalDepartId(notification.getProfessionalDepartId());
            po.setServiceDepartId(notification.getServiceDepartId());
        }
        po.setOperatorId(operUnitNo);
        if (item != null) {
            po.setOrderId(item.getOrderId());
            po.setInspectionId(item.getInspectionId());
            po.setPurchaseOrderCode(item.getPurchaseOrderCode());
            po.setPurchaseOrderName(item.getItemName());
            po.setPlaAgreementCode(item.getUnitName());
            po.setContractId(item.getUnitId());
            PayPurchaseOrderInfo order = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(item.getOrderId(), item.getInspectionId());
            if (order != null) {
                po.setBranchCompany(order.getBranchCompany());
            }
        }
        po.setPurchaseNo(companyId);
        po.setSupplierId(supNo);
        po.setPayableAmt(payableAmt);
        po.setPaidAmt(BigDecimal.ZERO);
        po.setPendingAmt(BigDecimal.ZERO);
        po.setPayType(payType.getCode());
        po.setNeedAgainstAmt(payableAmt);
        po.setSource(source);
        po.setPaidDate(new Date());
        po.setPayableType(1);
        po.setPayableStatus(status.getCode());
        this.payableDetailMapper.insert(po);
        return po;
    }

    private PayableDetailPO createApplyPayable(BillApplyInfo billApplyInfo, String source, PayablePayType payType, SaleItemInfo item, Long operUnitNo, Long supNo, BigDecimal payableAmt, PayableStatus status, Long companyId, String companyName) {
        PayableDetailPO po = new PayableDetailPO();
        String snNo = this.getPayInfoId("SQ");
        po.setPayableNo(snNo);
        if (billApplyInfo != null) {
            po.setApplyNo(billApplyInfo.getApplyNo());
            po.setProfessionalDepartId(billApplyInfo.getProfessionalDepartId());
            po.setServiceDepartId(billApplyInfo.getServiceDepartId());
        }
        po.setOperatorId(operUnitNo);
        if (item != null) {
            po.setOrderId(item.getOrderId());
            po.setInspectionId(item.getInspectionId());
            po.setPurchaseOrderCode(item.getSaleOrderCode());
            po.setPurchaseOrderName(item.getSaleOrderName());
            po.setPlaAgreementCode(item.getSaleContractCode());
            po.setContractId(item.getUnitId());
            SaleOrderInfo order = this.saleOrderInfoMapper.getModelByPrimaryKey(item.getOrderId(), item.getInspectionId());
            if (order != null) {
                po.setBranchCompany(order.getBranchCompany());
            }
        }
        PayConfigDetailFscQryListReqBo payConfigDetailFscQryListReqBo = new PayConfigDetailFscQryListReqBo();
        payConfigDetailFscQryListReqBo.setExceptId(billApplyInfo.getPurchaseNo());
        if (billApplyInfo.getSource().equals("2")) {
            payConfigDetailFscQryListReqBo.setPayBusiType("0");
        } else if (billApplyInfo.getSource().equals("1")) {
            payConfigDetailFscQryListReqBo.setPayBusiType("1");
        }
        PayConfigDetailFscQryListRspBo payConfigDetailFscQryListRspBo = this.busiPayConfigDetailQryDetailService.payConfigDetailQryDetail(payConfigDetailFscQryListReqBo);
        if (payConfigDetailFscQryListRspBo != null && payConfigDetailFscQryListRspBo.getDays() != null) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(5, payConfigDetailFscQryListRspBo.getDays());
            String date = sd.format(calendar.getTime());
            po.setPaymentDays(payConfigDetailFscQryListRspBo.getDays());
            try {
                po.setPaidDate(sd.parse(date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        po.setPurchaseNo(companyId);
        po.setPurchaseName(companyName);
        po.setSupplierId(supNo);
        po.setPayableAmt(payableAmt);
        po.setPaidAmt(BigDecimal.ZERO);
        po.setPendingAmt(BigDecimal.ZERO);
        po.setPayType(payType.getCode());
        po.setNeedAgainstAmt(payableAmt);
        po.setSource(source);
        po.setPayableStatus(status.getCode());
        po.setPayableType(6);
        this.payableDetailMapper.insert(po);
        return po;
    }

    private String getPayInfoId(String prefix) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u5355\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

