/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.activity.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.bo.ActQueryActivityDetailAbilityReqBO;
import com.tydic.pfscext.api.activity.ActivityBillApplyInfoService;
import com.tydic.pfscext.api.busi.BusiApplyCreateNotificationService;
import com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfscext.api.busi.BusiReconcilitionService;
import com.tydic.pfscext.api.busi.ReconciliationHisService;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationRspBO;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRepBO;
import com.tydic.pfscext.api.busi.bo.BusiReconcilitionRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.ReconciliationReqBo;
import com.tydic.pfscext.api.busi.bo.ReconcilitionHisListRspBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.busi.vo.InvoiceVeriySamp;
import com.tydic.pfscext.api.busi.vo.MatchingResult;
import com.tydic.pfscext.api.busi.vo.ReconciliationHisVo;
import com.tydic.pfscext.api.busi.vo.ReconciliationRspVo;
import com.tydic.pfscext.api.trade.bo.BillApplyInfoReqBO;
import com.tydic.pfscext.api.trade.bo.BillApplyInfoRspBO;
import com.tydic.pfscext.api.trade.bo.BusiApplyInvoiceVerifyReqBO;
import com.tydic.pfscext.api.trade.bo.BusiApplyInvoiceVerifyRspBO;
import com.tydic.pfscext.api.zm.bo.AddBillApplyInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceDetailVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.activity.ActivityBillApplyInfoService"})
public class ActivityBillApplyInfoServiceImpl
implements ActivityBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityBillApplyInfoServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BusiCreateOutstockInfoService busiCreateOutstockInfoService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;
    @Autowired
    private ReconcilitionHisMapper reconcilitionHisMapper;
    @Autowired
    private BusiReconcilitionService busiReconcilitionService;
    private static final Long SUPPLIER_ID = 100055L;
    @Autowired
    private ReconciliationHisService reconciliationHisService;
    @Autowired
    private BusiApplyCreateNotificationService busiApplyCreateNotificationService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"invoiceApplySponsor"})
    public BusiReconcilitionRspBO invoiceApplySponsor(@RequestBody QueryPayPurchaseOrderInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u7533\u8bf7\u53d1\u8d77\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO);
        }
        BusiReconcilitionRspBO busiReconcilitionRspBO = new BusiReconcilitionRspBO();
        try {
            ActQueryActivityDetailAbilityReqBO actQueryActivityDetailAbilityReqBO = new ActQueryActivityDetailAbilityReqBO();
            actQueryActivityDetailAbilityReqBO.setActiveId(reqBO.getActivityId());
            actQueryActivityDetailAbilityReqBO.setOrgIdIn(reqBO.getCompanyId().toString());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
            saleOrderInfoVO.setPurchaseProjectId(reqBO.getPurchaseProjectId());
            saleOrderInfoVO.setActivityId(reqBO.getActivityId());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getListPageJoinActivity(saleOrderInfoVO);
            if (saleOrderInfos != null) {
                int count = this.reconcilitionHisMapper.selectByActivity(saleOrderInfos);
                logger.debug("\u6bd4\u8f83\uff1a" + saleOrderInfos.size() + "count" + count);
                if (saleOrderInfos.size() == count) {
                    busiReconcilitionRspBO.setFlag(Boolean.valueOf(true));
                } else {
                    ArrayList<String> orderCodeList = new ArrayList<String>();
                    ArrayList<String> orderCodeNotList = new ArrayList<String>();
                    HashMap<Long, QueryPayPurchaseOrderInfoReqBO> map = new HashMap<Long, QueryPayPurchaseOrderInfoReqBO>();
                    for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                        QueryPayPurchaseOrderInfoReqBO reqBO1 = new QueryPayPurchaseOrderInfoReqBO();
                        QueryPayPurchaseOrderInfoReqBO reqBO2 = new QueryPayPurchaseOrderInfoReqBO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)reqBO2);
                        reqBO1.setOrderId(saleOrderInfo.getOrderId());
                        reqBO1.setInspectionId(saleOrderInfo.getInspectionId());
                        if (map.get(saleOrderInfo.getSupplierNo()) != null) {
                            ((QueryPayPurchaseOrderInfoReqBO)map.get(saleOrderInfo.getSupplierNo())).getQueryPayPurchaseOrderInfoReqBOs().add(reqBO1);
                            continue;
                        }
                        ArrayList<QueryPayPurchaseOrderInfoReqBO> reqBOs = new ArrayList<QueryPayPurchaseOrderInfoReqBO>();
                        reqBOs.add(reqBO1);
                        reqBO2.setQueryPayPurchaseOrderInfoReqBOs(reqBOs);
                        map.put(saleOrderInfo.getSupplierNo(), reqBO2);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        BusiReconcilitionRepBO reconcilitionRepBO;
                        ReconcilitionHisListRspBO reconcilitionHisListRspBO;
                        Long supplierId = (Long)entry.getKey();
                        QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO = (QueryPayPurchaseOrderInfoReqBO)entry.getValue();
                        if (queryPayPurchaseOrderInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs() != null && queryPayPurchaseOrderInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs().size() > 0) {
                            int count1 = this.reconcilitionHisMapper.selectByOrderIds(queryPayPurchaseOrderInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs());
                            if (queryPayPurchaseOrderInfoReqBO.getQueryPayPurchaseOrderInfoReqBOs().size() == count1) continue;
                        }
                        Integer versionNo = null;
                        if (!SUPPLIER_ID.equals(supplierId)) {
                            reconcilitionHisListRspBO = this.busiReconcilitionService.cancelReconclition(queryPayPurchaseOrderInfoReqBO);
                            if ("0000".equals(reconcilitionHisListRspBO.getRespCode())) {
                                reconcilitionRepBO = new BusiReconcilitionRepBO();
                                BeanUtils.copyProperties((Object)queryPayPurchaseOrderInfoReqBO, (Object)reconcilitionRepBO);
                                reconcilitionRepBO.setVersionNo(reconcilitionHisListRspBO.getVersionNo());
                                if ("0".equals(queryPayPurchaseOrderInfoReqBO.getIsProfessionalOrgExt())) {
                                    reconcilitionRepBO.setPurchaseNo(queryPayPurchaseOrderInfoReqBO.getPurchaseNo());
                                } else {
                                    reconcilitionRepBO.setPurchaseNo(queryPayPurchaseOrderInfoReqBO.getCompanyId());
                                }
                                busiReconcilitionRspBO = this.busiReconcilitionService.registerReconcilition(reconcilitionRepBO);
                                if (!"0000".equals(busiReconcilitionRspBO.getRespCode())) throw new PfscExtBusinessException("18000", supplierId + "\u5f00\u7968\u7533\u8bf7\u5931\u8d25");
                                versionNo = Integer.parseInt(reconcilitionHisListRspBO.getVersionNo());
                            }
                        } else {
                            reconcilitionHisListRspBO = this.busiReconcilitionService.cancelReconclitionJD(queryPayPurchaseOrderInfoReqBO);
                            if ("0000".equals(reconcilitionHisListRspBO.getRespCode())) {
                                reconcilitionRepBO = new BusiReconcilitionRepBO();
                                reconcilitionRepBO.setVersionNo(reconcilitionHisListRspBO.getVersionNo());
                                BeanUtils.copyProperties((Object)queryPayPurchaseOrderInfoReqBO, (Object)reconcilitionRepBO);
                                busiReconcilitionRspBO = this.busiReconcilitionService.registerReconcilitionJD(reconcilitionRepBO);
                                if (!"0000".equals(busiReconcilitionRspBO.getRespCode())) throw new PfscExtBusinessException("18000", supplierId + "\u5f00\u7968\u7533\u8bf7\u5931\u8d25");
                                versionNo = Integer.parseInt(reconcilitionHisListRspBO.getVersionNo());
                            }
                        }
                        ReconciliationReqBo condition = new ReconciliationReqBo();
                        condition.setSupplierNo(Integer.valueOf(supplierId.intValue()));
                        condition.setTabId(Integer.valueOf(2));
                        condition.setVersionNo(versionNo);
                        ReconciliationRspVo reconciliationRspVo = this.reconciliationHisService.getReceiptInfoByTabId(condition);
                        condition.setTabId(Integer.valueOf(3));
                        ReconciliationRspVo reconciliationRspVo1 = this.reconciliationHisService.getReceiptInfoByTabId(condition);
                        if (reconciliationRspVo != null && reconciliationRspVo.getRows() != null && reconciliationRspVo.getRows().size() > 0) {
                            for (ReconciliationHisVo reconciliationHisVo : reconciliationRspVo.getRows()) {
                                orderCodeList.add(reconciliationHisVo.getOrderId());
                            }
                        }
                        if (reconciliationRspVo1 != null && reconciliationRspVo1.getRows() != null && reconciliationRspVo1.getRows().size() > 0) {
                            for (ReconciliationHisVo reconciliationHisVo : reconciliationRspVo1.getRows()) {
                                orderCodeNotList.add(reconciliationHisVo.getOrderId());
                            }
                        }
                        ArrayList<String> orderCodes = new ArrayList<String>();
                        condition.setTabId(Integer.valueOf(1));
                        ReconciliationRspVo reconciliationRspVo2 = this.reconciliationHisService.getReceiptInfoByTabId(condition);
                        if (reconciliationRspVo2 == null || reconciliationRspVo2.getRows() == null || reconciliationRspVo2.getRows().size() <= 0) continue;
                        for (ReconciliationHisVo reconciliationHisVo : reconciliationRspVo2.getRows()) {
                            orderCodes.add(reconciliationHisVo.getOrderId());
                        }
                        BusiNotificationReqBO busiNotificationReqBO = new BusiNotificationReqBO();
                        BeanUtils.copyProperties((Object)reqBO, (Object)busiNotificationReqBO);
                        busiNotificationReqBO.setOrderCodes(orderCodes);
                        busiNotificationReqBO.setOperUnitNo(((ReconciliationHisVo)reconciliationRspVo.getRows().get(0)).getOperUnitNo());
                        busiNotificationReqBO.setSupplierNo(reqBO.getSupplierNo());
                        busiNotificationReqBO.setSource(reqBO.getSource().toString());
                        BusiNotificationRspBO busiNotificationRspBO = this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBO);
                    }
                    if (orderCodeList.size() > 0 || orderCodeNotList.size() > 0) {
                        StringBuffer sb = new StringBuffer();
                        for (String orderCode : orderCodeList) {
                            sb.append(orderCode).append(",");
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        for (String orderCode : orderCodeNotList) {
                            stringBuffer.append(orderCode).append(",");
                        }
                        if (sb.length() > 0) {
                            sb.append("(\u8ba2\u5355\u7f16\u53f7)\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458");
                        } else if (stringBuffer.length() > 0) {
                            stringBuffer.append("(\u8ba2\u5355\u7f16\u53f7)\u672a\u9a8c\u6536\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458");
                        }
                        busiReconcilitionRspBO.setFlag(Boolean.valueOf(false));
                        busiReconcilitionRspBO.setRespCode("18000");
                        busiReconcilitionRspBO.setRespDesc(sb.toString() + stringBuffer.toString());
                        return busiReconcilitionRspBO;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u7968\u7533\u8bf7\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u67e5\u8be2\u5931\u8d25");
        }
        busiReconcilitionRspBO.setRespCode("0000");
        busiReconcilitionRspBO.setRespDesc("\u6210\u529f");
        return busiReconcilitionRspBO;
    }

    @PostMapping(value={"addBillApplyInfo"})
    public PfscExtRspBaseBO addBillApplyInfo(@RequestBody AddBillApplyInfoReqBO addBillApplyInfoReqBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        if (addBillApplyInfoReqBO == null) {
            throw new PfscExtBusinessException("18000", "\u751f\u4ea7\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addBillApplyInfoReqBO.getMailAddrInfo() == null) {
            throw new PfscExtBusinessException("18000", "\u90ae\u5bc4\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addBillApplyInfoReqBO.getInvoiceInfo() == null) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setPurchaseNo(addBillApplyInfoReqBO.getCompanyId());
            saleOrderInfoVO.setPurchaseProjectId(addBillApplyInfoReqBO.getPurchaseProjectId());
            saleOrderInfoVO.setActivityId(addBillApplyInfoReqBO.getActivityId());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getListPageJoinActivity(saleOrderInfoVO);
            HashMap<Long, QueryPayPurchaseOrderInfoReqBO> map = new HashMap<Long, QueryPayPurchaseOrderInfoReqBO>();
            HashMap<Long, String> suppNameMap = new HashMap<Long, String>();
            for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
                QueryPayPurchaseOrderInfoReqBO reqBO1 = new QueryPayPurchaseOrderInfoReqBO();
                reqBO1.setOrderId(saleOrderInfo.getOrderId());
                reqBO1.setInspectionId(saleOrderInfo.getInspectionId());
                if (map.get(saleOrderInfo.getSupplierNo()) != null) {
                    ((QueryPayPurchaseOrderInfoReqBO)map.get(saleOrderInfo.getSupplierNo())).getQueryPayPurchaseOrderInfoReqBOs().add(reqBO1);
                } else {
                    ArrayList<QueryPayPurchaseOrderInfoReqBO> reqBOs = new ArrayList<QueryPayPurchaseOrderInfoReqBO>();
                    reqBOs.add(reqBO1);
                    reqBO1.setQueryPayPurchaseOrderInfoReqBOs(reqBOs);
                    map.put(saleOrderInfo.getSupplierNo(), reqBO1);
                }
                suppNameMap.put(saleOrderInfo.getSupplierNo(), saleOrderInfo.getSupplierName());
                logger.info("#######map#######:" + saleOrderInfo.getSupplierName());
            }
            logger.info("#######map#######:" + suppNameMap);
            for (Map.Entry entry : map.entrySet()) {
                Long supplierId = (Long)entry.getKey();
                QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfo = (QueryPayPurchaseOrderInfoReqBO)entry.getValue();
                BillApplyInfo billApplyInfo = new BillApplyInfo();
                String applyNo = this.getBillApplyNo();
                billApplyInfo.setApplyNo(applyNo);
                BeanUtils.copyProperties((Object)addBillApplyInfoReqBO, (Object)billApplyInfo);
                BeanUtils.copyProperties((Object)addBillApplyInfoReqBO.getMailAddrInfo(), (Object)billApplyInfo);
                billApplyInfo.setSource(addBillApplyInfoReqBO.getSource().toString());
                billApplyInfo.setApplyDate(new Date());
                billApplyInfo.setApplyType("00");
                billApplyInfo.setBillStatus("00");
                billApplyInfo.setOperUnitNo(addBillApplyInfoReqBO.getCompanyId());
                billApplyInfo.setSupplierName((String)suppNameMap.get(supplierId));
                billApplyInfo.setSubUserName(queryPayPurchaseOrderInfo.getSupName());
                billApplyInfo.setOperUnitName(addBillApplyInfoReqBO.getCompanyName());
                InvoiceHeaderVO invoiceInfo = addBillApplyInfoReqBO.getInvoiceInfo();
                billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
                if (invoiceInfo.getInvoiceClass() != null) {
                    billApplyInfo.setInvoiceClasses(invoiceInfo.getInvoiceClass().toString());
                }
                billApplyInfo.setInvoiceType(invoiceInfo.getInvoiceType().toString());
                billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
                billApplyInfo.setPhone(invoiceInfo.getPhone());
                billApplyInfo.setBankName(invoiceInfo.getBank());
                billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
                billApplyInfo.setAddr(invoiceInfo.getAddress());
                this.billApplyInfoMapper.insertSelective(billApplyInfo);
                pfscExtRspBaseBO.setRespCode("0000");
                pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
                ArrayList<Long> ids = new ArrayList<Long>();
                for (QueryPayPurchaseOrderInfoReqBO queryPayPurchaseOrderInfoReqBO : queryPayPurchaseOrderInfo.getQueryPayPurchaseOrderInfoReqBOs()) {
                    ids.add(queryPayPurchaseOrderInfoReqBO.getInspectionId());
                }
                SaleOrderInfoVO saleOrderInfoVO1 = new SaleOrderInfoVO();
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfoVO1.setInspectionIdList(ids);
                saleOrderInfo.setApplyNo(applyNo);
                saleOrderInfo.setOrderStatus("01");
                this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO1, saleOrderInfo);
                SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(applyNo);
                saleItemInfoVO.setInspectionIdList(ids);
                this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u4ea7\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u751f\u4ea7\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"qryBillApplyInfoList"})
    public PfscExtRspPageBaseBO<BillApplyInfoRspBO> qryBillApplyInfoList(@RequestBody BillApplyInfoReqBO billApplyInfoReqBO) {
        PfscExtRspPageBaseBO rspBO = new PfscExtRspPageBaseBO();
        try {
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            ArrayList<BillApplyInfoRspBO> billApplyInfoRspBOs = new ArrayList<BillApplyInfoRspBO>();
            BeanUtils.copyProperties((Object)billApplyInfoReqBO, (Object)billApplyInfoVO);
            Page page = new Page(billApplyInfoReqBO.getPageNo().intValue(), billApplyInfoReqBO.getPageSize().intValue());
            List<BillApplyInfo> billApplyInfos = this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page);
            if (billApplyInfos != null) {
                ArrayList<Long> inAccountIds = new ArrayList<Long>();
                ArrayList<String> applyNos = new ArrayList<String>();
                for (BillApplyInfo billApplyInfo : billApplyInfos) {
                    if (!inAccountIds.contains(billApplyInfo.getPurchaseProjectId())) {
                        inAccountIds.add(billApplyInfo.getPurchaseProjectId());
                    }
                    if (applyNos.contains(billApplyInfo.getApplyNo())) continue;
                    applyNos.add(billApplyInfo.getApplyNo());
                }
                HashMap<String, SaleInvoiceInfo> maps = new HashMap<String, SaleInvoiceInfo>();
                if (applyNos.size() > 0) {
                    List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectByapplyNoList(applyNos);
                    for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                        maps.put(saleInvoiceInfo.getApplyNo(), saleInvoiceInfo);
                    }
                }
                HashMap<Long, String> map = new HashMap<Long, String>();
                UmcQryEnterpriseAccountListNoPageAbilityReqBO umcQryEnterpriseAccountListNoPageAbilityReqBO = new UmcQryEnterpriseAccountListNoPageAbilityReqBO();
                umcQryEnterpriseAccountListNoPageAbilityReqBO.setInAccountIds(inAccountIds);
                UmcQryEnterpriseAccountListNoPageAbilityRspBO rspBo = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountListNoPage(umcQryEnterpriseAccountListNoPageAbilityReqBO);
                if (rspBo != null & rspBo.getRows() != null && rspBo.getRows().size() > 0) {
                    for (UmcEnterpriseAccountAbilityBO umcEnterpriseAccountAbilityBO : rspBo.getRows()) {
                        map.put(umcEnterpriseAccountAbilityBO.getAccountId(), umcEnterpriseAccountAbilityBO.getAccountName());
                    }
                }
                for (BillApplyInfo billApplyInfo : billApplyInfos) {
                    BillApplyInfoRspBO billApplyInfoRspBO = new BillApplyInfoRspBO();
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)billApplyInfoRspBO);
                    if (maps.get(billApplyInfo.getApplyNo()) != null) {
                        BeanUtils.copyProperties(maps.get(billApplyInfo.getApplyNo()), (Object)billApplyInfoRspBO);
                    }
                    if (billApplyInfo.getBillStatus() != null) {
                        billApplyInfoRspBO.setBillStatusStr(BillStatus.getInstance(billApplyInfo.getBillStatus()).getDescr());
                    }
                    if (billApplyInfo.getInvoiceClasses() != null) {
                        billApplyInfoRspBO.setInvoiceClassesStr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses()).getDescr());
                    }
                    if (billApplyInfo.getInvoiceType() != null) {
                        billApplyInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType())).getDescr());
                    }
                    if (billApplyInfo.getPurchaseProjectId() != null) {
                        billApplyInfoRspBO.setPurchaseProjectName((String)map.get(billApplyInfo.getPurchaseProjectId()));
                    }
                    if (billApplyInfo.getIsPay() != null && billApplyInfo.getIsPay() == 1) {
                        billApplyInfoRspBO.setIsPayStr("\u5426");
                    } else {
                        billApplyInfoRspBO.setIsPayStr("\u662f");
                    }
                    billApplyInfoRspBOs.add(billApplyInfoRspBO);
                }
                rspBO.setRows(billApplyInfoRspBOs);
                rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
                rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
                rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        return rspBO;
    }

    @PostMapping(value={"qryBillApplyInfoDetail"})
    public BillApplyInfoRspBO qryBillApplyInfoDetail(@RequestBody BillApplyInfoReqBO billApplyInfoReqBO) {
        if (billApplyInfoReqBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoRspBO billApplyInfoRspBO = new BillApplyInfoRspBO();
        try {
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(billApplyInfoReqBO.getApplyNo());
            if (billApplyInfo != null) {
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)billApplyInfoRspBO);
                if (billApplyInfo.getBillStatus() != null) {
                    billApplyInfoRspBO.setBillStatusStr(BillStatus.getInstance(billApplyInfo.getBillStatus()).getDescr());
                }
                if (billApplyInfo.getInvoiceClasses() != null) {
                    billApplyInfoRspBO.setInvoiceClassesStr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses()).getDescr());
                }
                if (billApplyInfo.getInvoiceType() != null) {
                    billApplyInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(Integer.parseInt(billApplyInfo.getInvoiceType())).getDescr());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\u8be6\u60c5", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\u8be6\u60c5");
        }
        return billApplyInfoRspBO;
    }

    @PostMapping(value={"cancelBillApplyInfoStatus"})
    public PfscExtRspBaseBO cancelBillApplyInfoStatus(@RequestBody BillApplyInfoReqBO billApplyInfoReqBO) {
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            this.billApplyInfoMapper.updateStatusByApplyNo(billApplyInfoReqBO.getApplyNo(), "99");
            this.saleOrderInfoMapper.updateStatusByApplyNo(billApplyInfoReqBO.getApplyNo(), "00");
            pfscExtRspBaseBO.setRespCode("0000");
            pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }

    @PostMapping(value={"invoiceVerify"})
    public BusiApplyInvoiceVerifyRspBO invoiceVerify(@RequestBody BusiApplyInvoiceVerifyReqBO busiApplyInvoiceVerifyReqBO) {
        BillApplyInfo billApplyInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u6838\u5bf9\u7b7e\u6536\u670d\u52a1\u5165\u53c2=" + busiApplyInvoiceVerifyReqBO);
        }
        String applyNo = busiApplyInvoiceVerifyReqBO.getApplyNo();
        Long companyId = busiApplyInvoiceVerifyReqBO.getCompanyId();
        if (null == companyId) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u5fc5\u987b\u8f93\u5165");
        }
        if (StringUtils.isEmpty((Object)applyNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7(apply)\u5fc5\u987b\u8f93\u5165");
        }
        if (null == busiApplyInvoiceVerifyReqBO.getSignMode()) {
            busiApplyInvoiceVerifyReqBO.setSignMode(Integer.valueOf(0));
        }
        if ((billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo)) == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355,\u7533\u8bf7\u5355\u53f7=" + applyNo + ",companyId=" + companyId);
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7" + applyNo + "\u4e0d\u5b58\u5728!");
        }
        String billSta = billApplyInfo.getBillStatus();
        BillStatus nowSta = BillStatus.getInstance(billSta);
        if (nowSta == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u901a\u77e5\u5355\u53f7=" + applyNo + ",\u5355\u72b6\u6001=" + billSta);
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + applyNo + "\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
        }
        if (BillStatus.SEND_BILL != nowSta) {
            if (busiApplyInvoiceVerifyReqBO.getSignMode() == 1) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e0d\u662f\u5df2\u5f00\u7968(03),\u901a\u77e5\u5355\u53f7=" + applyNo + ",\u5355\u72b6\u6001=" + billSta);
                throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + applyNo + "\u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u6838\u5bf9\u64cd\u4f5c");
            }
            busiApplyInvoiceVerifyReqBO.setSignMode(Integer.valueOf(2));
        }
        List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectByApplyNoOrderBy(applyNo);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u6d89\u53ca\u53d1\u7968\u6570\u91cf=" + invoices.size() + ",\u901a\u77e5\u5355\u53f7=" + applyNo);
        if (invoices.size() == 0) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968,\u901a\u77e5\u5355\u53f7=" + applyNo);
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u901a\u77e5\u5355" + applyNo + "\u5bf9\u5e94\u7684\u53d1\u7968");
        }
        Statis ivStatis = this.saleInvoiceInfoMapper.invoiceStatis(applyNo);
        Statis ordStatis = this.saleItemInfoMapper.orderStatis(applyNo);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u8ba2\u5355\u5546\u54c1\u7edf\u8ba1=" + ordStatis);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u53d1\u7968\u5546\u54c1\u660e\u7ec6\u7edf\u8ba1=" + ivStatis);
        List<SaleItemInfo> sampsInOrders = this.saleItemInfoMapper.selectByApplyNoAndOrderId(applyNo, null, null);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u5546\u54c1\u660e\u7ec6\u6570\u91cf=" + sampsInOrders.size() + ",\u901a\u77e5\u5355\u53f7=" + applyNo);
        if (sampsInOrders.size() == 0) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + applyNo);
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u901a\u77e5\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6");
        }
        BusiApplyInvoiceVerifyRspBO resp = new BusiApplyInvoiceVerifyRspBO();
        resp.setApplyNo(applyNo);
        resp.setSignMode(busiApplyInvoiceVerifyReqBO.getSignMode());
        resp.setOrderCount(ordStatis.getGrpCount());
        resp.setOrderAmount(ordStatis.getTotAmt());
        resp.setOrderUntaxAmt(ordStatis.getTotUntaxAmt());
        resp.setOrderTaxAmt(ordStatis.getTotTaxAmt());
        resp.setInvoiceAmount(ivStatis.getTotAmt());
        resp.setInvoiceCount(ivStatis.getGrpCount());
        resp.setInvoiceTaxAmt(ivStatis.getTotTaxAmt());
        resp.setInvoiceUntaxAmt(ivStatis.getTotUntaxAmt());
        resp.setVerifyPersonId(busiApplyInvoiceVerifyReqBO.getUserId());
        this.verify(busiApplyInvoiceVerifyReqBO, resp, billApplyInfo, invoices, sampsInOrders, busiApplyInvoiceVerifyReqBO.getSignMode() == 1);
        if (resp.getVerifyResult() != null && !"".equals(resp.getVerifyResult())) {
            if (resp.getVerifyResult() == 1) {
                resp.setVerifyResultDescr("\u6838\u5bf9\u5339\u914d");
            } else if (resp.getVerifyResult() == 0) {
                resp.setVerifyResultDescr("\u6838\u5bf9\u5b58\u5728\u5dee\u5f02");
            }
        }
        if (busiApplyInvoiceVerifyReqBO.getSignMode() == 1) {
            resp = new BusiApplyInvoiceVerifyRspBO();
        }
        this.billApplyInfoMapper.updateStatusByApplyNo(busiApplyInvoiceVerifyReqBO.getApplyNo(), "08");
        return resp;
    }

    private void verify(BusiApplyInvoiceVerifyReqBO busiInvoiceVerifyReqBO, BusiApplyInvoiceVerifyRspBO resp, BillApplyInfo bill, List<SaleInvoiceInfo> invoices, List<SaleItemInfo> sampsInOrders, boolean forSigned) {
        String invoiceNo;
        SaleInvoiceInfo invoice = invoices.get(0);
        resp.setSummaries(new ArrayList());
        resp.setDetails(new ArrayList());
        resp.setVerifyResult(Integer.valueOf(1));
        if (bill.getSupplierNo() != null && bill.getSupplierNo().equals(100055L)) {
            invoice.setName(StringUtils.hasText((String)invoice.getName()) ? invoice.getName() : bill.getInvoceName());
            invoice.setTaxNo(StringUtils.hasText((String)invoice.getTaxNo()) ? invoice.getTaxNo() : bill.getTaxNo());
            invoice.setAddress(StringUtils.hasText((String)invoice.getAddress()) ? invoice.getAddress() : bill.getAddr());
            invoice.setPhone(StringUtils.hasText((String)invoice.getPhone()) ? invoice.getPhone() : bill.getPhone());
            invoice.setBankName(StringUtils.hasText((String)invoice.getBankName()) ? invoice.getBankName() : bill.getBankName());
            invoice.setBankAcNo(StringUtils.hasText((String)invoice.getBankAcNo()) ? invoice.getBankAcNo() : bill.getBankAcctNo());
        }
        resp.getSummaries().add(new MatchingResult().compare("\u540d\u79f0", (Object)bill.getInvoceName(), (Object)invoice.getName()));
        resp.getSummaries().add(new MatchingResult().compare("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Object)bill.getTaxNo(), (Object)invoice.getTaxNo()));
        resp.getSummaries().add(new MatchingResult().compare("\u5730\u5740", (Object)bill.getAddr(), (Object)invoice.getAddress()));
        resp.getSummaries().add(new MatchingResult().compare("\u7535\u8bdd", (Object)bill.getPhone(), (Object)invoice.getPhone()));
        resp.getSummaries().add(new MatchingResult().compare("\u5f00\u6237\u884c", (Object)bill.getBankName(), (Object)invoice.getBankName()));
        resp.getSummaries().add(new MatchingResult().compare("\u6c47\u603b\u91d1\u989d(\u542b\u7a0e)", (Object)resp.getOrderAmount(), (Object)resp.getInvoiceAmount()));
        resp.getSummaries().add(new MatchingResult().compare("\u6c47\u603b\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Object)resp.getOrderUntaxAmt(), (Object)resp.getInvoiceUntaxAmt()));
        resp.getSummaries().add(new MatchingResult().compare("\u7a0e\u989d", (Object)resp.getOrderTaxAmt(), (Object)resp.getInvoiceTaxAmt()));
        for (MatchingResult result : resp.getSummaries()) {
            if (!new Integer(0).equals(result.getMatched())) continue;
            resp.setVerifyResult(Integer.valueOf(0));
            break;
        }
        List<SaleInvoiceDetailVO> saleInvoiceDetailVOs = this.saleInvoiceInfoMapper.selectJoinDetail(invoice);
        ArrayList<SaleInvoiceDetail> invoiceDetails = new ArrayList<SaleInvoiceDetail>();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(bill.getSource()) || OrderSource.CONSULT_PRICE.getCode().equals(bill.getSource()) || OrderSource.COAL_AREA.getCode().equals(bill.getSource())) {
            ArrayList<SaleInvoiceDetailVO> payInvoiceDetailVOs2 = new ArrayList<SaleInvoiceDetailVO>();
            for (SaleInvoiceDetailVO vo : saleInvoiceDetailVOs) {
                boolean matchFlag = false;
                for (SaleInvoiceDetailVO vo2 : payInvoiceDetailVOs2) {
                    if (!vo2.getSeq().equals(vo.getSeq())) continue;
                    matchFlag = true;
                    invoiceNo = vo2.getInvoiceNo();
                    if (!invoiceNo.contains(vo.getInvoiceNo())) {
                        invoiceNo = invoiceNo + "," + vo.getInvoiceNo();
                    }
                    vo2.setInvoiceNo(invoiceNo);
                    vo2.setQuantity(vo2.getQuantity().add(vo.getQuantity()));
                    vo2.setTaxAmt(vo2.getTaxAmt().add(vo.getTaxAmt()));
                    vo2.setUntaxAmt(vo2.getUntaxAmt().add(vo.getUntaxAmt()));
                    vo2.setAmount(vo2.getAmount().add(vo.getAmount()));
                }
                if (matchFlag) continue;
                payInvoiceDetailVOs2.add(vo);
            }
            for (SaleInvoiceDetailVO vo2 : payInvoiceDetailVOs2) {
                SaleInvoiceDetail invoiceDetail = new SaleInvoiceDetail();
                BeanUtils.copyProperties((Object)vo2, (Object)invoiceDetail);
                invoiceDetails.add(invoiceDetail);
            }
        } else {
            ArrayList<SaleInvoiceDetailVO> payInvoiceDetailVOsE = new ArrayList<SaleInvoiceDetailVO>();
            for (SaleInvoiceDetailVO vo : saleInvoiceDetailVOs) {
                boolean matchFlag = false;
                for (SaleInvoiceDetailVO vo2 : payInvoiceDetailVOsE) {
                    if (!vo2.getSeq().equals(vo.getSeq())) continue;
                    matchFlag = true;
                    invoiceNo = vo2.getInvoiceNo();
                    if (!invoiceNo.contains(vo.getInvoiceNo())) {
                        invoiceNo = invoiceNo + "," + vo.getInvoiceNo();
                    }
                    vo2.setInvoiceNo(invoiceNo);
                    vo2.setQuantity(vo2.getQuantity().add(vo.getQuantity()));
                    vo2.setTaxAmt(vo2.getTaxAmt().add(vo.getTaxAmt()));
                    vo2.setUntaxAmt(vo2.getUntaxAmt().add(vo.getUntaxAmt()));
                    vo2.setAmount(vo2.getAmount().add(vo.getAmount()));
                }
                if (matchFlag) continue;
                payInvoiceDetailVOsE.add(vo);
            }
            for (SaleInvoiceDetailVO vo2 : payInvoiceDetailVOsE) {
                SaleInvoiceDetail invoiceDetail = new SaleInvoiceDetail();
                BeanUtils.copyProperties((Object)vo2, (Object)invoiceDetail);
                invoiceDetails.add(invoiceDetail);
            }
        }
        int invoiceDetailCount = invoiceDetails.size();
        logger.error("invoiceDetails===" + invoiceDetailCount);
        while (invoiceDetails.size() != 0 || sampsInOrders.size() != 0) {
            this.collectSameOrderSamps(resp, invoiceDetails, sampsInOrders, bill.getSource());
        }
        BigDecimal amtDif = resp.getOrderAmount().subtract(resp.getInvoiceAmount());
        if (forSigned) {
            if (resp.getInvoiceUntaxAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u96f6,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            if (resp.getInvoiceUntaxAmt().add(resp.getInvoiceTaxAmt()).compareTo(resp.getInvoiceAmount()) != 0) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d+\u7a0e\u989d\u603b\u548c\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            if (amtDif.compareTo(BigDecimal.ZERO) != 0) {
                throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u5185\u7684\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4,\u76f8\u5dee " + amtDif + ",\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            for (int j = 0; j < 6; ++j) {
                MatchingResult r = (MatchingResult)resp.getSummaries().get(j);
                if (0 != r.getMatched()) continue;
                throw new PfscExtBusinessException("18000", r.getItemName() + "\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
        }
        if ((amtDif = resp.getInvoiceUntaxAmt().subtract(resp.getOrderUntaxAmt())).compareTo(BigDecimal.ZERO) != 0) {
            if (invoiceDetailCount == 0) {
                this.adjustUnTaxAmount(resp, amtDif);
            } else {
                this.adjustUnTaxAmountWithInvoice(resp);
            }
        }
        if (forSigned) {
            this.updateOrderStatus(resp);
            this.updateSampStatusAndUnTaxAmt(resp);
            logger.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + bill.getApplyNo());
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            Long companyId = busiInvoiceVerifyReqBO.getCompanyId();
            String companyName = busiInvoiceVerifyReqBO.getCompanyName();
            List<PayableDetailPO> payLs = this.payableService.createApplyPayableBill(bill.getApplyNo(), companyId, companyName);
            if (payLs.size() > 0) {
                writeOffAmt = payLs.get(0).getNeedAgainstAmt();
            }
            logger.debug("\u51c6\u5907\u4ea7\u751fchu\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + bill.getApplyNo());
            BusiCreateOutstockInfoReqBO busiCreateOutstockInfoReqBO = new BusiCreateOutstockInfoReqBO();
            busiCreateOutstockInfoReqBO.setApplyNo(bill.getApplyNo());
            BusiCreateOutstockInfoRspBO busiCreateOutstockInfoRspBO = this.busiCreateOutstockInfoService.addOutstockInfo(busiCreateOutstockInfoReqBO);
            logger.debug("\u51c6\u5907\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u901a\u77e5\u5355\u53f7=" + bill.getApplyNo());
            BillApplyInfo forUpdate = new BillApplyInfo();
            forUpdate.setApplyNo(bill.getApplyNo());
            forUpdate.setBillStatus(BillStatus.SIGNED_IN.getCode());
            this.billApplyInfoMapper.updateByPrimaryKeySelective(forUpdate);
            logger.debug("\u51c6\u5907\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4e3a\u5df2\u6838\u5bf9(03),\u901a\u77e5\u5355\u53f7=" + bill.getApplyNo());
            SaleInvoiceInfo updInvoice = new SaleInvoiceInfo();
            updInvoice.setApplyNo(bill.getApplyNo());
            updInvoice.setInvoiceStatus("03");
            this.saleInvoiceInfoMapper.updateByPrimaryKeySelectiveA(updInvoice);
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u6d89\u53ca\u7684\u53d1\u7968\u7b7e\u6536\u5b8c\u6bd5,\u901a\u77e5\u5355\u53f7=" + bill.getApplyNo());
        }
    }

    private void collectSameOrderSamps(BusiApplyInvoiceVerifyRspBO resp, List<SaleInvoiceDetail> invoices, List<SaleItemInfo> sampsInOrders, String source) {
        ArrayList<SaleItemInfo> orders = new ArrayList<SaleItemInfo>();
        ArrayList<SaleInvoiceDetail> ivDetails = new ArrayList<SaleInvoiceDetail>();
        SaleItemInfo order = null;
        SaleInvoiceDetail detail = null;
        boolean orderOut = true;
        boolean ivOut = true;
        Long ordNo = null;
        if (sampsInOrders.size() > 0) {
            order = sampsInOrders.get(0);
            logger.error("order" + order.getSeq());
            ordNo = order.getSeq();
            orderOut = false;
        }
        if (invoices.size() > 0) {
            if (ordNo == null) {
                detail = invoices.get(0);
                ordNo = detail.getItemSeq();
                logger.error("detail" + ordNo);
            }
            ivOut = false;
        }
        while (!orderOut || !ivOut) {
            if (!orderOut) {
                order = sampsInOrders.get(0);
                if (ordNo.equals(order.getSeq())) {
                    if (order.getAmount() == null || order.getUntaxAmt() == null) {
                        logger.error("\u53d1\u7968\u6838\u5bf9,\u8ba2\u5355[" + ordNo + "]\u5185\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u548c\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38,amount=" + order.getAmount() + ",UntaxAmt=" + order.getUntaxAmt());
                        throw new PfscExtBusinessException("18000", "\u8ba2\u5355" + ordNo + "\u7684\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
                    }
                    logger.error("order+====" + order.getSeq());
                    orders.add(order);
                    sampsInOrders.remove(0);
                    if (sampsInOrders.size() == 0) {
                        orderOut = true;
                    }
                } else {
                    orderOut = true;
                }
            }
            if (ivOut) continue;
            detail = invoices.get(0);
            logger.error("detail+====" + ordNo + "-----" + detail.getItemSeq() + invoices.get(0));
            if (ordNo.equals(detail.getItemSeq())) {
                if (detail.getAmount() == null || detail.getUntaxAmt() == null) {
                    logger.error("\u53d1\u7968\u6838\u5bf9,\u53d1\u7968\u660e\u7ec6\u5185\u5546\u54c1[\u8ba2\u5355\u53f7:" + ordNo + "]\u7684\u542b\u7a0e\u91d1\u989d\u548c\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38,amount=" + detail.getAmount() + ",UntaxAmt=" + detail.getUntaxAmt());
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u7684\u8ba2\u5355" + ordNo + "\u7684\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
                }
                ivDetails.add(detail);
                invoices.remove(0);
                if (invoices.size() != 0) continue;
                ivOut = true;
                continue;
            }
            ivOut = true;
        }
        logger.debug("\u53d1\u7968\u6bd4\u5bf9,\u672c\u6b21\u6d89\u53ca\u8ba2\u5355\u53f7=" + ordNo + ",\u8ba2\u5355\u660e\u7ec6\u6570=" + orders.size() + ",\u53d1\u7968\u660e\u7ec6\u6570=" + ivDetails.size() + ",\u901a\u77e5\u5355=" + resp.getApplyNo());
        int j = 0;
        boolean equiped = false;
        InvoiceVeriySamp ordIvs = null;
        InvoiceVeriySamp ivIvs = null;
        while (true) {
            int ordersCnt = orders.size();
            int detailsCnt = ivDetails.size();
            if (ordersCnt == 0 && detailsCnt == 0) break;
            if (ordersCnt > 0) {
                order = (SaleItemInfo)orders.get(0);
                equiped = false;
                for (j = 0; j < detailsCnt; ++j) {
                    Long seq;
                    detail = (SaleInvoiceDetail)ivDetails.get(j);
                    Long itemseq = detail.getItemSeq();
                    if (itemseq.equals(seq = order.getSeq())) {
                        equiped = true;
                    }
                    if (!equiped) {
                        continue;
                    }
                    break;
                }
            } else {
                detail = (SaleInvoiceDetail)ivDetails.get(j);
            }
            ordIvs = new InvoiceVeriySamp();
            ivIvs = new InvoiceVeriySamp();
            ivIvs.setMatching(Integer.valueOf(0));
            if (ordersCnt > 0) {
                BeanUtils.copyProperties((Object)order, (Object)ordIvs);
                ordIvs.setPriceIntax(order.getSaleUnitPrice());
                ordIvs.setSaleOrderCode(order.getSaleOrderCode());
                ordIvs.setQuantity(order.getQuantity() == null ? "" : order.getQuantity().stripTrailingZeros().toPlainString());
                ordIvs.setMatching(Integer.valueOf(0));
                ordIvs.setItemName(order.getSkuName());
                ivIvs.setSaleOrderCode(order.getSaleOrderCode());
                if (equiped) {
                    if (order.getAmount().equals(detail.getAmount()) && order.getUntaxAmt().equals(detail.getUntaxAmt())) {
                        ordIvs.setMatching(Integer.valueOf(1));
                    } else {
                        ordIvs.setUntaxAmtAdjust(detail.getUntaxAmt());
                    }
                }
                orders.remove(0);
            }
            if (detailsCnt > 0 && (equiped || ordersCnt == 0)) {
                BeanUtils.copyProperties((Object)detail, (Object)ivIvs);
                ivIvs.setOrderId("" + order.getOrderId());
                ivIvs.setUnitName(detail.getUnitName());
                ivIvs.setQuantity("" + detail.getQuantity().stripTrailingZeros().toPlainString());
                ivIvs.setPriceUntax(detail.getAmount());
                ivIvs.setMatching(Integer.valueOf(0));
                if (equiped) {
                    ivIvs.setMatching(ordIvs.getMatching());
                }
                ivDetails.remove(j);
            }
            ordIvs.setJoiner(ivIvs);
            ordIvs.setOrderId("" + order.getOrderId());
            resp.getDetails().add(ordIvs);
            if (!new Integer(0).equals(ordIvs.getMatching())) continue;
            resp.setVerifyResult(Integer.valueOf(0));
        }
    }

    private void updateOrderStatus(BusiApplyInvoiceVerifyRspBO resp) {
        SaleOrderInfo payOrderUpd = new SaleOrderInfo();
        payOrderUpd.setApplyNo(resp.getApplyNo());
        payOrderUpd.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
        int cnt = this.saleOrderInfoMapper.updateByApplyNo(payOrderUpd);
        logger.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + resp.getApplyNo() + ",\u6570\u91cf=" + cnt);
    }

    private void adjustUnTaxAmount(BusiApplyInvoiceVerifyRspBO resp, BigDecimal difAmt) {
        int cnt = resp.getDetails().size();
        boolean orderAmtIsMore = difAmt.compareTo(BigDecimal.ZERO) < 0;
        difAmt = difAmt.abs();
        BigDecimal avgAmt = difAmt.divide(new BigDecimal("" + cnt), 4);
        avgAmt = avgAmt.add(new BigDecimal("0.01"));
        logger.debug("\u8ba2\u5355\u660e\u7ec6\u4e0d\u542b\u7a0e\u4ef7\u8c03\u6574,\u8bb0\u5f55\u6570=" + cnt + ",\u9700\u8c03\u6574\u603b\u91d1\u989d=" + difAmt + ",\u6bcf\u7b14\u8c03\u6574=" + avgAmt + ",\u5f00\u7968\u901a\u77e5\u5355=" + resp.getApplyNo());
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp ordSamp = (InvoiceVeriySamp)resp.getDetails().get(i);
            if (ordSamp.getAmount() == null) continue;
            BigDecimal amt = ordSamp.getUntaxAmtAdjust();
            if (amt == null) {
                amt = ordSamp.getUntaxAmt();
            }
            amt = orderAmtIsMore ? amt.subtract(avgAmt) : amt.add(avgAmt);
            ordSamp.setUntaxAmtAdjust(amt);
            difAmt = difAmt.subtract(avgAmt);
            if (difAmt.compareTo(avgAmt) < 0) {
                avgAmt = difAmt;
            }
            if (difAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    private void adjustUnTaxAmountWithInvoice(BusiApplyInvoiceVerifyRspBO resp) {
        int cnt = resp.getDetails().size();
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp ordSamp = (InvoiceVeriySamp)resp.getDetails().get(i);
            InvoiceVeriySamp ivDetail = ordSamp.getJoiner();
            if (ivDetail == null) continue;
            ordSamp.setUntaxAmtAdjust(ivDetail.getUntaxAmt());
            if (ivDetail.getTaxRate() == null || ivDetail.getTaxRate().compareTo(BigDecimal.ZERO) <= 0) continue;
            ordSamp.setTaxRate(ivDetail.getTaxRate());
        }
    }

    private void updateSampStatusAndUnTaxAmt(BusiApplyInvoiceVerifyRspBO resp) {
        int cnt = resp.getDetails().size();
        PayItemInfo forUpdate = new PayItemInfo();
        int updcnt = 0;
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp samp = (InvoiceVeriySamp)resp.getDetails().get(i);
            if (samp.getSeq() == null || samp.getAmount() == null) continue;
            forUpdate.setSeq(samp.getSeq());
            forUpdate.setTaxAmt(null);
            forUpdate.setUntaxAmt(null);
            forUpdate.setTaxRate(null);
            if (samp.getUntaxAmtAdjust() != null) {
                if (samp.getTaxRate() != null) {
                    forUpdate.setTaxRate(samp.getTaxRate());
                }
                forUpdate.setUntaxAmt(samp.getUntaxAmtAdjust());
                forUpdate.setTaxAmt(samp.getAmount().subtract(samp.getUntaxAmtAdjust()));
            }
            forUpdate.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
            logger.debug("\u53d1\u7968\u7b7e\u6536,\u5546\u54c1\u4e0d\u542b\u7a0e\u91d1\u989d\u53ca\u7a0e\u989d\u8c03\u6574,seq=" + samp.getSeq() + ",\u65b0\u4e0d\u542b\u7a0e\u989d=" + forUpdate.getUntaxAmt() + ",\u7a0e\u989d=" + forUpdate.getTaxAmt());
            this.payItemInfoMapper.updateByPrimaryKeySelective(forUpdate);
            ++updcnt;
        }
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u7b7e\u6536\u5e76\u81ea\u52a8\u8c03\u6574\u72b6\u6001\u3001\u4e0d\u542b\u7a0e\u91d1\u989d,\u6d89\u53ca\u8bb0\u5f55\u6570=" + updcnt);
    }

    private String getBillApplyNo() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        String prefix = "KPSQ";
        String maxNum = this.billApplyInfoMapper.selectMaxPayNoNum(prefix + dateL);
        String num = "000001";
        if (maxNum != null && !"".equals(maxNum)) {
            num = String.format("%06d", Integer.parseInt(maxNum) + 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(dateL).append(num);
        return sb.toString();
    }
}

