/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.logistics.api.UlcOrderCreateAbilityService;
import com.tydic.logistics.api.bo.UlcOrderCreateAbilityAddressReqDataBo;
import com.tydic.logistics.api.bo.UlcOrderCreateAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderCreateAbilityRspBo;
import com.tydic.pfscext.api.busi.BusiApplyMailForInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailForInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailForInvoiceRspBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.vo.BusiApplyMailVO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.JdexpressToken;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiJdExpressService;
import com.tydic.pfscext.external.api.bo.JdexpressTokenVO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.JdExpressTokenService;
import com.tydic.pfscext.service.busi.impl.BusiApplyMailForImportInvoiceService;
import com.tydic.pfscext.utils.FscStringUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiApplyMailForInvoiceService"})
public class BusiApplyMailForInvoiceServiceImpl
implements BusiApplyMailForInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailForInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressConfigService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired(required=false)
    private BusiApplyMailForImportInvoiceService busiApplyMailForImportInvoiceService;
    @Autowired
    private UlcOrderCreateAbilityService ulcOrderCreateAbilityService;
    @Autowired
    private Environment prop;
    @Resource(name="logisticsCenterIdSeq")
    private OrderSequence logisticsCenterIdSeqService;

    @PostMapping(value={"makeMailForInvoice"})
    public BusiApplyMailForInvoiceRspBO makeMailForInvoice(@RequestBody BusiApplyMailForInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u8d77\u90ae\u5bc4\u53d1\u7968\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderName())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderProv())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u7701\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderCity())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u4eba\u6240\u5c5e\u5e02\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderAddr())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderPhone())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApplyMailVoList() == null || reqBO.getApplyMailVoList().isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        if ("1".equals(((BusiApplyMailVO)reqBO.getApplyMailVoList().get(0)).getIsImport())) {
            this.busiApplyMailForImportInvoiceService.process(reqBO);
            return new BusiApplyMailForInvoiceRspBO();
        }
        BusiApplyMailForInvoiceRspBO rspBO = new BusiApplyMailForInvoiceRspBO();
        try {
            this.processPS(rspBO, reqBO);
        }
        catch (Exception e) {
            logger.error("\u90ae\u5bc4\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        return rspBO;
    }

    private void processPS(BusiApplyMailForInvoiceRspBO rspBO, BusiApplyMailForInvoiceReqBO reqBO) {
        List toMailList = reqBO.getApplyMailVoList();
        QueryBillApplyForMailReqBO condition = new QueryBillApplyForMailReqBO();
        condition.setSource(reqBO.getSource());
        condition.setCompanyId(reqBO.getCompanyId());
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        condition.setKeyFields(keyFields);
        for (BusiApplyMailVO toMail : toMailList) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(toMail.getInvoceName());
            keyField.setName(toMail.getName());
        }
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(condition, null);
        boolean i = false;
        for (BusiApplyMailVO toMail : toMailList) {
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (!toMail.getInvoceName().equals(invoice.getInvoceName()) || !toMail.getName().equals(invoice.getName())) continue;
                invoices.add(invoice);
                iterator.remove();
            }
            if (invoices.isEmpty()) continue;
            InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
            BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(firstInvoice.getApplyNo());
            String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
            String city = FscStringUtils.valueOf(applyInfoPO.getCity());
            String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
            String town = FscStringUtils.valueOf(applyInfoPO.getTown());
            String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
            String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            Long outLogisticsOrderId = 0L;
            try {
                outLogisticsOrderId = this.logisticsCenterIdSeqService.nextId();
            }
            catch (Exception e) {
                logger.error("\u9500\u552e\u8ba2\u5355\u6dfb\u52a0\u5931\u8d25:" + e.toString());
            }
            UlcOrderCreateAbilityReqBo ulcOrderCreateAbilityReqBo = new UlcOrderCreateAbilityReqBo();
            ulcOrderCreateAbilityReqBo.setOrgCode("ULC_EMS");
            ulcOrderCreateAbilityReqBo.setBusiCode("ULC");
            ulcOrderCreateAbilityReqBo.setOutLogisticsOrderId(outLogisticsOrderId.toString());
            ulcOrderCreateAbilityReqBo.setOutOrderId(outLogisticsOrderId.toString());
            ulcOrderCreateAbilityReqBo.setCompanyId("CHINA_POST");
            ulcOrderCreateAbilityReqBo.setProductCode("113124300000691");
            ulcOrderCreateAbilityReqBo.setExtValue1("B");
            ulcOrderCreateAbilityReqBo.setExtValue2("2");
            ulcOrderCreateAbilityReqBo.setExtValue3("1");
            ArrayList<UlcOrderCreateAbilityAddressReqDataBo> ulcOrderCreateAbilityAddressReqDataBos = new ArrayList<UlcOrderCreateAbilityAddressReqDataBo>();
            UlcOrderCreateAbilityAddressReqDataBo ulcOrderCreateAbilityAddressReqDataBo = new UlcOrderCreateAbilityAddressReqDataBo();
            ulcOrderCreateAbilityAddressReqDataBo.setType("2");
            ulcOrderCreateAbilityAddressReqDataBo.setUserName(reqBO.getSenderName());
            ulcOrderCreateAbilityAddressReqDataBo.setPhone(reqBO.getSenderPhone());
            ulcOrderCreateAbilityAddressReqDataBo.setProvince(reqBO.getSenderProv());
            ulcOrderCreateAbilityAddressReqDataBo.setCity(reqBO.getSenderCity());
            ulcOrderCreateAbilityAddressReqDataBo.setCounty(reqBO.getSenderCounty());
            ulcOrderCreateAbilityAddressReqDataBo.setAddressDetail(reqBO.getSenderAddr());
            ulcOrderCreateAbilityAddressReqDataBos.add(ulcOrderCreateAbilityAddressReqDataBo);
            UlcOrderCreateAbilityAddressReqDataBo ulcOrderCreateAbilityAddressReqDataBo3 = new UlcOrderCreateAbilityAddressReqDataBo();
            ulcOrderCreateAbilityAddressReqDataBo3.setType("3");
            ulcOrderCreateAbilityAddressReqDataBo3.setUserName(toMail.getName());
            ulcOrderCreateAbilityAddressReqDataBo3.setPhone(applyInfoPO.getTel());
            ulcOrderCreateAbilityAddressReqDataBo3.setProvince(province);
            ulcOrderCreateAbilityAddressReqDataBo3.setCity(city);
            ulcOrderCreateAbilityAddressReqDataBo3.setCounty(county);
            ulcOrderCreateAbilityAddressReqDataBo3.setAddressDetail(addressStr);
            ulcOrderCreateAbilityAddressReqDataBos.add(ulcOrderCreateAbilityAddressReqDataBo3);
            ulcOrderCreateAbilityReqBo.setAddressList(ulcOrderCreateAbilityAddressReqDataBos);
            logger.error("ulcOrderCreateAbilityReqBo:" + ulcOrderCreateAbilityReqBo);
            UlcOrderCreateAbilityRspBo ulcOrderCreateAbilityRspBo = this.ulcOrderCreateAbilityService.dealUlcOrderCreate(ulcOrderCreateAbilityReqBo);
            if (ulcOrderCreateAbilityRspBo != null && "0000".equals(ulcOrderCreateAbilityRspBo.getRespCode())) {
                String mailTicketNo = ulcOrderCreateAbilityRspBo.getMailNo();
                if (mailTicketNo != null) {
                    logger.error("ulcOrderCreateAbilityRspBo:" + ulcOrderCreateAbilityRspBo);
                    logger.error("mailTicketNo:" + mailTicketNo);
                    SaleInvoiceMailInfo po = new SaleInvoiceMailInfo();
                    po.setMailTicketNo(mailTicketNo);
                    po.setOperUnitNo(reqBO.getCompanyId());
                    po.setInvoiceType(firstInvoice.getInvoiceType());
                    po.setInvoceName(toMail.getInvoceName());
                    po.setMailStatus(InvoiceMailSentStatus.NOT_SENT.getCode());
                    po.setAddress(addressStr);
                    po.setReceiver(toMail.getName());
                    po.setTel(applyInfoPO.getMobile());
                    po.setJdAssignStatus(null);
                    po.setFailReason(null);
                    po.setCreateUser(reqBO.getUsername());
                    po.setCreateDate(new Date());
                    po.setSender(reqBO.getSenderName());
                    po.setSenderAddress(reqBO.getSenderAddr());
                    po.setSenderTel(reqBO.getSenderPhone());
                    po.setLogisticsCenterId(outLogisticsOrderId.toString());
                    this.saleInvoiceMailInfoMapper.insert(po);
                    for (int j = 0; j < invoices.size(); ++j) {
                        InvoiceForMailVO invoice = (InvoiceForMailVO)invoices.get(j);
                        SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                        saleInvoiceInfo.setInvoiceNo(invoice.getInvoiceNo());
                        saleInvoiceInfo.setMailTicketNo(mailTicketNo);
                        saleInvoiceInfo.setOrderId(j + 1);
                        this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(saleInvoiceInfo);
                    }
                    continue;
                }
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u90ae\u5bc4\u5931\u8d25,\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a");
                continue;
            }
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u90ae\u5bc4\u5931\u8d25");
        }
    }

    private String getPSMailTicketNos(SaleInvoiceMailInfo mailInfo) {
        Boolean success;
        JSONObject response;
        JSONObject responseitems;
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        String mailTicketNo = null;
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String reqStr = sb.append("{").append("\"OrderNormal\":").append("{").append("\"created_time\":").append("\"" + sd.format(new Date()) + "\",").append("\"logistics_provider\":").append("\"B\",").append("\"ecommerce_no\":").append("\"cnncmall\",").append("\"ecommerce_user_id\":").append("\"0\",").append("\"inner_channel\":").append("\"0\",").append("\"logistics_order_no\":").append("\"1\",").append("\"base_product_no\":").append("\"11312\",").append("\"biz_product_no\":").append("\"113124300000691\",").append("\"product_type\":").append("\" \",").append("\"note\":").append("\"\",").append("\"project_id\":").append("\"\",").append("\"sender\":").append("{").append("\"name\":").append("\"" + mailInfo.getSender() + "\",").append("\"mobile\":").append("\"" + mailInfo.getSenderTel() + "\",").append("\"prov\":").append("\"" + mailInfo.getSenderProv() + "\",").append("\"city\":").append("\"" + mailInfo.getSenderCity() + "\",").append("\"address\":").append("\"" + mailInfo.getSenderAddress() + "\"").append("},").append("\"receiver\":").append("{").append("\"name\":").append("\"" + mailInfo.getReceiver() + "\",").append("\"mobile\":").append("\"" + mailInfo.getTel() + "\",").append("\"prov\":").append("\"" + mailInfo.getReceiverProv() + "\",").append("\"city\":").append("\"" + mailInfo.getReceiverCity() + "\",").append("\"address\":").append("\"" + mailInfo.getAddress() + "\"").append("},").append("\"cargos\":").append("{").append("\"Cargo\":").append("[").append("{").append("\"cargo_name\":").append("\"" + mailInfo.getSender() + "\u7684\u53d1\u7968\"").append("}").append("]").append("}").append("}").append("}").toString();
        logger.info("\u8c03\u7528\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.prop.getProperty("ESB_EMS_ORDER_NUM_PARENT_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            logger.error("\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u5931\u8d25", (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            logger.error("\u8c03\u7528\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_EMS_ORDER_NUM_PARENT_URL") + "]");
            throw new RuntimeException("\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u5931\u8d25");
        }
        logger.info("\u8c03\u7528\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            logger.info("\u8c03\u7528\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u8c03\u7528\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        logger.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            logger.error("\u90ae\u653f\u4e0b\u5355\u53d6\u53f7\u5931\u8d25" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        JSONObject responses = (JSONObject)rspJsonObject.get((Object)"responses");
        if (responses != null && (responseitems = (JSONObject)responses.get((Object)"responseitems")) != null && (response = (JSONObject)responseitems.get((Object)"response")) != null && (success = response.getBoolean("success")).booleanValue()) {
            mailTicketNo = response.getString("waybill_no");
        }
        return mailTicketNo;
    }

    private List<String> getJDMailTicketNos(BusiApplyMailForInvoiceReqBO reqBO) {
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        if (null == token) {
            throw new PfscExtBusinessException("18000", "token\u4fe1\u606f\u672a\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4");
        }
        BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        List<String> mailTicketNos = new ArrayList();
        int toMailCount = reqBO.getApplyMailVoList().size();
        try {
            if (toMailCount > 100) {
                int circleTimes = toMailCount % 100 > 0 ? toMailCount / 100 + 1 : toMailCount / 100;
                for (int i = 0; i < circleTimes; ++i) {
                    int count = i == circleTimes - 1 && toMailCount % 100 > 0 ? toMailCount % 100 : 100;
                    mailTicketNos.addAll(this.busiJdExpressConfigService.applyBillCode(count, tokenVO));
                }
            } else {
                mailTicketNos = this.busiJdExpressConfigService.applyBillCode(toMailCount, tokenVO);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("18005", "\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", e);
        }
        if (null == mailTicketNos) {
            throw new PfscExtBusinessException("18005", "\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25");
        }
        if (mailTicketNos.size() < toMailCount) {
            logger.error("\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7\uff0c\u9700\u8981\u7684\u6570\u91cf\uff1a" + toMailCount + "\uff0c\u7533\u8bf7\u7684\u6570\u91cf\uff1a" + mailTicketNos.size());
            throw new PfscExtBusinessException("18005", "\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7");
        }
        return mailTicketNos;
    }
}

