/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQueryReceivable4WriteOffService;
import com.tydic.pfscext.api.busi.bo.BusiQueryReceivable4WriteOffDetailRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryReceivable4WriteOffReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryReceivable4WriteOffRspBO;
import com.tydic.pfscext.dao.RecvAbleInfoMapper;
import com.tydic.pfscext.dao.po.RecvAbleInfo;
import com.tydic.pfscext.dao.vo.RecvAbleInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.RecvAbleInfoRecvStatus;
import com.tydic.pfscext.enums.RecvAbleInfoRecvType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.SequenceNoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQueryReceivable4WriteOffServiceImpl
implements BusiQueryReceivable4WriteOffService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryReceivable4WriteOffServiceImpl.class);
    @Resource
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;

    public BusiQueryReceivable4WriteOffRspBO query(BusiQueryReceivable4WriteOffReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f85\u6838\u9500\u5e94\u6536\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecvAbleInfoVO recvAbleInfoVO = new RecvAbleInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)recvAbleInfoVO);
        recvAbleInfoVO.setSource(reqBO.getSource());
        recvAbleInfoVO.setOperUnitNo(reqBO.getCompanyId());
        recvAbleInfoVO.setRecvType(RecvAbleInfoRecvType.ABLE_RECV.getCode());
        recvAbleInfoVO.setOrderBy(" ORDER_DATE ASC ");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<RecvAbleInfo> recvAbleInfoList = this.recvAbleInfoMapper.selectListPage(recvAbleInfoVO, (Page<Map<String, Object>>)page);
        BusiQueryReceivable4WriteOffRspBO rspBO = new BusiQueryReceivable4WriteOffRspBO();
        ArrayList<BusiQueryReceivable4WriteOffDetailRspBO> rows = new ArrayList<BusiQueryReceivable4WriteOffDetailRspBO>();
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        for (RecvAbleInfo recvAbleInfo : recvAbleInfoList) {
            BusiQueryReceivable4WriteOffDetailRspBO row = new BusiQueryReceivable4WriteOffDetailRspBO();
            BeanUtils.copyProperties((Object)recvAbleInfo, (Object)row);
            row.setOrderId(String.valueOf(recvAbleInfo.getOrderId()));
            row.setToWriteoffAmt(recvAbleInfo.getRecvableAmt().subtract(recvAbleInfo.getWriteoffAmt()));
            row.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)recvAbleInfo.getSource())));
            String orgName = this.organizationInfoService.queryOrgName(recvAbleInfo.getPurchaseNo());
            row.setPurchaseName(orgName);
            orgName = this.organizationInfoService.queryOrgName(recvAbleInfo.getOperUnitNo());
            row.setOperUnitName(orgName);
            orgName = this.organizationInfoService.querySupplierName(recvAbleInfo.getSupplierNo());
            row.setSupplierName(orgName);
            row.setPurchaseProjectName(this.organizationInfoService.queryProjectName(recvAbleInfo.getPurchaseProjectId()).getAccountName());
            row.setPurchaseNo(recvAbleInfo.getPurchaseNo() + "");
            row.setPurchaseProjectId(recvAbleInfo.getPurchaseProjectId() + "");
            row.setRecvStatusDescr(this.enumsService.getDescr(RecvAbleInfoRecvStatus.getInstance(recvAbleInfo.getRecvStatus())));
            rows.add(row);
        }
        return rspBO;
    }
}

