/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQuerySaleOrderInfoService;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PaySataus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQuerySaleOrderInfoService"})
public class BusiQuerySaleOrderInfoServiceImpl
implements BusiQuerySaleOrderInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQuerySaleOrderInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;
    private static final String IS_OPER_UNIT_NO = "0";
    private static final String IS_OPER_UNIT_YES = "1";

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new PfscExtBusinessException("18000", "\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (IS_OPER_UNIT_NO.equals(reqBO.getIsOperUnit()) && null == reqBO.getPurchaseProjectId()) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                saleOrderCodeList.addAll(Arrays.asList(saleOrderCode.split(",")));
            }
            catch (Exception e) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        if (IS_OPER_UNIT_YES.equals(reqBO.getIsOperUnit())) {
            saleOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            SaleItemInfoVO vo = new SaleItemInfoVO();
            vo.setInspectionId(saleOrderInfo.getInspectionId());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(vo);
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            try {
                order.setPurchaseProjectName(this.organizationInfoService.queryProjectName(saleOrderInfo.getPurchaseProjectId()).getAccountName());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u3010UmcQryEnterpriseAccountDetailAbilityService\u3011\u5f02\u5e38");
            }
            LOGGER.debug("--\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f--" + order.getPayType());
            if (null != order.getPayType() && !"".equals(order.getPayType())) {
                order.setPayTypeStr(SaleOrderPayType.getInstance(order.getPayType()).getDescr());
            }
            LOGGER.debug("--\u4ed8\u6b3e\u65b9\u5f0f--" + order.getPayStatus());
            if (null != order.getPayStatus() && !"".equals(order.getPayStatus())) {
                order.setPayStatusStr(PaySataus.getInstance(order.getPayStatus()).getDescr());
            }
            orderList.add(order);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

