/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.base;

import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.ServiceReqLogMapper;
import com.tydic.pfscext.dao.po.ServiceReqLog;
import com.tydic.pfscext.utils.SpringApplicationContext;
import java.util.Date;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

public abstract class BasePayService<T> {
    private static final Logger logger = LoggerFactory.getLogger(BasePayService.class);
    @Autowired
    private ServiceReqLogMapper serviceReqLogMapper;

    protected T queryRspOrSaveLog(PfscExtReqBaseBO reqBO) {
        T t = null;
        return t;
    }

    protected void updateLog(PfscExtReqBaseBO reqBO, Exception exception) {
        String reqLogNo = reqBO.getReqLogNo();
        if (!StringUtils.hasText((String)reqLogNo)) {
            return;
        }
        try {
            this.updateLogCommitImmediate(reqBO, exception);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqBO.getReqLogNo());
        }
    }

    protected void updateLog(PfscExtReqBaseBO reqBO, T rspBO) {
        String reqLogNo = reqBO.getReqLogNo();
        if (!StringUtils.hasText((String)reqLogNo)) {
            return;
        }
        try {
            this.updateLogCommitImmediate(reqBO, rspBO);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo);
        }
    }

    protected abstract T fillRspBO(String var1);

    private T fillRspBODefault(String respPackage) {
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        return (T)JSONObject.toBean((JSONObject)jsonObject);
    }

    private T queryRspOrSaveLogCommitImmediate(PfscExtReqBaseBO reqBO) {
        String reqLogNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u670d\u52a1\u8bf7\u6c42\u7ed3\u679c\u6216\u8005\u4fdd\u5b58\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\uff08\u7acb\u5373\u63d0\u4ea4\u4e8b\u52a1\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(reqLogNo = reqBO.getReqLogNo()))) {
            return null;
        }
        ServiceReqLog serviceReqLog = this.serviceReqLogMapper.selectByPrimaryKey(reqLogNo);
        if (serviceReqLog != null) {
            T t = null;
            try {
                t = this.fillRspBO(serviceReqLog.getRespPackage());
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u54cd\u5e94\u62a5\u6587\u586b\u5145\u51fa\u53c2\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo, (Throwable)e);
                try {
                    t = this.fillRspBODefault(serviceReqLog.getRespPackage());
                }
                catch (Exception e2) {
                    logger.error("\u6839\u636e\u54cd\u5e94\u62a5\u6587\u586b\u5145\u51fa\u53c2\uff08\u9ed8\u8ba4\u65b9\u5f0f\uff09\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo, (Throwable)e2);
                }
            }
            return t;
        }
        serviceReqLog = new ServiceReqLog();
        serviceReqLog.setReqLogNo(reqLogNo);
        JSONObject jsonObject = JSONObject.fromObject((Object)reqBO);
        serviceReqLog.setReqPackage(jsonObject.toString());
        jsonObject = new JSONObject();
        jsonObject.put((Object)"respCode", (Object)"18000");
        jsonObject.put((Object)"respDesc", (Object)"\u5904\u7406\u4e2d");
        serviceReqLog.setRespPackage(jsonObject.toString());
        serviceReqLog.setCreateDate(new Date());
        this.processLog(serviceReqLog);
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            this.serviceReqLogMapper.insert(serviceReqLog);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo, (Throwable)e);
            transactionManager.rollback(transactionStatus);
        }
        return null;
    }

    private void updateLogCommitImmediate(PfscExtReqBaseBO reqBO, T rspBO) {
        String reqLogNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\uff08\u7acb\u5373\u63d0\u4ea4\u4e8b\u52a1\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(reqLogNo = reqBO.getReqLogNo()))) {
            return;
        }
        if (rspBO == null) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\uff08\u7acb\u5373\u63d0\u4ea4\u4e8b\u52a1\uff09\u5931\u8d25\uff0c\u51fa\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002\u6d41\u6c34\u53f7\uff1a" + reqLogNo);
            return;
        }
        JSONObject jsonObject = JSONObject.fromObject(rspBO);
        if (!StringUtils.hasText((String)jsonObject.getString("respCode"))) {
            jsonObject.remove("respCode");
            jsonObject.put((Object)"respCode", (Object)"0000");
        }
        if (!StringUtils.hasText((String)jsonObject.getString("respDesc"))) {
            jsonObject.remove("respDesc");
            jsonObject.put((Object)"respDesc", (Object)"\u6210\u529f");
        }
        ServiceReqLog serviceReqLog = new ServiceReqLog();
        serviceReqLog.setReqLogNo(reqLogNo);
        serviceReqLog.setRespPackage(jsonObject.toString());
        this.processLog(serviceReqLog);
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            this.serviceReqLogMapper.updateByPrimaryKeySelective(serviceReqLog);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo, (Throwable)e);
            transactionManager.rollback(transactionStatus);
        }
    }

    private void updateLogCommitImmediate(PfscExtReqBaseBO reqBO, Exception exception) {
        String reqLogNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\uff08\u7acb\u5373\u63d0\u4ea4\u4e8b\u52a1\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(reqLogNo = reqBO.getReqLogNo()))) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"respCode", (Object)"18000");
        jsonObject.put((Object)"respDesc", (Object)exception.getMessage());
        ServiceReqLog serviceReqLog = new ServiceReqLog();
        serviceReqLog.setReqLogNo(reqLogNo);
        serviceReqLog.setRespPackage(jsonObject.toString());
        this.processLog(serviceReqLog);
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        try {
            this.serviceReqLogMapper.updateByPrimaryKeySelective(serviceReqLog);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u8bf7\u6c42\u65e5\u5fd7\u5931\u8d25\u3002\u6d41\u6c34\u53f7:" + reqLogNo, (Throwable)e);
            transactionManager.rollback(transactionStatus);
        }
    }

    private void processLog(ServiceReqLog serviceReqLog) {
        String reqPackage = serviceReqLog.getReqPackage();
        if (StringUtils.hasText((String)reqPackage) && reqPackage.length() > 1000) {
            serviceReqLog.setReqPackage(reqPackage.substring(0, 1000));
        }
    }
}

