/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.tydic.pfscext.api.aisino.BusiBillDownloadService;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiBillDownloadRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleBillInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.PayOrderInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.aisino.api.BillDownloadExternalService;
import com.tydic.pfscext.external.aisino.api.BillItemInfoDownloadExtService;
import com.tydic.pfscext.external.aisino.api.bo.BillDownloadExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtReqBO;
import com.tydic.pfscext.external.aisino.api.bo.BillItemInfoExtRspBO;
import com.tydic.pfscext.external.aisino.api.bo.FpkjxxFptxxNewBO;
import com.tydic.pfscext.external.aisino.api.bo.GlobalInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiBillDownloadService"})
public class BusiBillDownloadServiceImpl
implements BusiBillDownloadService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillDownloadServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private BillDownloadExternalService billDownloadExternalService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleBillInfoMapper saleBillInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private BillItemInfoDownloadExtService billItemInfoDownloadExtService;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Value(value="${authorizationCode}")
    private String authorizationCode;
    @Value(value="${taxCode}")
    private String taxCode;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    private boolean isBusy = false;

    @PostMapping(value={"billDownloadExternal"})
    public BusiBillDownloadRspBO billDownloadExternal(@RequestBody BusiBillDownloadReqBO reqBO) {
        this.isBusy = true;
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        try {
            BusiBillDownloadRspBO busiBillDownloadRspBO = this.process();
            return busiBillDownloadRspBO;
        }
        finally {
            this.isBusy = false;
        }
    }

    private BusiBillDownloadRspBO process() {
        BusiBillDownloadRspBO rspBO = null;
        try {
            rspBO = new BusiBillDownloadRspBO();
            BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
            billApplyInfoVO.setBillStatus("02");
            billApplyInfoVO.setSource("1");
            List<BillApplyInfo> billApplyInfoList = this.billApplyInfoMapper.getList(billApplyInfoVO);
            if (billApplyInfoList.isEmpty()) {
                log.debug("\u65e0\u5f00\u7968\u72b6\u6001\u4e3a02(\u5f00\u7968\u4e2d)\u7684\u8bb0\u5f55,\u7a0b\u5e8f\u9000\u51fa");
                return rspBO;
            }
            if (billApplyInfoList != null && billApplyInfoList.size() > 0) {
                for (BillApplyInfo billApplyInfo : billApplyInfoList) {
                    BillDownloadExtReqBO reqBO = new BillDownloadExtReqBO();
                    GlobalInfoBO globalInfo = new GlobalInfoBO();
                    globalInfo.setTerminalCode("0");
                    if (billApplyInfo != null && "2".equals(billApplyInfo.getInvoiceType())) {
                        globalInfo.setAppId("ZZS_PT_DZFP");
                    } else {
                        globalInfo.setAppId("DZFP");
                    }
                    globalInfo.setTaxpayerId(this.taxCode);
                    globalInfo.setAuthorizationCode(this.authorizationCode);
                    FpkjxxFptxxNewBO fpkjxxFptxxNew = new FpkjxxFptxxNewBO();
                    fpkjxxFptxxNew.setDDH(billApplyInfo.getApplyNo());
                    fpkjxxFptxxNew.setFPQQLSH(billApplyInfo.getApplyNo());
                    fpkjxxFptxxNew.setNSRSBH(this.taxCode);
                    fpkjxxFptxxNew.setPDF_XZFS("3");
                    BillItemInfoExtReqBO billItemInfoExtReqBO = new BillItemInfoExtReqBO();
                    billItemInfoExtReqBO.setFpkjxxFptxxNew(fpkjxxFptxxNew);
                    billItemInfoExtReqBO.setGlobalInfo(globalInfo);
                    BillItemInfoExtRspBO billItemInfoExtRspBO = this.billItemInfoDownloadExtService.billItemInfoExt(billItemInfoExtReqBO);
                    log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25" + billItemInfoExtRspBO);
                    if (billItemInfoExtRspBO != null && "0000".equals(billItemInfoExtRspBO.getRespCode())) {
                        if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ() != null) {
                            SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                            saleInvoiceInfo.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                            saleInvoiceInfo.setInvoiceCode(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_DM());
                            saleInvoiceInfo.setInvoiceDate(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPRQ());
                            saleInvoiceInfo.setApplyNo(billApplyInfo.getApplyNo());
                            saleInvoiceInfo.setUntaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getHJBHSJE()));
                            saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                            saleInvoiceInfo.setAmt(saleInvoiceInfo.getUntaxAmt().add(saleInvoiceInfo.getTaxAmt()));
                            saleInvoiceInfo.setInvoiceStatus("1");
                            saleInvoiceInfo.setElectronicInvoiceUrl(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getPDF_URL());
                            saleInvoiceInfo.setElectronicInvoiceName(billApplyInfo.getApplyNo() + "\u7535\u5b50\u53d1\u7968");
                            saleInvoiceInfo.setName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHFMC());
                            saleInvoiceInfo.setTaxNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_NSRSBH());
                            saleInvoiceInfo.setAddress(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getXHF_DZDH());
                            saleInvoiceInfo.setPhone(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_SJ());
                            saleInvoiceInfo.setBankAcNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getXHF_YHZH());
                            saleInvoiceInfo.setBankName(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getGHF_YHZH());
                            if (billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKCE() != null) {
                                saleInvoiceInfo.setTaxAmt(new BigDecimal(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getKPHJSE()));
                            }
                            this.saleInvoiceInfoMapper.insertSelective(saleInvoiceInfo);
                        }
                        List<SaleItemInfo> saleItemInfos = this.saleItemInfoMapper.selectByApplyNoAndOrderId(billApplyInfo.getApplyNo(), null, null);
                        HashMap<Long, String> map = new HashMap<Long, String>();
                        for (SaleItemInfo saleItemInfo : saleItemInfos) {
                            map.put(saleItemInfo.getSeq(), saleItemInfo.getSkuName());
                        }
                        if (billItemInfoExtRspBO != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS() != null && billItemInfoExtRspBO.getFPMXXZ_XMXXS().size() > 0) {
                            for (BillItemBO fpmxxzXmxx : billItemInfoExtRspBO.getFPMXXZ_XMXXS()) {
                                SaleInvoiceDetail saleInvoiceDetail = new SaleInvoiceDetail();
                                if (map.get(fpmxxzXmxx.getZXBM()) != null) {
                                    saleInvoiceDetail.setItemName((String)map.get(fpmxxzXmxx.getZXBM()));
                                } else {
                                    saleInvoiceDetail.setItemName(fpmxxzXmxx.getXMMC());
                                }
                                saleInvoiceDetail.setSpecModel(fpmxxzXmxx.getGGXH());
                                saleInvoiceDetail.setUnitName("\u4e2a");
                                if (fpmxxzXmxx.getZXBM() != null) {
                                    saleInvoiceDetail.setItemSeq(Long.parseLong(fpmxxzXmxx.getZXBM()));
                                }
                                saleInvoiceDetail.setQuantity(new BigDecimal(fpmxxzXmxx.getXMSL()));
                                saleInvoiceDetail.setUntaxAmt(new BigDecimal(fpmxxzXmxx.getXMJE()));
                                saleInvoiceDetail.setTaxAmt(new BigDecimal(fpmxxzXmxx.getSE()));
                                saleInvoiceDetail.setAmount(saleInvoiceDetail.getUntaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                                saleInvoiceDetail.setTaxRate(new BigDecimal(fpmxxzXmxx.getSL()));
                                saleInvoiceDetail.setTaxClassCode(fpmxxzXmxx.getSWBM());
                                saleInvoiceDetail.setInvoiceNo(billItemInfoExtRspBO.getRESPONSE_FPMXXZ().getFP_HM());
                                saleInvoiceDetail.setSaleUnitPrice(new BigDecimal(fpmxxzXmxx.getXMDJ()));
                                this.saleInvoiceDetailMapper.insertSelective(saleInvoiceDetail);
                            }
                        }
                        BillApplyInfo billApply = new BillApplyInfo();
                        billApply.setApplyNo(billApplyInfo.getApplyNo());
                        billApply.setBillStatus("03");
                        billApply.setSignDate(new Date());
                        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
                        PayOrderInfoVO payOrderInfoVO = new PayOrderInfoVO();
                        payOrderInfoVO.setPayOrderStatus("6");
                        ArrayList<String> applyNoList = new ArrayList<String>();
                        applyNoList.add(billApplyInfo.getApplyNo());
                        payOrderInfoVO.setApplyNoList(applyNoList);
                        this.payOrderInfoMapper.updateForBillApply(payOrderInfoVO);
                        this.saleOrderInfoMapper.updateStatusByApplyNo(billApplyInfo.getApplyNo(), "02");
                        continue;
                    }
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u4e0b\u8f7d\u53d1\u7968\u5931\u8d25");
                }
            }
        }
        catch (PfscExtBusinessException e) {
            log.error("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u53d1\u7968\u548c\u53d1\u7968\u660e\u7ec6\u5931\u8d25", e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"isBusy"})
    public boolean isBusy() {
        return this.isBusy;
    }
}

