/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.pfscext.api.pay.CreatePayOrderService;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderReqBO;
import com.tydic.pfscext.api.pay.bo.CreatePayOrderRspBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.CreatePayOrderService"})
public class CreatePayOrderServiceImpl
implements CreatePayOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CreatePayOrderServiceImpl.class);
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Resource(name="payOrderSeq")
    private OrderSequence payOrderSeq;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Value(value="${web_url}")
    private String web_url;
    @Value(value="${service_url}")
    private String service_url;
    @Value(value="${openUnitNo}")
    private Long openUnitNo;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;

    @PostMapping(value={"createPayOrder"})
    public CreatePayOrderRspBO createPayOrder(@RequestBody CreatePayOrderReqBO reqBO) {
        CreatePayOrderRspBO rspBO = new CreatePayOrderRspBO();
        if (null == reqBO.getId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPaymentOrderType() || reqBO.getPaymentOrderType().equals("")) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String orderNo = reqBO.getId();
        try {
            PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo;
            OrgMerchantConfigPO orgMerchantConfigPO;
            String busiCode = "";
            Long merchantId = null;
            StringBuffer payOrderNo = new StringBuffer();
            String payAmt = "0";
            String detailName = "";
            String recAcctName = "";
            String receiptAcctNo = "";
            String payAcctNo = "";
            if (reqBO.getPaymentOrderType().equals("0")) {
                ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(orderNo);
                payOrderNo.append("PAYMENT-").append(applyPayInfoPO.getPayno());
                if (null == applyPayInfoPO.getPayAmt()) {
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                }
                BigDecimal payAmtB = applyPayInfoPO.getPayAmt().multiply(new BigDecimal(100));
                payAmt = payAmtB.setScale(0, 1).toString();
                orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(applyPayInfoPO.getSupplierId());
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                detailName = "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ed8\u6b3e";
                recAcctName = applyPayInfoPO.getRecAcctName();
                receiptAcctNo = applyPayInfoPO.getReceiptAcctNo();
                payAcctNo = applyPayInfoPO.getPayAcctNo();
            } else {
                PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(Long.valueOf(orderNo));
                payOrderNo.append("SERVICE-FEE-").append(orderNo);
                if (null == payOrderInfoPO.getActualAmount()) {
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a0");
                }
                BigDecimal payAmtC = payOrderInfoPO.getActualAmount().multiply(new BigDecimal(100));
                payAmt = payAmtC.setScale(0, 1).toString();
                orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(this.openUnitNo);
                busiCode = orgMerchantConfigPO.getBusiCode();
                merchantId = orgMerchantConfigPO.getMerchantId();
                detailName = "\u6210\u4ea4\u670d\u52a1\u8d39\u7f34\u8d39";
            }
            PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
            payProOrderAbilityServiceReqBo.setOutOrderId(payOrderNo.toString());
            payProOrderAbilityServiceReqBo.setBusiCode(busiCode);
            payProOrderAbilityServiceReqBo.setMerchantId(String.valueOf(merchantId));
            payProOrderAbilityServiceReqBo.setTotalFee(payAmt);
            payProOrderAbilityServiceReqBo.setDetailName(detailName);
            payProOrderAbilityServiceReqBo.setRemark("");
            payProOrderAbilityServiceReqBo.setNotifyUrl(this.service_url);
            payProOrderAbilityServiceReqBo.setReqWay("1");
            payProOrderAbilityServiceReqBo.setPayMethod(reqBO.getPayMethod());
            payProOrderAbilityServiceReqBo.setCreateIpAddress(reqBO.getIpAddress());
            payProOrderAbilityServiceReqBo.setCreateOperId(String.valueOf(reqBO.getUserId()));
            payProOrderAbilityServiceReqBo.setCreateOperIdName(reqBO.getName());
            payProOrderAbilityServiceReqBo.setRedirectUrl(this.web_url);
            JSONObject busiReqJson = new JSONObject();
            busiReqJson.put("payMemno", (Object)"111111111111111");
            if (reqBO.getPayMethod().equals(PayMethod.ICBC_E.getCode())) {
                JSONArray payeeInfos = new JSONArray();
                JSONObject payeeInfo = new JSONObject();
                payeeInfo.put("mallCode", (Object)"1001280909016202047");
                payeeInfo.put("mallName", (Object)"\u6d4b\u8bd5\u73af\u5883");
                payeeInfo.put("payeeCompanyName", (Object)recAcctName);
                payeeInfo.put("payeeSysflag", (Object)reqBO.getBankType());
                payeeInfo.put("payeeAccno", (Object)receiptAcctNo);
                payeeInfo.put("payAmount", (Object)payAmt);
                payeeInfos.add((Object)payeeInfo);
                JSONArray goodsInfos = new JSONArray();
                JSONObject goodsInfo = new JSONObject();
                goodsInfo.put("goodsSubId", (Object)"13412");
                goodsInfo.put("goodsName", (Object)"goodsName");
                goodsInfo.put("payeeCompanyName", (Object)recAcctName);
                goodsInfo.put("goodsNumber", (Object)"1");
                goodsInfo.put("goodsUnit", (Object)"1");
                goodsInfo.put("goodsAmt", (Object)"1");
                goodsInfos.add((Object)goodsInfo);
                busiReqJson.put("payeeInfos", (Object)payeeInfos);
                busiReqJson.put("goodsInfos", (Object)goodsInfos);
                String busiReqData = busiReqJson.toJSONString();
                logger.error("busiReqDataStr\uff1a" + busiReqData);
                payProOrderAbilityServiceReqBo.setBusiReqData(busiReqData);
            }
            if (null == (payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo)).getRespCode() || !payProOrderAbilityServiceRspBo.getRespCode().equals("0000")) {
                logger.error("\u521b\u5efa\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProOrderAbilityServiceRspBo.getRespDesc());
                throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:");
            }
            PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
            paymentFlowInfo.setOutOrderId(payOrderNo.toString());
            paymentFlowInfo.setPaymentFlowId(payProOrderAbilityServiceRspBo.getOrderId());
            paymentFlowInfo.setMerchantId(merchantId);
            paymentFlowInfo.setOrgId(reqBO.getOrgId());
            paymentFlowInfo.setOrderAmt(new BigDecimal(payProOrderAbilityServiceRspBo.getPayFee()));
            paymentFlowInfo.setOrderDesc(detailName);
            paymentFlowInfo.setPayChannel(reqBO.getPayChannel());
            paymentFlowInfo.setPayType(reqBO.getPayMethod());
            paymentFlowInfo.setWebUrl(this.web_url);
            paymentFlowInfo.setAsynUrl(this.service_url);
            paymentFlowInfo.setClientIp(reqBO.getIpAddress());
            paymentFlowInfo.setOrderRemark(payProOrderAbilityServiceRspBo.getRemark());
            paymentFlowInfo.setCreateUserId(reqBO.getUserId());
            paymentFlowInfo.setCreateUserName(reqBO.getName());
            paymentFlowInfo.setBusiReqData(payProOrderAbilityServiceRspBo.getBusiRspData());
            paymentFlowInfo.setPayOrderId(payProOrderAbilityServiceRspBo.getPayOrderId());
            paymentFlowInfo.setBankUrl(payProOrderAbilityServiceRspBo.getUrl());
            paymentFlowInfo.setBankFlowId(payProOrderAbilityServiceRspBo.getPayNotifyTransId());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(payProOrderAbilityServiceRspBo.getTradeTime());
            paymentFlowInfo.setPayTime(date);
            paymentFlowInfo.setCreateTime(new Date());
            paymentFlowInfo.setFlowFlag("00");
            this.paymentFlowInfoMapper.insertSelective(paymentFlowInfo);
            String jsonStr2 = JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            logger.error("\u521b\u5efa\u8ba2\u5355\u8fd4\u56de\u7ed3\u679c\uff1a" + jsonStr2);
            rspBO = (CreatePayOrderRspBO)JSON.parseObject((String)jsonStr2, CreatePayOrderRspBO.class);
            logger.error("\u652f\u4ed8\u6e20\u9053\u8fd4\u56de\u7ed3\u679c\uff1a" + rspBO.toString());
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u8ba2\u5355]\u5931\u8d25,\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u521b\u5efa\u8ba2\u5355\u5931\u8d25:");
        }
        return rspBO;
    }
}

