/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.pay.impl;

import com.tydic.payment.pay.ability.PayProAbleQueryOrderStatusAbilityService;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.pay.PayReturnInfoService;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoReqBO;
import com.tydic.pfscext.api.pay.bo.PayReturnInfoRspBO;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.pay.PayReturnInfoService"})
public class PayReturnInfoServiceImpl
implements PayReturnInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PayReturnInfoServiceImpl.class);
    @Autowired
    private PayProAbleQueryOrderStatusAbilityService payProAbleQueryOrderStatusAbilityService;
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;

    @PostMapping(value={"payReturnInfo"})
    public PayReturnInfoRspBO payReturnInfo(@RequestBody PayReturnInfoReqBO reqBO) {
        PayReturnInfoRspBO rspBO = new PayReturnInfoRspBO();
        if (null == reqBO.getBusiCode()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContent()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u52a0\u5bc6\u5185\u5bb9[content]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String content = reqBO.getContent();
            String retStr = PayCenterUtils.deCode((String)content, (String)this.publicKey);
            JSONObject jsonObject = JSONObject.fromObject((Object)retStr);
            if (null != jsonObject) {
                String outOrderId = jsonObject.getString("outOrderId");
                String resultCode = jsonObject.getString("resultCode");
                String resultMsg = jsonObject.getString("resultMsg");
                PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
                paymentFlowInfo.setOutOrderId(outOrderId);
                paymentFlowInfo.setPaymentStatus(resultCode);
                paymentFlowInfo.setOrderRemark(resultMsg);
                paymentFlowInfo.setResultJson(retStr);
                this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25,\uff1a" + e);
            throw new PfscExtBusinessException("18000", "\u89e3\u6790\u652f\u4ed8\u7ed3\u679c\u5931\u8d25:" + e);
        }
        return rspBO;
    }
}

