/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.pfscext.api.busi.BusiCreateEntryInfoService;
import com.tydic.pfscext.api.busi.BusiInvoiceVerifyService;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyRspBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.api.busi.vo.InvoiceVeriySamp;
import com.tydic.pfscext.api.busi.vo.MatchingResult;
import com.tydic.pfscext.api.notify.SendInvoiceReceiptService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceDetail;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayInvoiceDetailVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.CreateEntryInfoService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.atom.SourceMappingService;
import com.tydic.pfscext.utils.BeanUtils;
import com.tydic.pfscext.utils.MapToBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiInvoiceVerifyService"})
public class BusiInvoiceVerifyServiceImpl
implements BusiInvoiceVerifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiInvoiceVerifyServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private CreateEntryInfoService createEntryInfoService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;
    @Autowired
    private BusiCreateEntryInfoService busiCreateEntryInfoService;
    @Autowired
    private SendInvoiceReceiptService sendInvoiceReceiptService;

    @PostMapping(value={"invoiceVerify"})
    public BusiInvoiceVerifyRspBO invoiceVerify(@RequestBody BusiInvoiceVerifyReqBO busiInvoiceVerifyReqBO) {
        BillNotificationInfo bill;
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u6838\u5bf9\u7b7e\u6536\u670d\u52a1\u5165\u53c2=" + busiInvoiceVerifyReqBO);
        }
        String notificationNo = busiInvoiceVerifyReqBO.getNotificationNo();
        Long companyId = busiInvoiceVerifyReqBO.getCompanyId();
        if (null == companyId) {
            throw new PfscExtBusinessException("0001", "\u516c\u53f8ID\u5fc5\u987b\u8f93\u5165");
        }
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7(notifycationNo)\u5fc5\u987b\u8f93\u5165");
        }
        if (null == busiInvoiceVerifyReqBO.getSignMode()) {
            busiInvoiceVerifyReqBO.setSignMode(Integer.valueOf(0));
        }
        if ((bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo)) == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",companyId=" + companyId);
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7" + notificationNo + "\u4e0d\u5b58\u5728!");
        }
        if (!companyId.equals(bill.getOperNo())) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        String billSta = bill.getInvoiceStatus();
        NotificationInvoiceStatus nowSta = NotificationInvoiceStatus.getInstance(billSta);
        if (nowSta == null) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u6570\u636e\u5f02\u5e38,\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
        }
        if (NotificationInvoiceStatus.HAS_MAKE != nowSta) {
            if (busiInvoiceVerifyReqBO.getSignMode() == 1) {
                logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e0d\u662f\u5df2\u5f00\u7968(02),\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5355\u72b6\u6001=" + billSta);
                throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u901a\u77e5\u5355" + notificationNo + "\u72b6\u6001\u4e0d\u6b63\u786e,\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u624d\u53ef\u8fdb\u884c\u6838\u5bf9\u64cd\u4f5c");
            }
            busiInvoiceVerifyReqBO.setSignMode(Integer.valueOf(2));
        }
        List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u6d89\u53ca\u53d1\u7968\u6570\u91cf=" + invoices.size() + ",\u901a\u77e5\u5355\u53f7=" + notificationNo);
        if (invoices.size() == 0) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968,\u901a\u77e5\u5355\u53f7=" + notificationNo);
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u901a\u77e5\u5355" + notificationNo + "\u5bf9\u5e94\u7684\u53d1\u7968");
        }
        Statis ivStatis = this.payInvoiceInfoMapper.invoiceStatis(notificationNo);
        Statis ordStatis = this.payItemInfoMapper.orderStatis(notificationNo);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u8ba2\u5355\u5546\u54c1\u7edf\u8ba1=" + ordStatis);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u53d1\u7968\u5546\u54c1\u660e\u7ec6\u7edf\u8ba1=" + ivStatis);
        List<PayItemInfo> sampsInOrders = this.payItemInfoMapper.selectByNotifNoAndOrderId(notificationNo, null, null);
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u901a\u77e5\u5355\u5185\u5546\u54c1\u660e\u7ec6\u6570\u91cf=" + sampsInOrders.size() + ",\u901a\u77e5\u5355\u53f7=" + notificationNo);
        if (sampsInOrders.size() == 0) {
            logger.error("\u53d1\u7968\u6838\u5bf9\u5931\u8d25,\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + notificationNo);
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u901a\u77e5\u5bf9\u5e94\u7684\u8ba2\u5355\u53ca\u5176\u5546\u54c1\u660e\u7ec6");
        }
        BusiInvoiceVerifyRspBO resp = new BusiInvoiceVerifyRspBO();
        resp.setNotificationNo(notificationNo);
        resp.setSignMode(busiInvoiceVerifyReqBO.getSignMode());
        resp.setOrderCount(ordStatis.getGrpCount());
        resp.setOrderAmount(ordStatis.getTotAmt());
        resp.setOrderUntaxAmt(ordStatis.getTotUntaxAmt());
        resp.setOrderTaxAmt(ordStatis.getTotTaxAmt());
        resp.setInvoiceAmount(ivStatis.getTotAmt());
        resp.setInvoiceCount(ivStatis.getGrpCount());
        resp.setInvoiceTaxAmt(ivStatis.getTotTaxAmt());
        resp.setInvoiceUntaxAmt(ivStatis.getTotUntaxAmt());
        resp.setVerifyPersonId(busiInvoiceVerifyReqBO.getUserId());
        this.verify(busiInvoiceVerifyReqBO, resp, bill, invoices, sampsInOrders, busiInvoiceVerifyReqBO.getSignMode() == 1);
        if (resp.getVerifyResult() != null && !"".equals(resp.getVerifyResult())) {
            if (resp.getVerifyResult() == 1) {
                resp.setVerifyResultDescr("\u6838\u5bf9\u5339\u914d");
            } else if (resp.getVerifyResult() == 0) {
                resp.setVerifyResultDescr("\u6838\u5bf9\u5b58\u5728\u5dee\u5f02");
            }
        }
        return resp;
    }

    private void verify(final BusiInvoiceVerifyReqBO busiInvoiceVerifyReqBO, BusiInvoiceVerifyRspBO resp, BillNotificationInfo bill, List<PayInvoiceInfo> invoices, List<PayItemInfo> sampsInOrders, boolean forSigned) {
        String invoiceNo;
        PayInvoiceInfo invoice = invoices.get(0);
        resp.setSummaries(new ArrayList());
        resp.setDetails(new ArrayList());
        resp.setVerifyResult(Integer.valueOf(1));
        if (bill.getSupplierNo() != null && bill.getSupplierNo() == 1L) {
            invoice.setName(StringUtils.hasText((String)invoice.getName()) ? invoice.getName() : bill.getInvoceName());
            invoice.setTaxNo(StringUtils.hasText((String)invoice.getTaxNo()) ? invoice.getTaxNo() : bill.getTaxNo());
            invoice.setAddress(StringUtils.hasText((String)invoice.getAddress()) ? invoice.getAddress() : bill.getAddr());
            invoice.setPhone(StringUtils.hasText((String)invoice.getPhone()) ? invoice.getPhone() : bill.getPhone());
            invoice.setBankName(StringUtils.hasText((String)invoice.getBankName()) ? invoice.getBankName() : bill.getBankName());
            invoice.setBankAcNo(StringUtils.hasText((String)invoice.getBankAcNo()) ? invoice.getBankAcNo() : bill.getBankAccNo());
        }
        resp.getSummaries().add(new MatchingResult().compare("\u540d\u79f0", (Object)bill.getInvoceName(), (Object)invoice.getName()));
        resp.getSummaries().add(new MatchingResult().compare("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Object)bill.getTaxNo(), (Object)invoice.getTaxNo()));
        resp.getSummaries().add(new MatchingResult().compare("\u5730\u5740", (Object)bill.getAddr(), (Object)invoice.getAddress()));
        resp.getSummaries().add(new MatchingResult().compare("\u7535\u8bdd", (Object)bill.getPhone(), (Object)invoice.getPhone()));
        resp.getSummaries().add(new MatchingResult().compare("\u5f00\u6237\u884c", (Object)bill.getBankName(), (Object)invoice.getBankName()));
        resp.getSummaries().add(new MatchingResult().compare("\u8d26\u6237", (Object)bill.getBankAccNo(), (Object)invoice.getBankAcNo()));
        resp.getSummaries().add(new MatchingResult().compare("\u6c47\u603b\u91d1\u989d(\u542b\u7a0e)", (Object)resp.getOrderAmount(), (Object)resp.getInvoiceAmount()));
        resp.getSummaries().add(new MatchingResult().compare("\u6c47\u603b\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Object)resp.getOrderUntaxAmt(), (Object)resp.getInvoiceUntaxAmt()));
        resp.getSummaries().add(new MatchingResult().compare("\u7a0e\u989d", (Object)resp.getOrderTaxAmt(), (Object)resp.getInvoiceTaxAmt()));
        for (MatchingResult result : resp.getSummaries()) {
            if (!new Integer(0).equals(result.getMatched())) continue;
            resp.setVerifyResult(Integer.valueOf(0));
            break;
        }
        List<PayInvoiceDetailVO> payInvoiceDetailVOs = this.payInvoiceInfoMapper.selectJoinDetail(invoice);
        ArrayList<Map<String, Object>> invoiceDetails = new ArrayList<Map<String, Object>>();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(bill.getSource()) || OrderSource.CONSULT_PRICE.getCode().equals(bill.getSource()) || OrderSource.COAL_AREA.getCode().equals(bill.getSource())) {
            ArrayList<PayInvoiceDetailVO> payInvoiceDetailVOs2 = new ArrayList<PayInvoiceDetailVO>();
            for (PayInvoiceDetailVO vo : payInvoiceDetailVOs) {
                boolean matchFlag = false;
                for (PayInvoiceDetailVO vo2 : payInvoiceDetailVOs2) {
                    if (!vo2.getOrderId().equals(vo.getOrderId()) || !vo2.getItemNo().equals(vo.getItemNo())) continue;
                    matchFlag = true;
                    invoiceNo = vo2.getInvoiceNo();
                    if (!invoiceNo.contains(vo.getInvoiceNo())) {
                        invoiceNo = invoiceNo + "," + vo.getInvoiceNo();
                    }
                    vo2.setInvoiceNo(invoiceNo);
                    vo2.setQuantity(vo2.getQuantity().add(vo.getQuantity()));
                    vo2.setTaxAmt(vo2.getTaxAmt().add(vo.getTaxAmt()));
                    vo2.setUntaxAmt(vo2.getUntaxAmt().add(vo.getUntaxAmt()));
                    vo2.setAmount(vo2.getAmount().add(vo.getAmount()));
                }
                if (matchFlag) continue;
                payInvoiceDetailVOs2.add(vo);
            }
            for (PayInvoiceDetailVO vo2 : payInvoiceDetailVOs2) {
                Map<String, Object> invoiceDetail;
                try {
                    invoiceDetail = BeanUtils.bean2Map(vo2);
                }
                catch (Exception e) {
                    logger.error("bean\u8f6c\u6362\u4e3amap\u53d1\u751f\u5f02\u5e38\u3002\u5bf9\u8c61=" + vo2);
                    throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u7cfb\u7edf\u5f02\u5e38");
                }
                invoiceDetails.add(invoiceDetail);
            }
        } else {
            ArrayList<PayInvoiceDetailVO> payInvoiceDetailVOsE = new ArrayList<PayInvoiceDetailVO>();
            for (PayInvoiceDetailVO vo : payInvoiceDetailVOs) {
                boolean matchFlag = false;
                for (PayInvoiceDetailVO vo2 : payInvoiceDetailVOsE) {
                    if (!vo2.getOrderId().equals(vo.getOrderId()) || !vo2.getExtSkuId().equals(vo.getExtSkuId())) continue;
                    matchFlag = true;
                    invoiceNo = vo2.getInvoiceNo();
                    if (!invoiceNo.contains(vo.getInvoiceNo())) {
                        invoiceNo = invoiceNo + "," + vo.getInvoiceNo();
                    }
                    vo2.setInvoiceNo(invoiceNo);
                    vo2.setQuantity(vo2.getQuantity().add(vo.getQuantity()));
                    vo2.setTaxAmt(vo2.getTaxAmt().add(vo.getTaxAmt()));
                    vo2.setUntaxAmt(vo2.getUntaxAmt().add(vo.getUntaxAmt()));
                    vo2.setAmount(vo2.getAmount().add(vo.getAmount()));
                }
                if (matchFlag) continue;
                payInvoiceDetailVOsE.add(vo);
            }
            for (PayInvoiceDetailVO vo2 : payInvoiceDetailVOsE) {
                Map<String, Object> invoiceDetail;
                try {
                    invoiceDetail = BeanUtils.bean2Map(vo2);
                }
                catch (Exception e) {
                    logger.error("bean\u8f6c\u6362\u4e3amap\u53d1\u751f\u5f02\u5e38\u3002\u5bf9\u8c61=" + vo2);
                    throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u7cfb\u7edf\u5f02\u5e38");
                }
                invoiceDetails.add(invoiceDetail);
            }
        }
        int invoiceDetailCount = invoiceDetails.size();
        while (invoiceDetails.size() != 0 || sampsInOrders.size() != 0) {
            this.collectSameOrderSamps(resp, invoiceDetails, sampsInOrders, bill.getSource());
        }
        BigDecimal amtDif = resp.getOrderAmount().subtract(resp.getInvoiceAmount());
        if (forSigned) {
            if (resp.getInvoiceUntaxAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e3a\u96f6,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            if (resp.getInvoiceUntaxAmt().add(resp.getInvoiceTaxAmt()).compareTo(resp.getInvoiceAmount()) != 0) {
                throw new PfscExtBusinessException("18000", "\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d+\u7a0e\u989d\u603b\u548c\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            if (amtDif.compareTo(BigDecimal.ZERO) != 0) {
                throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u5185\u7684\u8ba2\u5355\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4,\u76f8\u5dee " + amtDif + ",\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
            for (int j = 0; j < 6; ++j) {
                MatchingResult r = (MatchingResult)resp.getSummaries().get(j);
                if (0 != r.getMatched()) continue;
                throw new PfscExtBusinessException("18000", r.getItemName() + "\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
            }
        }
        if ((amtDif = resp.getInvoiceUntaxAmt().subtract(resp.getOrderUntaxAmt())).compareTo(BigDecimal.ZERO) != 0) {
            if (invoiceDetailCount == 0) {
                this.adjustUnTaxAmount(resp, amtDif);
            } else {
                this.adjustUnTaxAmountWithInvoice(resp);
            }
        }
        if (forSigned) {
            this.updateOrderStatus(resp);
            this.updateSampStatusAndUnTaxAmt(resp);
            logger.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
            String busiModel = "1";
            List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(bill.getNotificationNo());
            if (payPurchaseOrderInfoDetailBOs != null && payPurchaseOrderInfoDetailBOs.size() > 0) {
                busiModel = payPurchaseOrderInfoDetailBOs.get(0).getBusiModel();
            }
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            Long companyId = busiInvoiceVerifyReqBO.getCompanyId();
            List<PayableDetailPO> payLs = this.payableService.createPayableBill(bill.getNotificationNo(), companyId, busiInvoiceVerifyReqBO.getIsProfessionalOrgExt(), busiModel);
            if (payLs.size() > 0) {
                writeOffAmt = payLs.get(0).getNeedAgainstAmt();
            }
            logger.debug("\u51c6\u5907\u4ea7\u751f\u5165\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
            String entryNo = this.createEntryInfoService.createEntryInfo((PfscExtReqBaseBO)busiInvoiceVerifyReqBO, bill.getNotificationNo(), 2, writeOffAmt);
            logger.debug("\u51c6\u5907\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
            BillNotificationInfo forUpdate = new BillNotificationInfo();
            forUpdate.setNotificationNo(bill.getNotificationNo());
            forUpdate.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
            forUpdate.setVerifyPersonId(resp.getVerifyPersonId());
            forUpdate.setSignDate(new Date());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(forUpdate);
            logger.debug("\u51c6\u5907\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4e3a\u5df2\u6838\u5bf9(03),\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
            PayInvoiceInfo updInvoice = new PayInvoiceInfo();
            updInvoice.setNotificationNo(bill.getNotificationNo());
            updInvoice.setInvoiceStatus("03");
            this.payInvoiceInfoMapper.updateInvoiceStatus(updInvoice);
            new Thread(){

                @Override
                public void run() {
                    FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
                    fscRemindReqBO.setUserId(busiInvoiceVerifyReqBO.getUserId());
                    fscRemindReqBO.setOrderId(busiInvoiceVerifyReqBO.getOrgId());
                    fscRemindReqBO.setNotificationNo(busiInvoiceVerifyReqBO.getNotificationNo());
                    fscRemindReqBO.setUserId(busiInvoiceVerifyReqBO.getUserId());
                    logger.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3,\u53d1\u7968\u7b7e\u6536\u6210\u529f\u901a\u77e5\u670d\u52a1\u5165\u53c2: " + JSON.toString((Object)fscRemindReqBO));
                    BusiInvoiceVerifyServiceImpl.this.sendInvoiceReceiptService.send(fscRemindReqBO);
                }
            }.start();
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u6d89\u53ca\u7684\u53d1\u7968\u7b7e\u6536\u5b8c\u6bd5,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
        }
    }

    private void collectSameOrderSamps(BusiInvoiceVerifyRspBO resp, List<Map<String, Object>> invoices, List<PayItemInfo> sampsInOrders, String source) {
        ArrayList<PayItemInfo> orders = new ArrayList<PayItemInfo>();
        ArrayList<PayInvoiceDetail> ivDetails = new ArrayList<PayInvoiceDetail>();
        PayItemInfo order = null;
        PayInvoiceDetail detail = null;
        boolean orderOut = true;
        boolean ivOut = true;
        Long ordNo = null;
        if (sampsInOrders.size() > 0) {
            order = sampsInOrders.get(0);
            ordNo = order.getOrderId();
            orderOut = false;
        }
        if (invoices.size() > 0) {
            if (ordNo == null) {
                detail = MapToBean.copy(invoices.get(0), new PayInvoiceDetail());
                ordNo = detail.getOrderId();
            }
            ivOut = false;
        }
        while (!orderOut || !ivOut) {
            if (!orderOut) {
                order = sampsInOrders.get(0);
                if (ordNo.equals(order.getOrderId())) {
                    if (order.getAmount() == null || order.getUntaxAmt() == null) {
                        logger.error("\u53d1\u7968\u6838\u5bf9,\u8ba2\u5355[" + ordNo + "]\u5185\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u548c\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38,amount=" + order.getAmount() + ",UntaxAmt=" + order.getUntaxAmt());
                        throw new PfscExtBusinessException("18000", "\u8ba2\u5355" + ordNo + "\u7684\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
                    }
                    orders.add(order);
                    sampsInOrders.remove(0);
                    if (sampsInOrders.size() == 0) {
                        orderOut = true;
                    }
                } else {
                    orderOut = true;
                }
            }
            if (ivOut) continue;
            detail = MapToBean.copy(invoices.get(0), new PayInvoiceDetail());
            if (ordNo.equals(detail.getOrderId())) {
                if (detail.getAmount() == null || detail.getUntaxAmt() == null) {
                    logger.error("\u53d1\u7968\u6838\u5bf9,\u53d1\u7968\u660e\u7ec6\u5185\u5546\u54c1[\u8ba2\u5355\u53f7:" + ordNo + "]\u7684\u542b\u7a0e\u91d1\u989d\u548c\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38,amount=" + detail.getAmount() + ",UntaxAmt=" + detail.getUntaxAmt());
                    throw new PfscExtBusinessException("18000", "\u53d1\u7968\u660e\u7ec6\u7684\u8ba2\u5355" + ordNo + "\u7684\u5546\u54c1\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u6570\u636e\u5f02\u5e38");
                }
                ivDetails.add(detail);
                invoices.remove(0);
                if (invoices.size() != 0) continue;
                ivOut = true;
                continue;
            }
            ivOut = true;
        }
        logger.debug("\u53d1\u7968\u6bd4\u5bf9,\u672c\u6b21\u6d89\u53ca\u8ba2\u5355\u53f7=" + ordNo + ",\u8ba2\u5355\u660e\u7ec6\u6570=" + orders.size() + ",\u53d1\u7968\u660e\u7ec6\u6570=" + ivDetails.size() + ",\u901a\u77e5\u5355=" + resp.getNotificationNo());
        int j = 0;
        boolean equiped = false;
        InvoiceVeriySamp ordIvs = null;
        InvoiceVeriySamp ivIvs = null;
        while (true) {
            int ordersCnt = orders.size();
            int detailsCnt = ivDetails.size();
            if (ordersCnt == 0 && detailsCnt == 0) break;
            if (ordersCnt > 0) {
                order = (PayItemInfo)orders.get(0);
                equiped = false;
                for (j = 0; j < detailsCnt; ++j) {
                    detail = (PayInvoiceDetail)ivDetails.get(j);
                    Long ordSkuId = order.getSkuId();
                    Long ivskuId = detail.getSkuId();
                    Long ordItemNo = order.getItemNo();
                    Long ivItemNo = detail.getItemNo();
                    Long ordInspId = order.getInspectionId();
                    String extSkuId = order.getExtSkuId();
                    String ivExtSkuId = detail.getExtSkuId();
                    Long ivInspId = detail.getInspectionId();
                    if (ordInspId.equals(ivInspId)) {
                        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                            if (extSkuId != null && extSkuId.equals(ivExtSkuId)) {
                                equiped = true;
                            }
                        } else if (ordSkuId != null && ordSkuId.equals(ivskuId) && ordItemNo != null && ordItemNo.equals(ivItemNo)) {
                            equiped = true;
                        }
                    }
                    if (!equiped) {
                        continue;
                    }
                    break;
                }
            } else {
                detail = (PayInvoiceDetail)ivDetails.get(j);
            }
            ordIvs = new InvoiceVeriySamp();
            ivIvs = new InvoiceVeriySamp();
            ivIvs.setMatching(Integer.valueOf(0));
            ordIvs.setJoiner(ivIvs);
            resp.getDetails().add(ordIvs);
            ordIvs.setOrderId("" + ordNo);
            if (ordersCnt > 0) {
                org.springframework.beans.BeanUtils.copyProperties((Object)order, (Object)ordIvs);
                ordIvs.setPriceIntax(order.getPurchaseUnitPrice());
                ordIvs.setPurchaseOrderCode(order.getPurchaseOrderCode());
                ordIvs.setQuantity(order.getQuantity() == null ? "" : order.getQuantity().stripTrailingZeros().toPlainString());
                ordIvs.setMatching(Integer.valueOf(0));
                ivIvs.setPurchaseOrderCode(order.getPurchaseOrderCode());
                if (equiped) {
                    if (order.getAmount().equals(detail.getAmount()) && order.getUntaxAmt().equals(detail.getUntaxAmt())) {
                        ordIvs.setMatching(Integer.valueOf(1));
                    } else {
                        ordIvs.setUntaxAmtAdjust(detail.getUntaxAmt());
                    }
                }
                orders.remove(0);
            }
            if (detailsCnt > 0 && (equiped || ordersCnt == 0)) {
                org.springframework.beans.BeanUtils.copyProperties((Object)detail, (Object)ivIvs);
                ivIvs.setOrderId("" + detail.getOrderId());
                ivIvs.setUnitName(detail.getItemUnit());
                ivIvs.setQuantity("" + detail.getQuantity().stripTrailingZeros().toPlainString());
                ivIvs.setPriceUntax(detail.getAmount());
                ivIvs.setMatching(Integer.valueOf(0));
                if (equiped) {
                    ivIvs.setMatching(ordIvs.getMatching());
                }
                ivDetails.remove(j);
            }
            if (!new Integer(0).equals(ordIvs.getMatching())) continue;
            resp.setVerifyResult(Integer.valueOf(0));
        }
    }

    private void updateOrderStatus(BusiInvoiceVerifyRspBO resp) {
        PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
        payOrderUpd.setNotificationNo(resp.getNotificationNo());
        payOrderUpd.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
        int cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
        logger.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + resp.getNotificationNo() + ",\u6570\u91cf=" + cnt);
    }

    private void adjustUnTaxAmount(BusiInvoiceVerifyRspBO resp, BigDecimal difAmt) {
        int cnt = resp.getDetails().size();
        boolean orderAmtIsMore = difAmt.compareTo(BigDecimal.ZERO) < 0;
        difAmt = difAmt.abs();
        BigDecimal avgAmt = difAmt.divide(new BigDecimal("" + cnt), 4);
        avgAmt = avgAmt.add(new BigDecimal("0.01"));
        logger.debug("\u8ba2\u5355\u660e\u7ec6\u4e0d\u542b\u7a0e\u4ef7\u8c03\u6574,\u8bb0\u5f55\u6570=" + cnt + ",\u9700\u8c03\u6574\u603b\u91d1\u989d=" + difAmt + ",\u6bcf\u7b14\u8c03\u6574=" + avgAmt + ",\u5f00\u7968\u901a\u77e5\u5355=" + resp.getNotificationNo());
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp ordSamp = (InvoiceVeriySamp)resp.getDetails().get(i);
            if (ordSamp.getAmount() == null) continue;
            BigDecimal amt = ordSamp.getUntaxAmtAdjust();
            if (amt == null) {
                amt = ordSamp.getUntaxAmt();
            }
            amt = orderAmtIsMore ? amt.subtract(avgAmt) : amt.add(avgAmt);
            ordSamp.setUntaxAmtAdjust(amt);
            difAmt = difAmt.subtract(avgAmt);
            if (difAmt.compareTo(avgAmt) < 0) {
                avgAmt = difAmt;
            }
            if (difAmt.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    private void adjustUnTaxAmountWithInvoice(BusiInvoiceVerifyRspBO resp) {
        int cnt = resp.getDetails().size();
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp ordSamp = (InvoiceVeriySamp)resp.getDetails().get(i);
            InvoiceVeriySamp ivDetail = ordSamp.getJoiner();
            if (ivDetail == null) continue;
            ordSamp.setUntaxAmtAdjust(ivDetail.getUntaxAmt());
            if (ivDetail.getTaxRate() == null || ivDetail.getTaxRate().compareTo(BigDecimal.ZERO) <= 0) continue;
            ordSamp.setTaxRate(ivDetail.getTaxRate());
        }
    }

    private void updateSampStatusAndUnTaxAmt(BusiInvoiceVerifyRspBO resp) {
        int cnt = resp.getDetails().size();
        PayItemInfo forUpdate = new PayItemInfo();
        int updcnt = 0;
        for (int i = 0; i < cnt; ++i) {
            InvoiceVeriySamp samp = (InvoiceVeriySamp)resp.getDetails().get(i);
            if (samp.getSeq() == null || samp.getAmount() == null) continue;
            forUpdate.setSeq(samp.getSeq());
            forUpdate.setTaxAmt(null);
            forUpdate.setUntaxAmt(null);
            forUpdate.setTaxRate(null);
            if (samp.getUntaxAmtAdjust() != null) {
                if (samp.getTaxRate() != null) {
                    forUpdate.setTaxRate(samp.getTaxRate());
                }
                forUpdate.setUntaxAmt(samp.getUntaxAmtAdjust());
                forUpdate.setTaxAmt(samp.getAmount().subtract(samp.getUntaxAmtAdjust()));
            }
            forUpdate.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
            logger.debug("\u53d1\u7968\u7b7e\u6536,\u5546\u54c1\u4e0d\u542b\u7a0e\u91d1\u989d\u53ca\u7a0e\u989d\u8c03\u6574,seq=" + samp.getSeq() + ",\u65b0\u4e0d\u542b\u7a0e\u989d=" + forUpdate.getUntaxAmt() + ",\u7a0e\u989d=" + forUpdate.getTaxAmt());
            this.payItemInfoMapper.updateByPrimaryKeySelective(forUpdate);
            ++updcnt;
        }
        logger.debug("\u53d1\u7968\u6838\u5bf9,\u7b7e\u6536\u5e76\u81ea\u52a8\u8c03\u6574\u72b6\u6001\u3001\u4e0d\u542b\u7a0e\u91d1\u989d,\u6d89\u53ca\u8bb0\u5f55\u6570=" + updcnt);
    }
}

