/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryBackMoneyByNotificationNoService;
import com.tydic.pfscext.api.busi.bo.BusiBackMoney;
import com.tydic.pfscext.api.busi.bo.BusiQryBackMoneyByNotificationNoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryBackMoneyByNotificationNoRspBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BusiBackMoneyPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.AmountUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryBackMoneyByNotificationNoService"})
public class BusiQryBackMoneyByNotificationNoServiceImpl
implements BusiQryBackMoneyByNotificationNoService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"qryBackMoneyByNotificationNo"})
    public BusiQryBackMoneyByNotificationNoRspBO qryBackMoneyByNotificationNo(@RequestBody BusiQryBackMoneyByNotificationNoReqBO reqBO) {
        if (StringUtils.isEmpty((String)reqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiQryBackMoneyByNotificationNoRspBO rspBO = new BusiQryBackMoneyByNotificationNoRspBO();
        rspBO.setNotificationNo(reqBO.getNotificationNo());
        ArrayList<BusiBackMoney> backMonies = new ArrayList<BusiBackMoney>();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(reqBO.getNotificationNo());
        ArrayList<String> orderCodes = new ArrayList<String>();
        for (PayPurchaseOrderInfoDetailBO payPurchaseOrderInfoDetailBO : payPurchaseOrderInfoDetailBOs) {
            orderCodes.add(payPurchaseOrderInfoDetailBO.getPurchaseOrderCode());
        }
        List<BusiBackMoneyPO> moneyPOS = this.saleOrderInfoMapper.getListPageForBackMoney(orderCodes, (Page<Map<String, Object>>)page);
        if (!CollectionUtils.isEmpty(moneyPOS)) {
            BigDecimal receiptAmt = new BigDecimal("0");
            String receiptProp = null;
            BigDecimal realAmt = new BigDecimal(0);
            for (BusiBackMoneyPO po : moneyPOS) {
                BusiBackMoney busiBackMoney = new BusiBackMoney();
                BeanUtils.copyProperties((Object)po, (Object)busiBackMoney);
                if (po.getPayableStatus() != null) {
                    busiBackMoney.setPayableStatusStr(PayableStatus.getInstance(po.getPayableStatus()).getDescr());
                }
                backMonies.add(busiBackMoney);
                rspBO.setSupplierName(po.getSupplierName());
                realAmt = realAmt.add(po.getPaidAmt());
                receiptAmt = receiptAmt.add(po.getPayableAmt());
            }
            receiptProp = AmountUtils.calcTaxRateEndWithPercentage(realAmt, receiptAmt);
            rspBO.setReceiptProp(receiptProp);
            rspBO.setRealAmt(realAmt);
            rspBO.setReceiptAmt(receiptAmt);
        }
        rspBO.setRows(backMonies);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

