/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.SumItemTotalBySeqService;
import com.tydic.pfscext.api.busi.bo.SumItemTotalBySeqReqBO;
import com.tydic.pfscext.api.busi.bo.SumItemTotalBySeqRspBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SumItemTotalBySeqServiceImpl
implements SumItemTotalBySeqService {
    private static final Logger logger = LoggerFactory.getLogger(SumItemTotalBySeqServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public SumItemTotalBySeqRspBO sumTotalAmt(SumItemTotalBySeqReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5408\u8ba1\u5546\u54c1\u660e\u7ec6\u603b\u91d1\u989d\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getSeqNos() == null || reqBO.getSeqNos().isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5408\u8ba1\u5546\u54c1\u660e\u7ec6\u603b\u91d1\u989d\u670d\u52a1-\u5546\u54c1\u660e\u7ec6seq\u7f16\u53f7\u5217\u8868[seqNos]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet<Long> inspectionIds = new HashSet<Long>();
        LinkedList<PayItemInfo> itemInfos = new LinkedList<PayItemInfo>();
        for (Object seqNo : reqBO.getSeqNos()) {
            PayItemInfo singleItem = this.payItemInfoMapper.selectByPrimaryKey((Long)seqNo);
            if (singleItem == null) {
                throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u975e\u5168\u9009\u65f6\uff0c\u5546\u54c1\u5e8f\u53f7" + seqNo + "\u65e0\u76f8\u5e94\u8bb0\u5f55");
            }
            itemInfos.add(singleItem);
            inspectionIds.add(singleItem.getInspectionId());
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (PayItemInfo itemInfo : itemInfos) {
            sumAmt = sumAmt.add(itemInfo.getAmount());
        }
        SumItemTotalBySeqRspBO rspBO = new SumItemTotalBySeqRspBO();
        rspBO.setCount(Integer.valueOf(inspectionIds.size()));
        rspBO.setTotalAmt(sumAmt);
        rspBO.setIsSendSms(Integer.valueOf(this.enumsService.queryIsSendSms()));
        return rspBO;
    }
}

