/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.api.busi.BusiApplyCreateNotificationService;
import com.tydic.pfscext.api.busi.bo.BusiApplyDriveNotiReqBO;
import com.tydic.pfscext.api.busi.bo.BusiNotificationReqBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.enums.BusiModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ApplyDriveNotiConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(ApplyDriveNotiConsumer.class);
    @Autowired
    private BusiApplyCreateNotificationService busiApplyCreateNotificationService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        String content = message.getContent();
        log.info("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u63a5\u53d7\u6d88\u606f\u53c2\u6570:" + content);
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        String s = jsonObject.get((Object)"applyDriveNotiOrder").toString();
        BusiApplyDriveNotiReqBO busiApplyDriveNotiReqBO = (BusiApplyDriveNotiReqBO)JSONObject.parseObject((String)s, BusiApplyDriveNotiReqBO.class);
        log.info("\u8f6c\u6362\u540e\u53c2\u6570\uff1a" + JSON.toJSONString((Object)busiApplyDriveNotiReqBO));
        List orderCodeList = busiApplyDriveNotiReqBO.getOrderCodeList();
        try {
            if (!CollectionUtils.isEmpty((Collection)orderCodeList)) {
                Map<Long, List<PayPurchaseOrderInfo>> orderMap = this.groupOrderBySupplier(orderCodeList);
                for (Map.Entry<Long, List<PayPurchaseOrderInfo>> entry : orderMap.entrySet()) {
                    Long supplierNo = entry.getKey();
                    List<PayPurchaseOrderInfo> orderInfos = entry.getValue();
                    ArrayList orderCodes = new ArrayList();
                    orderInfos.stream().forEach(payPurchaseOrderInfo -> orderCodes.add(payPurchaseOrderInfo.getPurchaseOrderCode()));
                    BusiNotificationReqBO busiNotificationReqBO = new BusiNotificationReqBO();
                    BeanUtils.copyProperties((Object)busiApplyDriveNotiReqBO, (Object)busiNotificationReqBO);
                    busiNotificationReqBO.setOrderCodes(orderCodes);
                    busiNotificationReqBO.setOperUnitNo(orderInfos.get(0).getOperUnitNo());
                    busiNotificationReqBO.setSupplierNo(supplierNo);
                    busiNotificationReqBO.setSource(orderInfos.get(0).getSource());
                    busiNotificationReqBO.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                    this.busiApplyCreateNotificationService.applyCreateNotification(busiNotificationReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u5931\u8d25" + e.getMessage());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private Map<Long, List<PayPurchaseOrderInfo>> groupOrderBySupplier(List<String> orderCodeList) {
        List<PayPurchaseOrderInfo> orderInfos = this.payPurchaseOrderInfoMapper.getListByOrderCodes(orderCodeList);
        Map<Long, List<PayPurchaseOrderInfo>> map = orderInfos.stream().collect(Collectors.groupingBy(PayPurchaseOrderInfo::getSupplierNo));
        return map;
    }
}

