/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.zm.bo.MakeBillApplyInfoMsgReqBO;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoQueryVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.service.atom.SplitApplyService;
import com.tydic.pfscext.service.busi.BusiGenerateApplyService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyRspBO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MakeApplyConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MakeApplyConsumer.class);
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private SplitApplyService splitApplyService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BusiGenerateApplyService busiGenerateApplyService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            String content = message.getContent();
            log.info("\u5f00\u7968\u7533\u8bf7\u5355\u5355\u53d1\u8d77-\u6d88\u8d39\u6d88\u606f\u53c2\u6570{}" + content);
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            String s = jsonObject.get((Object)"makeApply").toString();
            MakeBillApplyInfoMsgReqBO makeBillApplyInfoMsgReqBO = (MakeBillApplyInfoMsgReqBO)JSONObject.parseObject((String)s, MakeBillApplyInfoMsgReqBO.class);
            SaleOrderInfoQueryVO vo = new SaleOrderInfoQueryVO();
            vo.setOrderIdList(makeBillApplyInfoMsgReqBO.getOrderIds());
            vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            vo.setReconciliationStatus(ReconciliationStatus.AGREEMENT.getCode());
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListByOrderIds(vo);
            if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
                List<List<SaleOrderInfo>> splitOrders = this.splitApplyService.splitApply(saleOrderInfoList, makeBillApplyInfoMsgReqBO.getGroupWay());
                log.info("\u7533\u8bf7\u5355\u62c6\u5206\u7ed3\u679c" + JSON.toJSONString(splitOrders));
                for (List<SaleOrderInfo> splitOrder : splitOrders) {
                    try {
                        BusiGenerateApplyReqBO generateApplyReqBO = new BusiGenerateApplyReqBO();
                        BeanUtils.copyProperties((Object)makeBillApplyInfoMsgReqBO, (Object)((Object)generateApplyReqBO));
                        generateApplyReqBO.setSaleOrderInfoList(splitOrder);
                        BusiGenerateApplyRspBO busiGenerateApplyRspBO = this.busiGenerateApplyService.busiGenerateApply(generateApplyReqBO);
                        if (!"0000".equals(busiGenerateApplyRspBO.getRespCode())) continue;
                        List<Long> orderIdList = splitOrder.stream().map(SaleOrderInfo::getOrderId).collect(Collectors.toList());
                        this.updateUocBillStatus(orderIdList, OrderStatus.APPLIED);
                    }
                    catch (Exception e) {
                        log.error("\u5f00\u7968\u7533\u8bf7\u5355\u751f\u6210\u4e1a\u52a1\u5931\u8d25:" + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u7533\u8bf7\u53d1\u8d77-\u6d88\u8d39\u8005\u62a5\u9519" + e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    public void updateUocBillStatus(List<Long> orderIdList, OrderStatus orderStatus) {
        UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
        updateBillStatusReqBO.setOrderIds(orderIdList);
        updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
        this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
    }
}

