/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.pfscext.api.aisino.bo.BusiMakeNotificationReqBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.service.atom.SplitNotificationService;
import com.tydic.pfscext.service.busi.BusiGenerateNotificationService;
import com.tydic.pfscext.service.busi.BusiNotifyEcommerceInvoiceService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationRspBO;
import com.tydic.pfscext.service.busi.bo.BusiNotifyEcommerceInvoiceServiceReqBo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MakeNotificationConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MakeNotificationConsumer.class);
    @Autowired
    private SplitNotificationService splitNotificationService;
    @Autowired
    private BusiGenerateNotificationService busiGenerateNotificationService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BusiNotifyEcommerceInvoiceService busiNotifyEcommerceInvoiceService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            String content = message.getContent();
            log.info("\u5f00\u7968\u901a\u77e5\u5355\u53d1\u8d77-\u6d88\u8d39\u6d88\u606f\u53c2\u6570{}" + content);
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            String s = jsonObject.get((Object)"makeNotification").toString();
            BusiMakeNotificationReqBO busiMakeNotificationReqBO = (BusiMakeNotificationReqBO)JSONObject.parseObject((String)s, BusiMakeNotificationReqBO.class);
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            vo.setOrderIdList(busiMakeNotificationReqBO.getOrderIds());
            vo.setReconcilitionStatus(ReconciliationStatus.AGREEMENT.getCode());
            vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            List<PayPurchaseOrderInfoVO> purchaseOrderList = this.payPurchaseOrderInfoMapper.getListByCondition2(vo);
            if (!CollectionUtils.isEmpty(purchaseOrderList)) {
                List<List<PayPurchaseOrderInfo>> splitOrders = this.splitNotificationService.splitNotification(purchaseOrderList, busiMakeNotificationReqBO.getGroupWay());
                log.info("\u901a\u77e5\u5355\u62c6\u5206\u7ed3\u679c\uff1a" + JSON.toJSONString(splitOrders));
                for (List<PayPurchaseOrderInfo> splitOrder : splitOrders) {
                    try {
                        BusiGenerateNotificationReqBO reqBO = new BusiGenerateNotificationReqBO();
                        BeanUtils.copyProperties((Object)busiMakeNotificationReqBO, (Object)((Object)reqBO));
                        reqBO.setInvoiceInfo(busiMakeNotificationReqBO.getInvoiceInfo());
                        reqBO.setMailAddrInfo(busiMakeNotificationReqBO.getMailAddrInfo());
                        reqBO.setOrderInfoList(splitOrder);
                        reqBO.setIsApply(Integer.valueOf(busiMakeNotificationReqBO.getIsApplyDriveNoti()));
                        BusiGenerateNotificationRspBO rspBO = this.busiGenerateNotificationService.generateNotification(reqBO);
                        if (!"0000".equals(rspBO.getRespCode()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(splitOrder.get(0).getSource())) continue;
                        BusiNotifyEcommerceInvoiceServiceReqBo invoiceServiceReqBo = new BusiNotifyEcommerceInvoiceServiceReqBo();
                        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)invoiceServiceReqBo));
                        invoiceServiceReqBo.setBillNotificationInfoExt(rspBO.getBillNotificationInfoExt());
                        invoiceServiceReqBo.setPayPurchaseOrderInfoList(splitOrder);
                        this.busiNotifyEcommerceInvoiceService.notifyEcommerceForInvoice(invoiceServiceReqBo);
                    }
                    catch (Exception e) {
                        log.error("\u5f00\u7968\u901a\u77e5\u53d1\u8d77\u62a5\u9519\uff1a" + e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u901a\u77e5\u53d1\u8d77\u6d88\u8d39\u8005\u62a5\u9519" + e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

